/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.io.Serializable;

public final class Level
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int TRACE_INT = 5000;
    public static final int DEBUG_INT = 10000;
    public static final int SERVICE_INT = 15000;
    public static final int INFO_INT = 20000;
    public static final int WARN_INT = 30000;
    public static final int ERROR_INT = 40000;
    public static final int FATAL_INT = 50000;
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final Level TRACE = new Level(5000, "TRACE");
    public static final Level DEBUG = new Level(10000, "DEBUG");
    public static final Level SERVICE = new Level(15000, "SERVICE");
    public static final Level INFO = new Level(20000, "INFO");
    public static final Level WARN = new Level(30000, "WARN");
    public static final Level ERROR = new Level(40000, "ERROR");
    public static final Level FATAL = new Level(50000, "FATAL");
    public static final Level OFF = new Level(Integer.MAX_VALUE, "OFF");
    private int level;
    private String string;

    public static Level[] getLevels() {
        return new Level[]{TRACE, DEBUG, SERVICE, INFO, WARN, ERROR, FATAL, OFF};
    }

    private Level(int p, String s) {
        this.level = p;
        this.string = s;
    }

    public static Level toLevel(String level) {
        String s = level.toUpperCase();
        if ("TRACE".equals(s)) {
            return TRACE;
        }
        if ("DEBUG".equals(s)) {
            return DEBUG;
        }
        if ("SERVICE".equals(s)) {
            return SERVICE;
        }
        if ("INFO".equals(s)) {
            return INFO;
        }
        if ("WARN".equals(s)) {
            return WARN;
        }
        if ("ERROR".equals(s)) {
            return ERROR;
        }
        if ("FATAL".equals(s)) {
            return FATAL;
        }
        if ("OFF".equals(s)) {
            return OFF;
        }
        return DEBUG;
    }

    public static Level valueOf(String level) {
        return Level.toLevel(level);
    }

    public int toInt() {
        return this.level;
    }

    public String toString() {
        return this.string;
    }
}

