/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.spi.LocationInfo;
import org.mmbase.util.logging.AbstractSimpleImpl;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.logging.LoggingException;

public class ExceptionImpl
extends AbstractSimpleImpl
implements Logger {
    private String cat;
    private static Map<String, Logger> instances = new HashMap<String, Logger>();
    private static int exceptionLevel = 30000;
    private static Level staticLevel = Level.WARN;

    private ExceptionImpl(String c) {
        this.cat = c;
    }

    public static ExceptionImpl getLoggerInstance(String name) {
        if (instances.containsKey(name)) {
            return (ExceptionImpl)instances.get(name);
        }
        ExceptionImpl i = new ExceptionImpl(name);
        i.setLevel(staticLevel);
        instances.put(name, i);
        return i;
    }

    public static void configure(String c) {
        if (c != null) {
            StringTokenizer t = new StringTokenizer(c, ",");
            if (t.hasMoreTokens()) {
                exceptionLevel = Level.toLevel(t.nextToken()).toInt();
            }
            if (t.hasMoreTokens()) {
                Level l;
                staticLevel = l = Level.toLevel(t.nextToken());
                for (Logger log : instances.values()) {
                    log.setLevel(l);
                }
            }
        }
    }

    @Override
    protected final void log(String s, Level l) {
        if (l.toInt() >= this.level) {
            Throwable t = new Throwable();
            LocationInfo info = new LocationInfo(t, AbstractSimpleImpl.class.getName());
            System.out.println(info.getFileName() + ":" + info.getMethodName() + "." + info.getLineNumber() + ": " + s);
            System.out.println(Logging.stackTrace(t));
        }
        if (l.toInt() >= exceptionLevel) {
            throw new LoggingException(this.cat + ":" + s, l);
        }
    }
}

