/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.mmbase.util.logging.Level;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.logging.MDC;

public abstract class AbstractSimpleImpl
implements Logger {
    private static ThreadLocal<Map<String, Object>> MDC_VALUES = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            HashMap<String, Object> o = new HashMap<String, Object>();
            return o;
        }
    };
    protected int level = 20000;

    public static MDC getMDC() {
        return new MDC(){

            @Override
            public void put(String key, Object value) {
                if (value != null) {
                    ((Map)MDC_VALUES.get()).put(key, value);
                } else {
                    ((Map)MDC_VALUES.get()).remove(key);
                }
            }

            @Override
            public Object get(String key) {
                return ((Map)MDC_VALUES.get()).get(key);
            }
        };
    }

    @Override
    public void setLevel(Level p) {
        this.level = p.toInt();
    }

    protected void log(String s) {
    }

    protected void log(String s, Level level) {
        this.log(level.toString() + " " + s);
    }

    protected void log(Object s, Level level) {
        this.log("" + s, level);
    }

    protected void log(Object s, Level level, Throwable t) {
        this.log(s + "\n" + Logging.stackTrace(t), level);
    }

    @Override
    public void trace(Object m) {
        if (this.level <= 5000) {
            this.log(m, Level.TRACE);
        }
    }

    @Override
    public void trace(Object m, Throwable t) {
        if (this.level <= 5000) {
            this.log(m, Level.TRACE, t);
        }
    }

    @Override
    public void debug(Object m) {
        if (this.level <= 10000) {
            this.log(m, Level.DEBUG);
        }
    }

    @Override
    public void debug(Object m, Throwable t) {
        if (this.level <= 10000) {
            this.log(m, Level.DEBUG, t);
        }
    }

    @Override
    public void service(Object m) {
        if (this.level <= 15000) {
            this.log(m, Level.SERVICE);
        }
    }

    @Override
    public void service(Object m, Throwable t) {
        if (this.level <= 15000) {
            this.log(m, Level.SERVICE, t);
        }
    }

    @Override
    public void info(Object m) {
        if (this.level <= 20000) {
            this.log(m, Level.INFO);
        }
    }

    @Override
    public void info(Object m, Throwable t) {
        if (this.level <= 20000) {
            this.log(m, Level.INFO, t);
        }
    }

    @Override
    public void warn(Object m) {
        if (this.level <= 30000) {
            this.log(m, Level.WARN);
        }
    }

    @Override
    public void warn(Object m, Throwable t) {
        if (this.level <= 30000) {
            this.log(m, Level.WARN, t);
        }
    }

    @Override
    public void error(Object m) {
        if (this.level <= 40000) {
            this.log(m, Level.ERROR);
        }
    }

    @Override
    public void error(Object m, Throwable t) {
        if (this.level <= 40000) {
            this.log(m, Level.ERROR, t);
        }
    }

    @Override
    public void fatal(Object m) {
        if (this.level <= 50000) {
            this.log(m, Level.FATAL);
        }
    }

    @Override
    public void fatal(Object m, Throwable t) {
        if (this.level <= 50000) {
            this.log(m, Level.FATAL, t);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level <= 5000;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level <= 10000;
    }

    @Override
    public boolean isServiceEnabled() {
        return this.level <= 15000;
    }

    @Override
    public boolean isEnabledFor(Level l) {
        return this.level <= l.toInt();
    }
}

