/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.externalprocess;

import java.io.InputStream;
import java.io.OutputStream;
import org.mmbase.util.externalprocess.StreamCopyThread;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class ProcessClosure {
    private static final Logger log = Logging.getLoggerInstance(ProcessClosure.class);
    protected String name;
    protected Process process;
    protected InputStream input;
    protected OutputStream output;
    protected OutputStream error;
    protected StreamCopyThread inputWriter;
    protected StreamCopyThread outputReader;
    protected StreamCopyThread errorReader;
    protected long count = -1L;

    public ProcessClosure(String name, Process process, InputStream inputStream, OutputStream outputStream, OutputStream errorStream) {
        this.name = name;
        this.process = process;
        this.input = inputStream;
        this.output = outputStream;
        this.error = errorStream;
    }

    public void readNonBlocking() {
        log.debug(this.name + " read Non Blocking");
        ThreadGroup group = new ThreadGroup(this.name + " ThreadGroup");
        InputStream stdout = this.process.getInputStream();
        InputStream stderr = this.process.getErrorStream();
        this.outputReader = new StreamCopyThread(group, this.name + "OutputReader", stdout, this.output, false);
        this.errorReader = new StreamCopyThread(group, this.name + "ErrorReader", stderr, this.error, false);
        this.outputReader.start();
        this.errorReader.start();
    }

    public void writeNonBlocking() {
        log.debug(this.name + " write Non Blocking");
        if (this.input != null) {
            OutputStream stdin = this.process.getOutputStream();
            this.inputWriter = new StreamCopyThread(this.name + "InputWriter", this.input, stdin, true);
            this.inputWriter.start();
        }
    }

    public long getCount() {
        if (this.inputWriter != null) {
            return this.inputWriter.getCount();
        }
        return this.count;
    }

    public void readBlocking() {
        log.debug(this.name + " read Blocking");
        this.readNonBlocking();
        log.debug(this.name + " wait for process");
        this.waitForProcess();
        this.waitForReaders();
        this.process = null;
        this.outputReader = null;
        this.errorReader = null;
        log.debug(this.name + " read done");
    }

    public void writeBlocking() {
        log.debug(this.name + " write Blocking");
        this.readNonBlocking();
        this.writeNonBlocking();
        log.debug(this.name + " wait for process");
        this.waitForWriter();
        this.waitForProcess();
        this.waitForReaders();
        this.process = null;
        this.outputReader = null;
        this.errorReader = null;
        this.count = this.inputWriter.getCount();
        this.inputWriter = null;
        log.debug(this.name + " write done");
    }

    protected void waitForProcess() {
        boolean finished = false;
        while (!finished) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                log.service("Interrupted. Destroying process");
                this.process.destroy();
                finished = true;
                return;
            }
            try {
                this.process.exitValue();
                finished = true;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
        }
    }

    protected void waitForReaders() {
        if (!this.outputReader.finished()) {
            this.outputReader.waitFor();
        }
        if (!this.errorReader.finished()) {
            this.errorReader.waitFor();
        }
    }

    protected void waitForWriter() {
        if (!this.inputWriter.finished()) {
            this.inputWriter.waitFor();
        }
    }

    public boolean isAlive() {
        if (this.process != null) {
            if (this.outputReader.isAlive() || this.errorReader.isAlive()) {
                return true;
            }
            this.process = null;
            this.outputReader = null;
            this.errorReader = null;
        }
        return false;
    }

    public void terminate() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }
}

