/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util.externalprocess;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.mmbase.util.IOUtil;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.externalprocess.CommandLauncher;
import org.mmbase.util.externalprocess.ProcessClosure;
import org.mmbase.util.externalprocess.ProcessException;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class CommandExecutor {
    private static final Logger LOG = Logging.getLoggerInstance(CommandExecutor.class);
    private static final String[] EMPTY = new String[0];

    public static long execute(OutputStream outputStream, Method method, String command, String ... args) throws ProcessException, InterruptedException {
        return CommandExecutor.execute(outputStream, outputStream, method, command, args);
    }

    public static long execute(OutputStream outputStream, OutputStream errorStream, Method method, String command, String ... args) throws ProcessException, InterruptedException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        return CommandExecutor.execute(inputStream, outputStream, errorStream, method, EMPTY, command, args);
    }

    public static long execute(InputStream inputStream, OutputStream outputStream, OutputStream errorStream, Method method, String[] env, String command, String ... args) throws ProcessException, InterruptedException {
        method.setInUse(true);
        try {
            switch (method.type) {
                case LAUNCHER: {
                    CommandLauncher launcher = new CommandLauncher(command);
                    launcher.execute(command, args, env);
                    ProcessClosure reader = launcher.waitAndWrite(inputStream, outputStream, errorStream);
                    long l = reader.getCount();
                    return l;
                }
                case CONNECTOR: {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(method.host, method.port), method.timeout);
                    OutputStream os = socket.getOutputStream();
                    os.write(0);
                    ObjectOutputStream stream = new ObjectOutputStream(os);
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add(command);
                    for (String arg : args) {
                        cmd.add(arg);
                    }
                    stream.writeObject(cmd.toArray(new String[cmd.size()]));
                    stream.writeObject(env);
                    Copier copier = new Copier(inputStream, os, ".file -> socket");
                    ThreadPools.jobsExecutor.execute(copier);
                    Copier copier2 = new Copier(socket.getInputStream(), outputStream, ";socket -> cout");
                    ThreadPools.jobsExecutor.execute(copier2);
                    copier.waitFor();
                    socket.shutdownOutput();
                    copier2.waitFor();
                    socket.close();
                    long l = copier.getCount();
                    return l;
                }
            }
            throw new IllegalArgumentException();
        }
        finally {
            method.inUse = false;
        }
    }

    public static class Copier
    implements Runnable {
        private boolean ready;
        private long count = 0L;
        private final InputStream in;
        private final OutputStream out;
        private final String name;
        public boolean debug = false;

        public Copier(InputStream i, OutputStream o, String n) {
            this.in = i;
            this.out = o;
            this.name = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.count = IOUtil.copy(this.in, this.out);
            }
            catch (Throwable t) {
                LOG.error("Connector " + this.toString() + ": " + t.getClass() + " " + t.getMessage());
            }
            Copier copier = this;
            synchronized (copier) {
                this.notifyAll();
                this.ready = true;
            }
        }

        public boolean ready() {
            return this.ready;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitFor() throws InterruptedException {
            if (!this.ready) {
                Copier copier = this;
                synchronized (copier) {
                    if (!this.ready) {
                        this.wait();
                    }
                }
            }
        }

        public String toString() {
            return this.name;
        }

        public long getCount() {
            return this.count;
        }
    }

    public static class Method
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String host;
        private final int port;
        private final Type type;
        private final int timeout;
        private boolean inUse = false;

        public Method() {
            this.host = "localhost";
            this.port = -1;
            this.timeout = -1;
            this.type = Type.LAUNCHER;
        }

        public Method(String host, int port) {
            this(host, port, 10000);
        }

        public Method(String host, int port, int timeout) {
            this.host = host;
            this.port = port;
            this.timeout = timeout;
            this.type = Type.CONNECTOR;
        }

        public void setInUse(boolean b) {
            this.inUse = b;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public String toString() {
            return (this.type == Type.LAUNCHER ? "LAUNCHER" : this.host + ":" + this.port) + (this.inUse ? " (in use)" : "");
        }
    }

    public static enum Type {
        LAUNCHER,
        CONNECTOR;

    }
}

