/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.Instantiator;
import org.mmbase.util.xml.UtilReader;

public abstract class ThreadPools {
    private static final Logger LOG = Logging.getLoggerInstance(ThreadPools.class);
    public static final ThreadGroup threadGroup = new ThreadGroup("MMBase Thread Pool");
    private static Map<Future, String> identifiers = Collections.synchronizedMap(new WeakHashMap());
    public static final ExecutorService filterExecutor = Executors.newCachedThreadPool();
    private static List<WeakReference<Thread>> nameLess = new CopyOnWriteArrayList<WeakReference<Thread>>();
    private static long jobsSeq = 0L;
    public static final ThreadPoolExecutor jobsExecutor = new ThreadPoolExecutor(2, 2000, 60L, TimeUnit.SECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return ThreadPools.newThread(r, "JobsThread-" + jobsSeq++);
        }
    }){

        @Override
        public void execute(Runnable r) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing " + r + " because ", new Exception());
            }
            super.execute(r);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            LOG.debug("Now executing " + r + " in thread " + t);
        }
    };
    private static long schedSeq = 0L;
    public static final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return ThreadPools.newThread(r, "SchedulerThread-" + schedSeq++);
        }
    });
    private static final Map<String, ExecutorService> threadPools = new ConcurrentHashMap<String, ExecutorService>();
    static final UtilReader properties;

    public static String identify(Future r, String s) {
        return identifiers.put(r, s);
    }

    public static ScheduledFuture scheduleAtFixedRate(Runnable pub, int time1, int time2) {
        return scheduler.scheduleAtFixedRate(pub, time1, time2, TimeUnit.SECONDS);
    }

    public static String getString(Future r) {
        String s = identifiers.get(r);
        if (s == null) {
            return "" + r;
        }
        return s;
    }

    public static Thread newThread(final Runnable r, final String id) {
        String mn = ThreadPools.getMachineName();
        LOG.service("Found mn " + mn + "(" + (mn == null) + ")");
        Thread t = new Thread(threadGroup, r, (mn == null ? "" : mn) + ":" + id){

            @Override
            public void run() {
                try {
                    super.run();
                }
                catch (RuntimeException nf) {
                    LOG.error("Error during job: " + r + ":" + id + " " + nf.getClass().getName() + " " + nf.getMessage(), nf);
                }
                catch (Throwable e) {
                    LOG.error("Error during job: " + r + ":" + id + " " + e.getClass().getName() + " " + e.getMessage(), e);
                }
            }
        };
        t.setDaemon(true);
        if (mn == null) {
            nameLess.add(new WeakReference<1>(t));
        }
        return t;
    }

    private static String getMachineName() {
        return Logging.getMachineName();
    }

    public static Map<String, ExecutorService> getThreadPools() {
        return threadPools;
    }

    protected static void setProperty(ThreadPoolExecutor object, String key, String value) {
        if ("maxsize".equals(key)) {
            int newSize = Integer.parseInt(value);
            if (object.getMaximumPoolSize() != newSize) {
                LOG.info("Setting max pool size from " + object.getMaximumPoolSize() + " to " + newSize);
                object.setMaximumPoolSize(newSize);
            }
        } else if ("coresize".equals(key)) {
            int newSize = Integer.parseInt(value);
            if (object.getCorePoolSize() != newSize) {
                LOG.info("Setting core pool size from " + object.getCorePoolSize() + " to " + newSize);
                object.setCorePoolSize(newSize);
            }
        } else if ("keepAliveTime".equals(key)) {
            int newTime = Integer.parseInt(value);
            if (object.getKeepAliveTime(TimeUnit.SECONDS) != (long)newTime) {
                LOG.info("Setting keep alive time  from " + object.getKeepAliveTime(TimeUnit.SECONDS) + " to " + newTime);
                object.setKeepAliveTime(newTime, TimeUnit.SECONDS);
            }
        } else {
            Instantiator.setProperty(key, object.getClass(), object, value);
        }
    }

    static void configure() {
        UtilReader.PropertiesMap<String> props = properties.getProperties();
        for (Map.Entry entry : props.entrySet()) {
            if (((String)entry.getKey()).startsWith("jobs.")) {
                ThreadPools.setProperty(jobsExecutor, ((String)entry.getKey()).substring("jobs.".length()), (String)entry.getValue());
                continue;
            }
            if (((String)entry.getKey()).startsWith("scheduler.")) {
                ThreadPools.setProperty(scheduler, ((String)entry.getKey()).substring("scheduler.".length()), (String)entry.getValue());
                continue;
            }
            if (!((String)entry.getKey()).startsWith("filters.")) continue;
            ThreadPools.setProperty(scheduler, ((String)entry.getKey()).substring("filters.".length()), (String)entry.getValue());
        }
    }

    public static void shutdown() {
        List<Runnable> run = scheduler.shutdownNow();
        if (run.size() > 0) {
            LOG.info("Interrupted " + run);
        }
        if ((run = filterExecutor.shutdownNow()).size() > 0) {
            LOG.info("Interrupted " + run);
        }
        if ((run = jobsExecutor.shutdownNow()).size() > 0) {
            LOG.info("Interrupted " + run);
        }
    }

    private ThreadPools() {
    }

    static {
        scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        try {
            EventManager manager = EventManager.getInstance();
            if (manager == null) {
                LOG.fatal("No event manager!");
            } else {
                manager.addEventListener(new SystemEventListener(){

                    @Override
                    public void notify(SystemEvent systemEvent) {
                        if (systemEvent instanceof SystemEvent.MachineName) {
                            String machineName = ((SystemEvent.MachineName)systemEvent).getName();
                            for (WeakReference tr : nameLess) {
                                Thread t = (Thread)tr.get();
                                if (t == null) continue;
                                String stringBefore = "" + t;
                                t.setName(machineName + t.getName());
                                LOG.debug("Fixed name of " + stringBefore + " -> " + t);
                            }
                            nameLess.clear();
                        } else if (systemEvent instanceof SystemEvent.Shutdown) {
                            ThreadPools.shutdown();
                        }
                    }

                    @Override
                    public int getWeight() {
                        return 0;
                    }
                });
            }
            threadPools.put("jobs", jobsExecutor);
            threadPools.put("filters", filterExecutor);
            threadPools.put("schedules", scheduler);
        }
        catch (Throwable t) {
            LOG.fatal(t.getMessage(), t);
        }
        properties = new UtilReader("threadpools.xml", new Runnable(){

            @Override
            public void run() {
                ThreadPools.configure();
            }
        });
    }
}

