/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class Strip {
    private static final Logger log = Logging.getLoggerInstance(Strip.class);
    public static final int NOTHING = 0;
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int BOTH = 3;

    public static String doubleQuote(String str, int where) {
        return Strip.character(str, '\"', where);
    }

    public static String singleQuote(String str, int where) {
        return Strip.character(str, '\'', where);
    }

    public static String whitespace(String str, int where) {
        return Strip.chars(str, " \t\n\r", where);
    }

    public static String character(String str, char chr, int where) {
        if (str != null && str.length() > 0) {
            int lead = 0;
            int trail = str.length() - 1;
            switch (where) {
                case 1: {
                    if (str.charAt(lead) != chr) break;
                    ++lead;
                    break;
                }
                case 2: {
                    if (str.charAt(trail) != chr) break;
                    --trail;
                    break;
                }
                case 3: {
                    if (str.charAt(lead) == chr) {
                        ++lead;
                    }
                    if (str.charAt(trail) != chr) break;
                    --trail;
                    break;
                }
            }
            str = str.substring(lead, trail + 1);
        }
        return str;
    }

    public static String chars(String str, String chars, int where) {
        if (str != null && str.length() > 0) {
            int lead;
            int trail = str.length() - 1;
            if (trail < 1) {
                where = 1;
            } else {
                switch (where) {
                    case 1: {
                        for (lead = 0; chars.indexOf(str.charAt(lead)) != -1 && lead < str.length() - 1; ++lead) {
                        }
                        break;
                    }
                    case 2: {
                        while (chars.lastIndexOf(str.charAt(trail)) != -1 && trail > 0) {
                            --trail;
                        }
                        break;
                    }
                    case 3: {
                        while (chars.indexOf(str.charAt(lead)) != -1 && lead < str.length() - 1) {
                            ++lead;
                        }
                        while (chars.lastIndexOf(str.charAt(trail)) != -1 && trail >= lead) {
                            --trail;
                        }
                        break;
                    }
                }
            }
            str = lead <= trail ? str.substring(lead, trail + 1) : "";
        }
        return str;
    }

    public static void main(String[] args) {
        log.info("Double " + Strip.doubleQuote("\"double\"", 3));
        log.info("Single " + Strip.singleQuote("'single'", 3));
        log.info("White |" + Strip.whitespace("   white         \n", 3) + "|");
    }

    private Strip() {
    }
}

