/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mmbase.util.Strip;

public class StringTagger
implements Map {
    private Hashtable tokens;
    private Map multitokens;
    private char tagStart;
    private char tagSeparator;
    private char fieldSeparator;
    private char quote;
    private char functionOpen;
    private char functionClose;
    private String startline = "";

    public StringTagger(String line, char tagStart, char tagSeparator, char fieldSeparator, char quote, char functionOpen, char functionClose) {
        this.tagStart = tagStart;
        this.startline = line;
        this.tagSeparator = tagSeparator;
        this.fieldSeparator = fieldSeparator;
        this.quote = quote;
        this.functionOpen = functionOpen;
        this.functionClose = functionClose;
        this.tokens = new Hashtable();
        this.multitokens = new HashMap();
        this.createTagger(line);
    }

    public StringTagger(String line, char tagStart, char tagSeparator, char fieldSeparator, char quote) {
        this(line, tagStart, tagSeparator, fieldSeparator, quote, '(', ')');
    }

    public StringTagger(String line) {
        this(line, ' ', '=', ',', '\"', '(', ')');
    }

    protected void createTagger(String line) {
        StringTokenizer tok2 = new StringTokenizer(line + this.tagStart, "" + this.tagSeparator + this.tagStart, true);
        boolean isTag = true;
        boolean isPart = false;
        boolean isQuoted = false;
        String prevtok = "";
        String part = "";
        String tag = "";
        while (tok2.hasMoreTokens()) {
            String tok = tok2.nextToken();
            if (tok.equals("" + this.tagSeparator)) {
                if (isTag) {
                    tag = prevtok;
                    isTag = false;
                    continue;
                }
                if (!isQuoted) {
                    this.splitTag(tag + this.tagSeparator + part);
                    isTag = true;
                    isPart = false;
                    part = "";
                    continue;
                }
                part = part + tok;
                continue;
            }
            if (tok.equals("" + this.tagStart)) {
                if (!isPart) continue;
                if (isQuoted) {
                    part = part + tok;
                } else if (!prevtok.equals("" + this.tagStart)) {
                    this.splitTag(tag + this.tagSeparator + part);
                    isTag = true;
                    isPart = false;
                    part = "";
                }
                prevtok = tok;
                continue;
            }
            if (!isTag) {
                isPart = true;
            }
            if (isPart) {
                if (isQuoted) {
                    if (tok.charAt(tok.length() - 1) == this.quote) {
                        isQuoted = false;
                    }
                    part = part + tok;
                } else {
                    if (tok.charAt(0) == this.quote && tok.charAt(tok.length() - 1) != this.quote) {
                        isQuoted = true;
                    }
                    part = part + tok;
                }
            }
            prevtok = tok;
        }
    }

    protected void splitTag(String tag) {
        int tagPos = tag.indexOf(this.tagSeparator);
        String name = tag.substring(0, tagPos);
        String result = tag.substring(tagPos + 1);
        if (result.length() > 1 && result.charAt(0) == this.quote && result.charAt(result.length() - 1) == this.quote) {
            result = result.substring(1, result.length() - 1);
        }
        this.tokens.put(name, result);
        StringTokenizer toks = new StringTokenizer(result, "" + this.fieldSeparator + this.functionOpen + this.functionClose, true);
        Vector<String> multi = new Vector<String>();
        if (toks.hasMoreTokens()) {
            String tokvalue = "";
            int nesting = 0;
            while (toks.hasMoreTokens()) {
                String tok = toks.nextToken();
                if (tok.equals("" + this.fieldSeparator)) {
                    if (nesting == 0) {
                        multi.add(tokvalue);
                        tokvalue = "";
                        continue;
                    }
                    tokvalue = tokvalue + tok;
                    continue;
                }
                if (tok.equals("" + this.functionOpen)) {
                    ++nesting;
                    tokvalue = tokvalue + tok;
                    continue;
                }
                if (tok.equals("" + this.functionClose)) {
                    --nesting;
                    tokvalue = tokvalue + tok;
                    continue;
                }
                tokvalue = tokvalue + tok;
            }
            multi.add(tokvalue);
        }
        this.multitokens.put(name, multi);
    }

    @Override
    public void clear() {
        this.tokens.clear();
        this.multitokens.clear();
        this.startline = "";
    }

    @Override
    public boolean containsKey(Object ob) {
        return this.tokens.containsKey(ob);
    }

    @Override
    public boolean containsValue(Object ob) {
        return this.tokens.containsValue(ob);
    }

    public Set entrySet() {
        return this.tokens.entrySet();
    }

    @Override
    public boolean equals(Object ob) {
        return ob instanceof Map && ob.hashCode() == this.hashCode();
    }

    public Object get(Object ob) {
        return this.tokens.get(ob);
    }

    @Override
    public int hashCode() {
        return this.multitokens.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public Set keySet() {
        return this.tokens.keySet();
    }

    public Object put(Object key, Object value) {
        Object res = this.tokens.get(key);
        this.setValue((String)key, (String)value);
        return res;
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        Object res = this.tokens.get(key);
        this.tokens.remove(key);
        this.multitokens.remove(key);
        return res;
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    public Collection values() {
        return this.tokens.values();
    }

    public Enumeration keys() {
        return this.tokens.keys();
    }

    public String toString() {
        StringBuffer content = new StringBuffer("[");
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            content.append('<').append(key);
            content.append('=').append(this.Values(key));
            content.append('>');
        }
        content.append(']');
        return content.toString();
    }

    public Enumeration elements() {
        return this.tokens.elements();
    }

    public Enumeration multiElements(String token) {
        Vector tmp = (Vector)this.multitokens.get(token);
        if (tmp != null) {
            return tmp.elements();
        }
        return null;
    }

    public Vector Values(String token) {
        Vector tmp = (Vector)this.multitokens.get(token);
        return tmp;
    }

    public String ValuesString(String token) {
        return this.startline;
    }

    public String Value(String token) {
        Vector tmp = (Vector)this.multitokens.get(token);
        if (tmp != null && tmp.size() > 0) {
            String val = (String)tmp.elementAt(0);
            if (val != null) {
                val = Strip.doubleQuote(val, 3);
                return val;
            }
            return null;
        }
        return null;
    }

    public void setValue(String token, String val) {
        Vector<String> newval = new Vector<String>();
        newval.addElement(val);
        this.tokens.put(token, newval);
        this.multitokens.put(token, newval);
    }

    public void setValues(String token, Vector values) {
        this.tokens.put(token, values.toString());
        this.multitokens.put(token, values);
    }

    public static void main(String[] args) {
        StringTagger tag = new StringTagger(args[0]);
    }
}

