/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.mmbase.util.Entry;

public class StringSplitter {
    public static List<String> split(String string, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        if (string == null) {
            return result;
        }
        for (String v : string.split(delimiter)) {
            result.add(v.trim());
        }
        return result;
    }

    public static List<String> split(String string) {
        return StringSplitter.split(string, ",");
    }

    public static List<String> splitFunctions(CharSequence attribute) {
        int i;
        int commaPos = 0;
        int nested = 0;
        ArrayList<String> result = new ArrayList<String>();
        int length = attribute.length();
        for (i = 0; i < length; ++i) {
            char c = attribute.charAt(i);
            if (c == ',' || c == ';') {
                if (nested != 0) continue;
                result.add(attribute.subSequence(commaPos, i).toString().trim());
                commaPos = i + 1;
                continue;
            }
            if (c == '(') {
                ++nested;
                continue;
            }
            if (c != ')') continue;
            --nested;
        }
        if (i > 0) {
            result.add(attribute.toString().substring(commaPos).trim());
        }
        return result;
    }

    public static Map<String, String> map(String string) {
        return StringSplitter.map(string, ",");
    }

    public static Map<String, String> map(String string, String delimiter) {
        if (delimiter.equals("\n")) {
            final Properties props = new Properties();
            try {
                props.load(new ByteArrayInputStream(string.getBytes("ISO-8859-1")));
            }
            catch (UnsupportedEncodingException uee) {
                new RuntimeException(uee);
            }
            catch (IOException ioe) {
                new RuntimeException(ioe);
            }
            return new AbstractMap<String, String>(){

                @Override
                public Set<Map.Entry<String, String>> entrySet() {
                    return new AbstractSet<Map.Entry<String, String>>(){

                        @Override
                        public int size() {
                            return props.size();
                        }

                        @Override
                        public Iterator<Map.Entry<String, String>> iterator() {
                            return new Iterator<Map.Entry<String, String>>(){
                                private final Iterator<Map.Entry<Object, Object>> i;
                                {
                                    this.i = props.entrySet().iterator();
                                }

                                @Override
                                public boolean hasNext() {
                                    return this.i.hasNext();
                                }

                                @Override
                                public Map.Entry<String, String> next() {
                                    Map.Entry<Object, Object> entry = this.i.next();
                                    return new Entry<String, String>((String)entry.getKey(), (String)entry.getValue());
                                }

                                @Override
                                public void remove() {
                                    this.i.remove();
                                }
                            };
                        }
                    };
                }
            };
        }
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> keyValues = StringSplitter.split(string, delimiter);
        for (String kv : keyValues) {
            if ("".equals(kv)) continue;
            int is = kv.indexOf(61);
            if (is == -1) {
                throw new IllegalArgumentException("'" + kv + "' in '" + string + "' does not look like map-entry");
            }
            map.put(kv.substring(0, is), kv.substring(is + 1));
        }
        return map;
    }

    private StringSplitter() {
    }
}

