/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

public final class StringObject {
    private char[] value;
    private int count;
    private boolean shared;

    public StringObject() {
        this(16);
    }

    public StringObject(int length) {
        this.value = new char[length];
        this.shared = false;
    }

    public StringObject(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    private void copyWhenShared() {
        if (this.shared) {
            char[] newValue = new char[this.value.length];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
            this.shared = false;
        }
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        int maxCapacity = this.value.length;
        if (minimumCapacity > maxCapacity) {
            int newCapacity = (maxCapacity + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.value, 0, newValue, 0, this.count);
            this.value = newValue;
            this.shared = false;
        }
    }

    public synchronized void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacity(newLength);
        if (this.count < newLength) {
            this.copyWhenShared();
            while (this.count < newLength) {
                this.value[this.count] = '\u0000';
                ++this.count;
            }
        }
        this.count = newLength;
    }

    public synchronized char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public synchronized void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0 || srcBegin >= this.count) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin < srcEnd) {
            System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
        }
    }

    public synchronized void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.copyWhenShared();
        this.value[index] = ch;
    }

    public synchronized StringObject append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public synchronized StringObject append(String str) {
        if (str == null) {
            str = String.valueOf(str);
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public synchronized StringObject append(char[] str) {
        int len = str.length;
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(str, 0, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public synchronized StringObject append(char[] str, int offset, int len) {
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count += len;
        return this;
    }

    public StringObject append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public synchronized StringObject append(char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        this.value[this.count++] = c;
        return this;
    }

    public StringObject append(int i) {
        return this.append(String.valueOf(i));
    }

    public StringObject append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringObject append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringObject append(double d) {
        return this.append(String.valueOf(d));
    }

    public synchronized StringObject insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public synchronized StringObject insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length();
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public synchronized StringObject insert(int offset, char[] str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = str.length;
        this.ensureCapacity(this.count + len);
        this.copyWhenShared();
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count += len;
        return this;
    }

    public StringObject insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public synchronized StringObject insert(int offset, char c) {
        this.ensureCapacity(this.count + 1);
        this.copyWhenShared();
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        ++this.count;
        return this;
    }

    public StringObject insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public StringObject insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public StringObject insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public StringObject insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public synchronized StringObject reverse() {
        this.copyWhenShared();
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            this.value[j] = this.value[n - j];
            this.value[n - j] = temp;
        }
        return this;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    void setShared() {
        this.shared = true;
    }

    char[] getValue() {
        return this.value;
    }

    public synchronized StringObject delete(int offset, int len) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.copyWhenShared();
        System.arraycopy(this.value, offset + len, this.value, offset, this.count - (offset + len));
        this.count -= len;
        return this;
    }

    public synchronized StringObject replace(int offset, int len, String str) {
        this.delete(offset, len);
        this.insert(offset, str);
        return this;
    }

    public synchronized StringObject replaceFirst(String oldstr, String newstr) {
        int pos = this.indexOf(oldstr, 0);
        if (pos != -1) {
            this.delete(pos, oldstr.length());
            this.insert(pos, newstr);
        }
        return this;
    }

    public synchronized StringObject replace(String oldstr, String newstr) {
        int strlen = oldstr.length();
        int pos = this.indexOf(oldstr, 0, strlen);
        while (pos != -1) {
            this.delete(pos, strlen);
            this.insert(pos, newstr);
            pos = this.indexOf(oldstr, pos + newstr.length(), strlen);
        }
        return this;
    }

    public synchronized StringObject replace(String oldstart, String oldend, String newstart, String newend) {
        int pos = this.indexOf(oldstart, 0);
        while (pos != -1) {
            this.delete(pos, oldstart.length());
            this.insert(pos, newstart);
            int pos2 = this.indexOf(oldend, pos + newstart.length());
            if (pos2 != -1) {
                this.delete(pos2, oldend.length());
                this.insert(pos2, newend);
            }
            pos = this.indexOf(oldstart, pos2 + newend.length());
        }
        return this;
    }

    public synchronized StringObject insertLinks(String oldstart, String oldend, String newstart, String newend, String startend) {
        int pos = this.indexOf(oldstart, 0);
        String link = "";
        while (pos != -1) {
            this.delete(pos, oldstart.length());
            this.insert(pos, newstart);
            int pos2 = this.indexOf(oldend, pos + newstart.length());
            if (pos2 != -1) {
                link = new String(this.value, pos + newstart.length(), pos2 - (pos + newstart.length()));
                this.delete(pos2, oldend.length());
                this.insert(pos2, newend + link + startend);
            }
            pos = this.indexOf(oldstart, pos2 + newend.length());
        }
        return this;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return this.indexOf(str, fromIndex, str.length());
    }

    private int indexOf(String str, int fromIndex, int strlen) {
        int i;
        char[] v1 = this.value;
        char[] v2 = str.toCharArray();
        int max = this.count - strlen;
        int n = i = fromIndex < 0 ? 0 : fromIndex;
        while (i <= max) {
            block2: {
                int n2 = strlen;
                int j = i;
                int k = 0;
                while (n2-- != 0) {
                    if (v1[j++] == v2[k++]) continue;
                    break block2;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }
}

