/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.mmbase.util.SizeMeasurable;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.XMLWriter;
import org.w3c.dom.Node;

public class SizeOf {
    private static final Logger log = Logging.getLoggerInstance(SizeOf.class);
    public static final int SZ_REF = 4;
    private Set<Object> countedObjects = new HashSet<Object>();

    private static int size_prim(Class<?> t) {
        if (t == Boolean.TYPE) {
            return 1;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Character.TYPE) {
            return 2;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Void.TYPE) {
            return 0;
        }
        return 4;
    }

    public static int sizeof(boolean b) {
        return 1;
    }

    public static int sizeof(byte b) {
        return 1;
    }

    public static int sizeof(char c) {
        return 2;
    }

    public static int sizeof(short s) {
        return 2;
    }

    public static int sizeof(int i) {
        return 4;
    }

    public static int sizeof(long l) {
        return 8;
    }

    public static int sizeof(float f) {
        return 4;
    }

    public static int sizeof(double d) {
        return 8;
    }

    public static int getByteSize(Object obj) {
        return new SizeOf().sizeof(obj);
    }

    public void clear() {
        this.countedObjects.clear();
    }

    public int sizeof(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!this.countedObjects.add(obj)) {
            return 0;
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            log.debug("an array");
            return this.size_arr(obj, c);
        }
        if (log.isDebugEnabled()) {
            log.debug("an object " + obj + " " + c);
        }
        try {
            if (SizeMeasurable.class.isAssignableFrom(c)) {
                return this.sizeof((SizeMeasurable)obj);
            }
            if (HttpSession.class.isAssignableFrom(c)) {
                return this.sizeof((HttpSession)obj);
            }
            if (Node.class.isAssignableFrom(c)) {
                return this.sizeof((Node)obj);
            }
            if (Map.class.isAssignableFrom(c)) {
                return this.sizeof((Map)obj);
            }
            if (Collection.class.isAssignableFrom(c)) {
                return this.sizeof((Collection)obj);
            }
            if (String.class.isAssignableFrom(c)) {
                return this.sizeof((String)obj);
            }
            if (Integer.class.isAssignableFrom(c)) {
                return 16;
            }
            if (Long.class.isAssignableFrom(c)) {
                return 16;
            }
            if (Float.class.isAssignableFrom(c)) {
                return 16;
            }
            if (Double.class.isAssignableFrom(c)) {
                return 16;
            }
        }
        catch (Throwable e) {
            log.warn("Error during determination of size of " + obj + " :" + e.getMessage(), e);
        }
        return this.size_inst(obj, c);
    }

    private int sizeof(Map<?, ?> m) {
        int len = this.size_inst(m, m.getClass()) + m.size() * 30;
        Iterator<Map.Entry<?, ?>> iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry1;
            Map.Entry<?, ?> entry = entry1 = iterator.next();
            len += this.sizeof(entry.getKey());
            len += this.sizeof(entry.getValue());
        }
        return len;
    }

    private int sizeof(Collection<?> m) {
        log.debug("sizeof List");
        int len = this.size_inst(m, m.getClass());
        for (Object aM : m) {
            len += this.sizeof(aM);
        }
        return len;
    }

    private int sizeof(HttpSession session) {
        log.debug("sizeof HttpSession");
        int len = this.size_inst(session, session.getClass());
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String attribute = (String)e.nextElement();
            len += this.sizeof(attribute);
            len += this.sizeof(session.getAttribute(attribute));
        }
        return len;
    }

    private int sizeof(Node node) {
        log.debug("sizeof Node");
        return this.sizeof(XMLWriter.write(node, false));
    }

    private int sizeof(String m) {
        return 44 + m.length() * 2;
    }

    private int sizeof(SizeMeasurable m) {
        if (log.isDebugEnabled()) {
            log.debug("sizeof SizeMeasureable " + m);
        }
        return m.getByteSize(this);
    }

    private int size_inst(Object obj, Class<?> c) {
        Class<?>[] cv;
        Field[] flds = c.getDeclaredFields();
        int sz = 8;
        for (Field f : flds) {
            if (!c.isInterface() && (f.getModifiers() & 8) != 0) continue;
            sz += SizeOf.size_prim(f.getType());
            if (!f.isAccessible()) continue;
            try {
                sz += this.sizeof(f.get(obj));
            }
            catch (IllegalAccessException e) {
                log.trace(e);
            }
        }
        if (c.getSuperclass() != null) {
            sz += this.size_inst(obj, c.getSuperclass()) - 8;
        }
        for (Class<?> element : cv = c.getInterfaces()) {
            sz += this.size_inst(obj, element) - 8;
        }
        return sz;
    }

    private int size_arr(Object obj, Class<?> c) {
        Class<?> ct = c.getComponentType();
        int len = Array.getLength(obj);
        if (ct.isPrimitive()) {
            return len * SizeOf.size_prim(ct);
        }
        int sz = 0;
        for (int i = 0; i < len; ++i) {
            Object obj2 = Array.get(obj, i);
            sz += this.sizeof(obj2);
        }
        return sz;
    }

    public static void main(String[] argv) throws InterruptedException {
        Runtime rt = Runtime.getRuntime();
        int SIZE = Math.round((float)Math.pow(10.0, 4.0));
        ArrayList<Integer> list = new ArrayList<Integer>();
        rt.runFinalization();
        rt.gc();
        Thread.sleep(1000L);
        long usedBefore = rt.totalMemory() - rt.freeMemory();
        for (int i = SIZE; i < 2 * SIZE; ++i) {
            list.add(i);
        }
        rt.runFinalization();
        rt.gc();
        Thread.sleep(1000L);
        long usedAfter = rt.totalMemory() - rt.freeMemory();
        System.out.println("" + SIZE + " of Integer costs " + (usedAfter - usedBefore) + " bytes");
        System.out.println("Sizeof reports: " + SizeOf.getByteSize(list) + " bytes");
    }
}

