/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.mmbase.util.FileWatcher;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public abstract class ResourceWatcher {
    private static final Logger log = Logging.getLoggerInstance(ResourceWatcher.class);
    static String resourceBuilder = null;
    static final Map<ResourceWatcher, Object> resourceWatchers = Collections.synchronizedMap(new WeakHashMap());
    private long delay = 60000L;
    protected final SortedSet<String> resources = new TreeSet<String>();
    protected final Map<Integer, String> nodeNumberToResourceName = new HashMap<Integer, String>();
    private boolean running = false;
    protected final Map<String, FileWatcher> fileWatchers = new HashMap<String, FileWatcher>();
    protected final ResourceLoader resourceLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResourceBuilder(String builder) {
        if (resourceWatchers == null) {
            throw new RuntimeException("A resource builder was set already: " + resourceBuilder);
        }
        resourceBuilder = builder;
        Map<ResourceWatcher, Object> map = resourceWatchers;
        synchronized (map) {
            for (ResourceWatcher rw : resourceWatchers.keySet()) {
                if (resourceBuilder == null) continue;
                if (rw.running) {
                    // empty if block
                }
                for (String resource : rw.resources) {
                    if (!rw.mapNodeNumber(resource)) continue;
                    log.service("ResourceBuilder is available now. Resource " + resource + " must be reloaded.");
                    rw.onChange(resource);
                }
            }
            ResourceWatcher.reinitWatchers();
        }
        if (builder != null) {
            log.info("The resources builder '" + builder + "' is available.");
        } else {
            log.debug("No resources builder");
        }
    }

    public static String getResourceBuilder() {
        return resourceBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitWatchers() {
        Map<ResourceWatcher, Object> map = resourceWatchers;
        synchronized (map) {
            for (ResourceWatcher rw : resourceWatchers.keySet()) {
                log.debug("Reinitting watcher " + rw);
                rw.readdResources();
            }
        }
    }

    protected ResourceWatcher(ResourceLoader rl) {
        this(rl, true);
    }

    protected ResourceWatcher(ResourceLoader rl, boolean administrate) {
        this.resourceLoader = rl;
        if (administrate) {
            resourceWatchers.put(this, null);
        }
        if (log.isDebugEnabled()) {
            log.debug(" " + this + " for " + rl);
        }
    }

    protected ResourceWatcher() {
        this(ResourceLoader.getConfigurationRoot());
    }

    public Set<String> getResources() {
        return Collections.unmodifiableSortedSet(this.resources);
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public synchronized void add(String resourceName) {
        if (resourceName == null || resourceName.equals("")) {
            log.warn("Cannot watch resource '" + resourceName + "' " + Logging.stackTrace());
            return;
        }
        this.resources.add(resourceName);
        if (log.isDebugEnabled()) {
            log.debug("Started watching '" + resourceName + "' for resource loader " + this.resourceLoader);
            log.trace("(now watching " + this.resources + ")");
        }
        if (this.running) {
            this.createFileWatcher(resourceName);
            this.mapNodeNumber(resourceName);
        } else {
            log.debug("Not createing file and and node watchers because not running");
        }
    }

    public synchronized void add(URL url) {
        if (!url.getProtocol().equals("mm")) {
            throw new UnsupportedOperationException("Don't know how to watch " + url + " (Only URLs produced by ResourceLoader are supported)");
        }
        String path = url.getPath();
        this.add(path.substring(this.resourceLoader.getContext().getPath().length()));
    }

    protected synchronized void createFileWatcher(String resource) {
        ResourceFileWatcher fileWatcher = new ResourceFileWatcher(resource);
        fileWatcher.setDelay(this.delay);
        fileWatcher.getFiles().addAll(this.resourceLoader.getFiles(resource));
        fileWatcher.start();
        FileWatcher old = this.fileWatchers.put(resource, fileWatcher);
        if (old == null) {
            log.debug("Created " + fileWatcher + " " + this.fileWatchers);
        } else {
            log.warn("Replaced " + fileWatcher + " " + this.fileWatchers, new Exception());
            old.exit();
        }
    }

    protected synchronized boolean mapNodeNumber(String resource) {
        Integer node = this.resourceLoader.getResourceNode(resource);
        if (node != null) {
            this.nodeNumberToResourceName.put(node, resource);
            return true;
        }
        return false;
    }

    public synchronized void start() {
        if (!this.running) {
            for (String resource : this.getResources()) {
                this.mapNodeNumber(resource);
                this.createFileWatcher(resource);
            }
            this.running = true;
        } else {
            log.warn("Already running.", new Exception());
        }
    }

    public abstract void onChange(String var1);

    public final void onChange() {
        for (String resource : this.getResources()) {
            this.onChange(resource);
        }
    }

    public synchronized void setDelay(long delay) {
        this.delay = delay;
        for (FileWatcher fw : this.fileWatchers.values()) {
            fw.setDelay(delay);
        }
    }

    public synchronized void remove(String resourceName) {
        boolean wasRunning = this.running;
        if (this.running) {
            this.exit();
        }
        this.resources.remove(resourceName);
        if (wasRunning) {
            this.start();
        }
    }

    public synchronized void clear() {
        if (this.running) {
            this.exit();
            this.resources.clear();
            this.start();
        } else {
            this.resources.clear();
        }
    }

    protected synchronized void readdResources() {
        TreeSet<String> copy = new TreeSet<String>();
        copy.addAll(this.resources);
        this.clear();
        for (String resource : copy) {
            this.add(resource);
        }
        log.debug("Readded resources, now " + this.resources);
    }

    public synchronized void exit() {
        if (this.running) {
            Iterator<FileWatcher> i = this.fileWatchers.values().iterator();
            while (i.hasNext()) {
                FileWatcher fw = i.next();
                fw.exit();
                i.remove();
            }
            this.running = false;
        } else {
            log.debug("Not running");
        }
    }

    public String toString() {
        return "" + this.resources + " " + this.fileWatchers;
    }

    public static Set<ResourceWatcher> getResourceWatchers() {
        return resourceWatchers.keySet();
    }

    public long getDelay() {
        return this.delay;
    }

    public Map<String, FileWatcher> getFileWatchers() {
        return Collections.unmodifiableMap(this.fileWatchers);
    }

    public boolean isRunning() {
        return this.running;
    }

    protected class ResourceFileWatcher
    extends FileWatcher {
        private final String resource;

        ResourceFileWatcher(String resource) {
            super(true);
            this.resource = resource;
        }

        @Override
        public void onChange(File f) {
            URL shadower = ResourceWatcher.this.resourceLoader.shadowed(f, this.resource);
            if (shadower == null) {
                ResourceWatcher.this.onChange(this.resource);
            } else {
                log.warn("File " + f + " changed, but it is shadowed by " + shadower);
            }
        }
    }
}

