/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.ApplicationContextReader;
import org.mmbase.util.EncodingDetectingOutputStreamWriter;
import org.mmbase.util.Entry;
import org.mmbase.util.GenericResponseWrapper;
import org.mmbase.util.HashCodeUtil;
import org.mmbase.util.ReplacingLocalizedString;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.InverseCharTransformer;
import org.mmbase.util.transformers.TransformingReader;
import org.mmbase.util.transformers.TransformingWriter;
import org.mmbase.util.transformers.UnicodeEscaper;
import org.mmbase.util.xml.DocumentReader;
import org.mmbase.util.xml.EntityResolver;
import org.mmbase.util.xml.UtilReader;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceLoader
extends ClassLoader {
    private static Logger log = Logging.getLoggerInstance(ResourceLoader.class);
    protected static final String PROTOCOL = "mm";
    protected static final String RESOURCE_ROOT = "/WEB-INF/config";
    protected static final String CLASSLOADER_ROOT = "/org/mmbase/config";
    protected static final String INDEX = "INDEX";
    private static final ResourceLoader configRoot = new ResourceLoader();
    private static boolean configRootNeedsInit = true;
    private static final ResourceLoader webRoot = new ResourceLoader();
    private static boolean webRootNeedsInit = true;
    private static ResourceLoader systemRoot = null;
    private static ServletContext servletContext = null;
    private final MMURLStreamHandler mmStreamHandler = new MMURLStreamHandler();
    private final URL context;
    private final ResourceLoader parent;
    final List<PathURLStreamHandler> roots;
    public static final Pattern XML_PATTERN;
    private static boolean warned23;
    private static final String RESOURCELOADER_XML = "resourceloader.xml";
    private static final UtilReader.PropertiesMap<Collection<Map.Entry<String, String>>> classWeightProperties;
    private static final Map<Pattern, Integer> classWeights;
    private static Comparator<URL> urlComparator;

    public static void initLogging() {
        Logger nlog = Logging.getLoggerInstance(ResourceLoader.class);
        if (nlog != null) {
            log = nlog;
        } else {
            log.warn("Could not get new logger instance");
        }
    }

    protected final URL newURL(String url) throws MalformedURLException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            int firstColon = url.indexOf(58);
            if (firstColon <= 0) {
                if (new File(url).exists()) {
                    return new URL("file:" + url);
                }
                throw new MalformedURLException("No protocol specified: " + url);
            }
            String protocol = url.substring(0, firstColon);
            if (protocol.equals(PROTOCOL)) {
                return new URL(null, url, this.mmStreamHandler);
            }
            if (new File(url).exists()) {
                return new URL("file:" + url);
            }
            throw new MalformedURLException("Unknown protocol: " + protocol);
        }
    }

    public static synchronized void init(ServletContext sc) {
        servletContext = sc;
        configRootNeedsInit = true;
        webRootNeedsInit = true;
        log.debug("Inited with " + sc);
        if (sc != null) {
            EventManager.getInstance().propagateEvent(new SystemEvent.ResourceLoaderChange());
        }
    }

    public static String getName(String path) {
        if (path == null) {
            return null;
        }
        int i = path.lastIndexOf(47);
        if ((i = (path = path.substring(i + 1)).lastIndexOf(46)) > 0) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static String getDirectory(String path) {
        if (path == null) {
            return null;
        }
        int i = path.lastIndexOf(47);
        path = i > 0 ? path.substring(0, i) : "";
        return path;
    }

    public static String getDirectoryName(String path) {
        int i;
        if (path == null) {
            return null;
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        if ((path = path.substring((i = path.lastIndexOf(47)) + 1)).length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    public static synchronized ResourceLoader getConfigurationRoot() {
        if (configRootNeedsInit) {
            configRootNeedsInit = false;
            ArrayList<PathURLStreamHandler> newRoots = new ArrayList<PathURLStreamHandler>();
            try {
                String name = "org/mmbase/config/utils/resourceloader_" + (Object)((Object)Type.CONFIG);
                ArrayList<URL> urls = Collections.list(ResourceLoader.class.getClassLoader().getResources(name));
                log.service("Configuration root not yet defined. Using '" + name + "' (" + urls + ") to do that.");
                for (URL url : urls) {
                    String line;
                    InputStream inputStream = url.openStream();
                    if (inputStream == null) continue;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    int weight = 0;
                    while ((line = reader.readLine()) != null) {
                        String className;
                        if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                        String[] parts = line.split(":", 2);
                        if (parts.length == 2) {
                            className = parts[1];
                            if (parts[0].length() > 0) {
                                weight = Integer.parseInt(parts[0]);
                            }
                        } else {
                            className = parts[0];
                        }
                        try {
                            PathURLStreamHandler[] handlers;
                            Class<?> clazz = Class.forName(className);
                            URLStreamHandlerFactory fact = (URLStreamHandlerFactory)clazz.newInstance();
                            for (PathURLStreamHandler handler : handlers = fact.createURLStreamHandler(configRoot, Type.CONFIG)) {
                                handler.setWeight(weight);
                                newRoots.add(handler);
                                ++weight;
                            }
                        }
                        catch (Exception e) {
                            log.error(url + ":" + line + ":" + e.getClass().getName() + ":" + e.getMessage());
                        }
                    }
                    reader.close();
                }
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), ioe);
            }
            Collections.sort(newRoots);
            ResourceLoader.configRoot.roots.clear();
            ResourceLoader.configRoot.roots.addAll(newRoots);
        }
        return configRoot;
    }

    public static synchronized ResourceLoader getSystemRoot() {
        if (systemRoot == null) {
            systemRoot = new ResourceLoader();
            try {
                ResourceLoader.systemRoot.roots.add(new FileURLStreamHandler(systemRoot, new File(System.getProperty("user.dir")), true));
            }
            catch (SecurityException se) {
                log.service(se.getMessage());
            }
            for (File element : File.listRoots()) {
                ResourceLoader.systemRoot.roots.add(new FileURLStreamHandler(systemRoot, element, true));
            }
        }
        return systemRoot;
    }

    public static synchronized ResourceLoader getWebRoot() {
        if (webRootNeedsInit) {
            webRootNeedsInit = false;
            ResourceLoader.webRoot.roots.clear();
            String htmlRoot = null;
            if (servletContext != null) {
                htmlRoot = servletContext.getInitParameter("mmbase.htmlroot");
            }
            if (htmlRoot == null) {
                try {
                    htmlRoot = System.getProperty("mmbase.htmlroot");
                }
                catch (SecurityException se) {
                    log.service(se);
                }
            }
            if (htmlRoot != null) {
                ResourceLoader.webRoot.roots.add(new FileURLStreamHandler(webRoot, new File(htmlRoot), true));
            }
            if (servletContext != null) {
                String s = servletContext.getRealPath("/");
                if (s != null) {
                    ResourceLoader.webRoot.roots.add(new FileURLStreamHandler(webRoot, new File(s), true));
                }
                ResourceLoader.webRoot.roots.add(new ServletResourceURLStreamHandler(webRoot, "/"));
            }
        }
        return webRoot;
    }

    public static synchronized ResourceLoader getWebDirectory(HttpServletRequest request) {
        return ResourceLoader.getWebRoot().getChildResourceLoader(request.getServletPath()).getParentResourceLoader();
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    protected ResourceLoader() {
        this.roots = new CopyOnWriteArrayList<PathURLStreamHandler>();
        this.parent = null;
        try {
            this.context = this.newURL("mm:/");
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    protected ResourceLoader(ResourceLoader cl, String context) {
        super(ResourceLoader.class.getClassLoader());
        this.context = cl.findResource(context + "/");
        this.roots = new ArrayList<PathURLStreamHandler>();
        for (PathURLStreamHandler o : cl.roots) {
            this.roots.add(o.createSubHandler(this));
        }
        this.parent = cl;
    }

    @Override
    protected URL findResource(String name) {
        try {
            if (name.startsWith("/")) {
                return this.newURL("mm:" + name);
            }
            if (name.startsWith("mm:")) {
                return this.newURL(name);
            }
            return new URL(this.context, name);
        }
        catch (MalformedURLException mfue) {
            log.info(mfue + Logging.stackTrace(mfue));
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(final String name) throws IOException {
        final Iterator<PathURLStreamHandler> i = this.roots.iterator();
        return new Enumeration<URL>(){
            private Enumeration<URL> current = this.getNext();
            private Enumeration<URL> next = this.getNext();

            protected Enumeration<URL> getNext() {
                if (i.hasNext()) {
                    try {
                        PathURLStreamHandler ush = (PathURLStreamHandler)i.next();
                        Enumeration<URL> e = ush.getResources(name);
                        return e;
                    }
                    catch (IOException io) {
                        log.warn(io);
                        return this.current;
                    }
                }
                return this.current;
            }

            @Override
            public boolean hasMoreElements() {
                return this.current != null && (this.current.hasMoreElements() || this.next.hasMoreElements());
            }

            @Override
            public URL nextElement() {
                if (!this.current.hasMoreElements()) {
                    this.current = this.next;
                    this.next = this.getNext();
                }
                URL n = this.current.nextElement();
                return n;
            }
        };
    }

    public List<URL> getResourceList(String name) {
        try {
            return Collections.list(this.getResources(name));
        }
        catch (IOException io) {
            log.warn(io);
            return Collections.emptyList();
        }
    }

    public URL getContext() {
        return this.context;
    }

    public ResourceLoader getParentResourceLoader() {
        return this.parent;
    }

    public ResourceLoader getChildResourceLoader(String context) {
        if ("..".equals(context)) {
            return this.getParentResourceLoader();
        }
        if ("".equals(context) || "/".equals(context)) {
            return this;
        }
        String[] dirs = context.split("/");
        ResourceLoader rl = this;
        for (String element : dirs) {
            rl = new ResourceLoader(rl, element);
        }
        return rl;
    }

    public Set<String> getResourcePaths(Pattern pattern, boolean recursive) {
        return this.getResourcePaths(pattern, recursive, false);
    }

    public Set<String> getChildContexts(Pattern pattern, boolean recursive) {
        return this.getResourcePaths(pattern, recursive, true);
    }

    protected Set<String> getResourcePaths(Pattern pattern, boolean recursive, boolean directories) {
        TreeSet<String> results = new TreeSet<String>();
        for (PathURLStreamHandler cf : this.roots) {
            cf.getPaths(results, pattern, recursive, directories);
        }
        return results;
    }

    public OutputStream createResourceAsStream(String name) throws IOException {
        if (name == null || name.equals("")) {
            throw new IOException("You cannot create a resource with an empty name");
        }
        URL resource = this.findResource(name);
        URLConnection connection = resource.openConnection();
        return connection.getOutputStream();
    }

    public InputSource getInputSource(String name) throws IOException {
        return ResourceLoader.getInputSource(this.findResource(name));
    }

    public static InputSource getInputSource(URL url) throws IOException {
        try {
            InputStream stream = url.openStream();
            if (stream == null) {
                return null;
            }
            InputSource is = new InputSource(stream);
            is.setSystemId(url.toExternalForm());
            return is;
        }
        catch (MalformedURLException mfue) {
            log.info(mfue);
            return null;
        }
    }

    public Document getDocument(String name) throws SAXException, IOException {
        return this.getDocument(name, true, null);
    }

    public Document getDocument(String name, boolean validation, Class<?> baseClass) throws SAXException, IOException {
        return ResourceLoader.getDocument(this.getResource(name), validation, baseClass);
    }

    protected static boolean validateable(URL url) throws IOException {
        boolean xsd = true;
        InputStreamReader r = new InputStreamReader(url.openStream());
        BufferedReader reader = new BufferedReader(r);
        String line = reader.readLine();
        for (int lineNumber = 0; lineNumber < 2 && line != null; ++lineNumber) {
            if (line.startsWith("<!DOCTYPE")) {
                log.debug("Using DTD to validate '" + url + "'");
                xsd = false;
            }
            line = reader.readLine();
        }
        reader.close();
        return xsd;
    }

    public static Document getDocument(URL url, boolean validation, Class<?> baseClass) throws SAXException, IOException {
        EntityResolver resolver;
        DocumentBuilder dbuilder;
        InputSource source = ResourceLoader.getInputSource(url);
        if (source == null) {
            return null;
        }
        boolean xsd = validation;
        if (validation) {
            xsd = ResourceLoader.validateable(url);
        }
        if ((dbuilder = DocumentReader.getDocumentBuilder(validation, xsd, null, resolver = new EntityResolver(validation, baseClass))) == null) {
            throw new RuntimeException("failure retrieving document builder");
        }
        if (log.isDebugEnabled()) {
            log.debug("Reading " + source.getSystemId());
        }
        try {
            Document doc = dbuilder.parse(source);
            return doc;
        }
        catch (IOException ioe) {
            if (validation) {
                log.error(ioe);
                return ResourceLoader.getDocument(url, false, baseClass);
            }
            throw ioe;
        }
    }

    public void storeSource(String name, Source source, DocumentType docType) throws IOException {
        try {
            log.service("Storing source " + name + " for " + this);
            OutputStream stream = this.createResourceAsStream(name);
            StreamResult streamResult = new StreamResult(stream);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("indent", "yes");
            if (docType != null) {
                serializer.setOutputProperty("doctype-public", docType.getPublicId());
                serializer.setOutputProperty("doctype-system", docType.getSystemId());
            }
            serializer.transform(source, streamResult);
            stream.close();
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    public void storeDocument(String name, Document doc) throws IOException {
        this.storeSource(name, new DOMSource(doc), doc.getDoctype());
    }

    public Reader getReader(InputStream is, String name) throws IOException {
        try {
            if (is == null) {
                return null;
            }
            if (name != null && name.endsWith(".properties")) {
                return new TransformingReader(new InputStreamReader(is, "UTF-8"), new InverseCharTransformer(new UnicodeEscaper()));
            }
            byte[] b = new byte[100];
            if (is.markSupported()) {
                is.mark(101);
            }
            try {
                is.read(b, 0, 100);
                if (is.markSupported()) {
                    is.reset();
                } else {
                    is = this.getResourceAsStream(name);
                }
            }
            catch (IOException ioe) {
                is = this.getResourceAsStream(name);
            }
            String encoding = GenericResponseWrapper.getXMLEncoding(b);
            if (encoding != null) {
                return new InputStreamReader(is, encoding);
            }
            return new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    public Reader getReader(String name) throws IOException {
        return this.getReader(this.getResourceAsStream(name), name);
    }

    public Writer getWriter(String name) throws IOException {
        OutputStream os = this.createResourceAsStream(name);
        try {
            if (os == null) {
                return null;
            }
            if (name.endsWith(".properties")) {
                return new TransformingWriter(new OutputStreamWriter(os, "UTF-8"), new UnicodeEscaper());
            }
        }
        catch (UnsupportedEncodingException uee) {
            log.error("uee " + uee);
        }
        return new EncodingDetectingOutputStreamWriter(os);
    }

    public String toInternalForm(String name) {
        return ResourceLoader.toInternalForm(this.findResource(name));
    }

    public static String toInternalForm(URL u) {
        return u.getProtocol() + ":" + u.getPath();
    }

    public List<File> getFiles(String name) {
        ArrayList<File> result = new ArrayList<File>();
        if (name.startsWith("file://")) {
            try {
                result.add(new File(new URL(name).getFile()));
                return result;
            }
            catch (MalformedURLException mfue) {
                log.warn(mfue);
            }
        }
        for (PathURLStreamHandler o : this.roots) {
            File f;
            if (!(o instanceof AbstractFileURLStreamHandler) || (f = ((AbstractFileURLStreamHandler)o).getFile(name)) == null) continue;
            result.add(((AbstractFileURLStreamHandler)o).getFile(name));
        }
        return result;
    }

    Integer getResourceNode(String name) {
        for (PathURLStreamHandler o : this.roots) {
            Integer n = o.getResourceNode(name);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    void checkShadowedNewerResources(String name) {
        long lastModified = -1L;
        URL usedUrl = null;
        for (PathURLStreamHandler cf : this.roots) {
            URLConnection con = cf.openConnection(name);
            if (!con.getDoInput()) continue;
            long lm = con.getLastModified();
            if (lm > 0L && usedUrl != null && lastModified > 0L && lm > lastModified) {
                log.warn("File " + con.getURL() + " is newer (" + new Date(lm) + ") then " + usedUrl + "(" + new Date(lastModified) + ") but shadowed by it");
                log.debug("Checked because " + Logging.stackTrace(15));
            }
            if (usedUrl != null || lm <= 0L) continue;
            usedUrl = con.getURL();
            lastModified = lm;
        }
    }

    URL shadowed(File f, String name) {
        for (PathURLStreamHandler cf : this.roots) {
            URLConnection con = cf.openConnection(name);
            if (!con.getDoInput()) continue;
            if (cf instanceof AbstractFileURLStreamHandler) {
                FileConnection fc = (FileConnection)con;
                File file = fc.getFile();
                if (file.equals(f)) {
                    return null;
                }
                if (!file.exists()) continue;
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException mfue) {
                    assert (false) : mfue;
                    continue;
                }
            }
            return con.getURL();
        }
        for (File file : this.getFiles(name)) {
            if (file.equals(f)) {
                return null;
            }
            if (!file.exists()) continue;
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException mfue) {
                assert (false) : mfue;
            }
        }
        throw new IllegalArgumentException("File " + f + " is not a file for resource " + name);
    }

    public String toString() {
        return "" + this.context.getPath() + " resolving in " + this.roots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        if (o instanceof ResourceLoader) {
            ResourceLoader rl = (ResourceLoader)o;
            return rl.parent == this.parent && rl.context.sameFile(this.context);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        result = HashCodeUtil.hashCode(result, this.parent);
        result = HashCodeUtil.hashCode(result, this.context);
        return result;
    }

    private static void readClassWeights() {
        classWeights.clear();
        Collection col = (Collection)classWeightProperties.get("classloaderpatterns");
        if (col != null) {
            for (Map.Entry entry : col) {
                classWeights.put(Pattern.compile((String)entry.getKey()), Integer.parseInt((String)entry.getValue()));
            }
        }
        log.service("Found classWeights " + classWeights);
    }

    public static int getWeight(URL u) {
        int w = 0;
        log.debug("Getting weight for " + u + " with " + classWeights);
        if (classWeights != null) {
            for (Map.Entry<Pattern, Integer> e : classWeights.entrySet()) {
                if (!e.getKey().matcher(u.toExternalForm()).matches()) continue;
                log.debug(" " + e.getKey() + " matched " + u.toExternalForm() + ")");
                w = e.getValue();
                break;
            }
        }
        return w;
    }

    private static Comparator<URL> getUrlComparator() {
        if (urlComparator == null) {
            urlComparator = new Comparator<URL>(){

                @Override
                public int compare(URL u1, URL u2) {
                    int r;
                    int w1 = 0;
                    int w2 = 0;
                    boolean foundw1 = false;
                    boolean foundw2 = false;
                    if (classWeights != null) {
                        for (Map.Entry e : classWeights.entrySet()) {
                            Pattern p = (Pattern)e.getKey();
                            if (!foundw1 && p.matcher(u1.toExternalForm()).matches()) {
                                w1 = (Integer)e.getValue();
                                log.trace("Matched " + u1 + " " + p + " -> " + w1);
                                foundw1 = true;
                            }
                            if (!foundw2 && p.matcher(u2.toExternalForm()).matches()) {
                                w2 = (Integer)e.getValue();
                                log.trace("Matched " + u2 + " " + p + " -> " + w2);
                                foundw2 = true;
                            }
                            if (!foundw1 || !foundw2) continue;
                            break;
                        }
                    }
                    return (r = w2 - w1) == 0 ? u1.toString().compareTo(u2.toString()) : r;
                }

                @Override
                public boolean equals(Object o) {
                    return o == this;
                }

                public int hashCode() {
                    return 7;
                }
            };
        }
        return urlComparator;
    }

    public static void main(String[] argv) {
        ResourceLoader resourceLoader = System.getProperty("mmbase.htmlroot") != null ? ResourceLoader.getWebRoot() : (System.getProperty("mmbase.config") != null ? ResourceLoader.getConfigurationRoot() : ResourceLoader.getSystemRoot());
        try {
            if (argv.length == 0) {
                System.err.println("useage: java [-Dmmbase.config=<config dir>|-Dmmbase.htmlroot=<some other dir>] " + ResourceLoader.class.getName() + " [<sub directory>] [<resource-name>|*|**]");
                return;
            }
            String arg = argv[0];
            if (argv.length > 1) {
                resourceLoader = ResourceLoader.getConfigurationRoot().getChildResourceLoader(argv[0]);
                arg = argv[1];
            }
            if (arg.equals("*") || arg.equals("**")) {
                for (String s : resourceLoader.getResourcePaths(Pattern.compile(".*"), arg.equals("**"))) {
                    System.out.println("" + s);
                }
            } else {
                String line;
                InputStream resource = resourceLoader.getResourceAsStream(arg);
                if (resource == null) {
                    System.out.println("No such resource " + arg + " for " + resourceLoader.getResource(arg) + ". Creating now.");
                    PrintWriter writer = new PrintWriter(resourceLoader.getWriter(arg));
                    writer.println("TEST");
                    writer.close();
                    return;
                }
                System.out.println("-------------------- resolved " + resourceLoader.getResourceList(arg) + " with " + resourceLoader + ": ");
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource));
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
        }
        catch (Exception mfeu) {
            System.err.println(mfeu.getMessage() + Logging.stackTrace(mfeu));
        }
    }

    static {
        ResourceLoader.init(null);
        XML_PATTERN = Pattern.compile(".*\\.xml$");
        warned23 = false;
        classWeightProperties = new UtilReader(RESOURCELOADER_XML, new Runnable(){

            @Override
            public void run() {
                ResourceLoader.readClassWeights();
            }
        }){

            @Override
            protected Map.Entry<String, String> getEntry(DocumentReader reader, String key, String value) {
                if (key.startsWith("!")) {
                    String u = reader.getDocument().getDocumentURI();
                    String[] parts = u.split("!", 2);
                    if (log.isDebugEnabled()) {
                        log.debug(u + "-> " + Arrays.asList(parts));
                    }
                    if (parts.length == 2) {
                        key = "\\A" + ReplacingLocalizedString.makeLiteral(parts[0]) + key + "\\z";
                    } else {
                        int classes = u.lastIndexOf("/classes/");
                        if (classes > 0) {
                            String prefix = u.substring(0, classes + 1);
                            key = "\\A" + ReplacingLocalizedString.makeLiteral(prefix) + key.substring(1) + "\\z";
                            log.debug("Using key " + key + " in " + u);
                        } else {
                            log.debug("No /classes/ found in " + u);
                        }
                    }
                }
                return new Entry<String, String>(key, value);
            }
        }.getMaps();
        classWeights = new ConcurrentHashMap<Pattern, Integer>();
        ResourceLoader.readClassWeights();
    }

    private class MMURLConnection
    extends URLConnection {
        URLConnection inputConnection;
        URLConnection outputConnection;
        final String name;

        MMURLConnection(URL u) {
            super(u);
            this.inputConnection = null;
            this.outputConnection = null;
            this.name = this.url.getPath().substring(1);
            if (!this.url.getProtocol().equals(ResourceLoader.PROTOCOL)) {
                throw new RuntimeException("Only supporting URL's with protocol mm");
            }
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        protected URLConnection getInputConnection() {
            if (this.inputConnection != null) {
                return this.inputConnection;
            }
            for (PathURLStreamHandler cf : ResourceLoader.this.roots) {
                URLConnection c = cf.openConnection(this.name);
                if (!c.getDoInput()) continue;
                this.inputConnection = c;
                break;
            }
            if (this.inputConnection == null) {
                this.setDoInput(false);
                this.inputConnection = new NotAvailableUrlStreamHandler(ResourceLoader.this.parent).openConnection(this.name);
            } else {
                this.setDoInput(true);
            }
            this.connect();
            return this.inputConnection;
        }

        @Override
        public boolean getDoInput() {
            return this.getInputConnection().getDoInput();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.getInputConnection().getInputStream();
        }

        protected URLConnection getOutputConnection() {
            URLConnection c;
            PathURLStreamHandler cf;
            if (this.outputConnection != null) {
                return this.outputConnection;
            }
            ListIterator<PathURLStreamHandler> i = ResourceLoader.this.roots.listIterator();
            while (i.hasNext()) {
                cf = i.next();
                c = cf.openConnection(this.name);
                if (!c.getDoInput()) continue;
                if (!c.getDoOutput()) break;
                this.outputConnection = c;
                break;
            }
            if (this.outputConnection == null) {
                while (i.hasPrevious()) {
                    cf = i.previous();
                    c = cf.openConnection(this.name);
                    if (!c.getDoOutput()) continue;
                    this.outputConnection = c;
                    break;
                }
            }
            if (this.outputConnection == null) {
                this.setDoOutput(false);
                this.outputConnection = new NotAvailableUrlStreamHandler(ResourceLoader.this.parent).openConnection(this.name);
            } else {
                this.setDoOutput(true);
            }
            this.connect();
            return this.outputConnection;
        }

        @Override
        public boolean getDoOutput() {
            return this.getOutputConnection().getDoOutput();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            try {
                OutputStream os = this.getOutputConnection().getOutputStream();
                if (os == null) {
                    throw new IOException("Cannot create an OutputStream for " + this.url + ", it can no way written, and no resource-node could be created)");
                }
                return os;
            }
            catch (Exception ioe) {
                throw new IOException("Cannot create an OutputStream for " + this.url + " " + ioe.getMessage(), ioe);
            }
        }

        @Override
        public long getLastModified() {
            return this.getInputConnection().getLastModified();
        }
    }

    private class MMURLStreamHandler
    extends URLStreamHandler
    implements Serializable {
        private static final long serialVersionUID = 0L;

        MMURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new MMURLConnection(u);
        }

        @Override
        protected String toExternalForm(URL u) {
            return new MMURLConnection(u).getInputConnection().getURL().toExternalForm();
        }
    }

    private static class NotAvailableConnection
    extends URLConnection {
        private final String name;

        private NotAvailableConnection(URL u, String n) {
            super(u);
            while (n.startsWith("/")) {
                n = n.substring(1);
            }
            this.name = n;
        }

        @Override
        public void connect() throws IOException {
            throw new IOException("No such resource " + this.name);
        }

        @Override
        public boolean getDoInput() {
            return false;
        }

        @Override
        public boolean getDoOutput() {
            return false;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return null;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public String toString() {
            return "NOTAVAILABLECONNECTION " + this.name;
        }
    }

    private static class NotAvailableUrlStreamHandler
    extends PathURLStreamHandler {
        NotAvailableUrlStreamHandler(ResourceLoader parent) {
            super(parent);
        }

        @Override
        public NotAvailableUrlStreamHandler createSubHandler(ResourceLoader parent) {
            return new NotAvailableUrlStreamHandler(parent);
        }

        @Override
        protected String getName(URL u) {
            String path = u.getPath();
            return path.substring("/NOTFOUND/".length());
        }

        @Override
        public URLConnection openConnection(String name) {
            URL u;
            while (name.startsWith("/")) {
                name = name.substring(1);
            }
            try {
                String NOT_FOUND = "/localhost/NOTFOUND/";
                u = new URL(null, "http:/" + NOT_FOUND + name, this);
            }
            catch (MalformedURLException mfue) {
                throw new AssertionError((Object)mfue.getMessage());
            }
            return new NotAvailableConnection(u, name);
        }

        @Override
        public Set<String> getPaths(Set<String> results, Pattern pattern, boolean recursive, boolean directories) {
            return new HashSet<String>();
        }
    }

    protected static class ClassLoaderURLStreamHandler
    extends PathURLStreamHandler {
        private final String root;

        ClassLoaderURLStreamHandler(ResourceLoader parent, String r) {
            super(parent);
            this.root = r;
        }

        @Override
        public ClassLoaderURLStreamHandler createSubHandler(ResourceLoader parent) {
            return new ClassLoaderURLStreamHandler(parent, this.root);
        }

        private ClassLoader getClassLoader() {
            ClassLoader cl = ResourceLoader.class.getClassLoader();
            if (cl == null) {
                return ClassLoader.getSystemClassLoader();
            }
            return cl;
        }

        @Override
        protected String getName(URL u) {
            return u.getPath().substring((this.root + this.parent.context.getPath()).length());
        }

        private String getClassResourceName(String name) throws MalformedURLException {
            String res = this.root + new URL(this.parent.context, name).getPath();
            while (res.startsWith("/")) {
                res = res.substring(1);
            }
            if (log != null && log.isDebugEnabled()) {
                log.debug("Name  " + name + " is resource " + res);
            }
            return res;
        }

        protected SortedSet<URL> getSortedResources(String name) throws IOException {
            TreeSet<URL> result = new TreeSet<URL>(ResourceLoader.getUrlComparator());
            String crn = this.getClassResourceName(name);
            Enumeration<URL> e = this.getClassLoader().getResources(crn);
            while (e.hasMoreElements()) {
                URL n = e.nextElement();
                result.add(n);
            }
            return result;
        }

        @Override
        protected Enumeration<URL> getResources(String name) throws IOException {
            try {
                while (name.startsWith("/")) {
                    name = name.substring(1);
                }
                log.debug("Getting the resource " + name + " from " + this);
                return Collections.enumeration(this.getSortedResources(name));
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable t) {
                log.warn(t.getMessage(), t);
                return Collections.enumeration(Collections.EMPTY_LIST);
            }
        }

        @Override
        public final URLConnection openConnection(String name) {
            try {
                URLConnection u = null;
                Enumeration<URL> resources = this.getResources(name);
                while (resources.hasMoreElements()) {
                    URLConnection p = resources.nextElement().openConnection();
                    if (!p.getDoInput()) continue;
                    u = p;
                    break;
                }
                if (u == null) {
                    return new NotAvailableUrlStreamHandler(this.parent).openConnection(name);
                }
                return u;
            }
            catch (IOException ioe) {
                return new NotAvailableUrlStreamHandler(this.parent).openConnection(name);
            }
        }

        @Override
        public Set<String> getPaths(Set<String> results, Pattern pattern, boolean recursive, boolean directories) {
            return this.getPaths(results, pattern, recursive, directories, "", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> getPaths(Set<String> results, Pattern pattern, boolean recursive, boolean directories, String resourceDir, String searchUp) {
            try {
                ArrayList<String> subDirs = new ArrayList<String>();
                SortedSet<URL> resources = this.getSortedResources("".equals(resourceDir) ? ResourceLoader.INDEX : resourceDir + ResourceLoader.INDEX);
                if (searchUp != null && resourceDir.startsWith("..")) {
                    resourceDir = "";
                }
                for (URL u : resources) {
                    InputStream inputStream = u.openStream();
                    if (inputStream == null) continue;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            int firstSlash;
                            if (line.startsWith("#")) continue;
                            if ((line = line.trim()).startsWith("./")) {
                                line = line.substring(2);
                            }
                            if (searchUp != null) {
                                if (!line.startsWith(searchUp)) continue;
                                line = line.substring(searchUp.length());
                            }
                            if (directories) {
                                line = ResourceLoader.getDirectory(line);
                            }
                            if (line.equals("") || (firstSlash = line.indexOf(47)) > 0 && firstSlash < line.length() && !recursive) continue;
                            if (pattern == null || pattern.matcher(line).matches()) {
                                results.add("".equals(resourceDir) ? line : resourceDir + line);
                            }
                            if (!line.endsWith("/")) continue;
                            subDirs.add("".equals(resourceDir) ? line : resourceDir + line);
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                    finally {
                        reader.close();
                    }
                }
                if (recursive) {
                    for (String dir : subDirs) {
                        String newDir = "".equals(resourceDir) ? dir : resourceDir + dir;
                        this.getPaths(results, pattern, recursive, directories, newDir, null);
                    }
                }
                if (searchUp == null) {
                    searchUp = ResourceLoader.getDirectoryName(this.parent.context.getFile()) + '/';
                    String rd = "../";
                    for (ResourceLoader p = this.parent.parent; p != null; p = p.getParentResourceLoader()) {
                        this.getPaths(results, pattern, recursive, directories, rd, searchUp);
                        searchUp = ResourceLoader.getDirectoryName(p.context.getFile()) + '/' + searchUp;
                        rd = "../" + rd;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (log != null && log.isDebugEnabled()) {
                log.debug("Returning  " + results);
            }
            return results;
        }

        @Override
        public String toString() {
            return "ClassLoader " + this.root;
        }
    }

    protected static class FullyClassifiedClassLoaderURLStreamHandlerFactory
    extends URLStreamHandlerFactory {
        protected FullyClassifiedClassLoaderURLStreamHandlerFactory() {
        }

        @Override
        public PathURLStreamHandler[] createURLStreamHandler(ResourceLoader parent, Type type) {
            return new PathURLStreamHandler[]{new ClassLoaderURLStreamHandler(parent, "/")};
        }
    }

    protected static class ConfigClassLoaderURLStreamHandlerFactory
    extends URLStreamHandlerFactory {
        protected ConfigClassLoaderURLStreamHandlerFactory() {
        }

        @Override
        public PathURLStreamHandler[] createURLStreamHandler(ResourceLoader parent, Type type) {
            return new PathURLStreamHandler[]{new ClassLoaderURLStreamHandler(parent, ResourceLoader.CLASSLOADER_ROOT)};
        }
    }

    protected static class ServletResourceURLStreamHandler
    extends PathURLStreamHandler {
        private final String root;

        ServletResourceURLStreamHandler(ResourceLoader parent, String r) {
            super(parent);
            this.root = r;
        }

        @Override
        public ServletResourceURLStreamHandler createSubHandler(ResourceLoader parent) {
            return new ServletResourceURLStreamHandler(parent, this.root);
        }

        @Override
        protected String getName(URL u) {
            return u.getPath().substring((this.root + this.parent.context.getPath()).length());
        }

        @Override
        public URLConnection openConnection(String name) {
            try {
                URL u;
                String rn = this.root + this.parent.context.getPath() + name;
                if (rn.startsWith("//")) {
                    rn = rn.substring(1);
                }
                if ((u = servletContext.getResource(rn)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Not found " + rn + " in " + servletContext);
                    }
                    return new NotAvailableUrlStreamHandler(this.parent).openConnection(name);
                }
                log.debug("Found " + u);
                return u.openConnection();
            }
            catch (IOException ioe) {
                log.debug(ioe.getMessage());
                return new NotAvailableUrlStreamHandler(this.parent).openConnection(name);
            }
        }

        @Override
        public Set<String> getPaths(Set<String> results, Pattern pattern, boolean recursive, boolean directories) {
            if (log.isDebugEnabled()) {
                log.debug("Getting " + (directories ? "directories" : "files") + " matching '" + pattern + "' in '" + this.root + "'");
            }
            return this.getPaths(results, pattern, recursive ? "" : null, directories);
        }

        private Set<String> getPaths(Set<String> results, Pattern pattern, String recursive, boolean directories) {
            if (servletContext != null) {
                try {
                    String contextPath = this.parent.context.getPath();
                    if (contextPath.startsWith("/")) {
                        contextPath = contextPath.substring(1);
                    }
                    String currentRoot = this.root + (this.root.equals("/") ? "" : "/") + contextPath;
                    String resourcePath = currentRoot + (recursive == null ? "" : recursive);
                    Set c = servletContext.getResourcePaths(resourcePath);
                    if (log.isDebugEnabled()) {
                        log.debug("CurrentRoot '" + currentRoot + "' resourcePath '" + resourcePath + "' c: " + c);
                    }
                    if (c == null) {
                        return results;
                    }
                    for (String res : c) {
                        log.trace(res);
                        if (res.equals(resourcePath + "/")) continue;
                        String newResourcePath = res.substring(currentRoot.length());
                        boolean isDir = newResourcePath.endsWith("/");
                        if (isDir) {
                            newResourcePath = newResourcePath.substring(0, newResourcePath.length() - 1);
                            if (recursive != null) {
                                this.getPaths(results, pattern, newResourcePath, directories);
                            }
                            if (newResourcePath.equals("")) continue;
                        }
                        if ((pattern == null || pattern.matcher("/" + newResourcePath).matches()) && directories == isDir) {
                            log.debug("Adding " + newResourcePath);
                            results.add(newResourcePath);
                            continue;
                        }
                        log.debug("/" + newResourcePath + " does not match " + pattern);
                    }
                }
                catch (NoSuchMethodError nsme) {
                    if (!warned23) {
                        log.warn("Servet 2.3 feature not supported! " + nsme.getMessage());
                        warned23 = true;
                    }
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Returning " + results);
            }
            return results;
        }

        @Override
        public String toString() {
            return "ServletResource " + this.root;
        }
    }

    protected static class ConfigServletResourceURLStreamHandlerFactory
    extends URLStreamHandlerFactory {
        protected ConfigServletResourceURLStreamHandlerFactory() {
        }

        @Override
        public PathURLStreamHandler[] createURLStreamHandler(ResourceLoader parent, Type type) {
            if (servletContext != null) {
                String s = servletContext.getRealPath(ResourceLoader.RESOURCE_ROOT);
                if (s != null) {
                    return new PathURLStreamHandler[]{new FileURLStreamHandler(parent, new File(s), true)};
                }
                return new PathURLStreamHandler[]{new ServletResourceURLStreamHandler(parent, ResourceLoader.RESOURCE_ROOT)};
            }
            return new PathURLStreamHandler[0];
        }
    }

    protected static class ApplicationContextFileURLStreamHandler
    extends AbstractFileURLStreamHandler {
        private Map<String, String> FILES;

        ApplicationContextFileURLStreamHandler(ResourceLoader parent) {
            super(parent, true);
            try {
                this.FILES = ApplicationContextReader.getProperties("mmbase-config" + parent.context.getPath());
            }
            catch (NameNotFoundException nnfe) {
                log.debug(nnfe);
                this.FILES = new HashMap<String, String>();
            }
            catch (NoInitialContextException nice) {
                log.debug(nice);
                this.FILES = new HashMap<String, String>();
            }
            catch (NamingException ne) {
                log.error(ne);
                this.FILES = new HashMap<String, String>();
            }
            catch (NoClassDefFoundError ncdfe) {
                log.debug(ncdfe);
                this.FILES = new HashMap<String, String>();
            }
        }

        @Override
        public ApplicationContextFileURLStreamHandler createSubHandler(ResourceLoader parent) {
            return new ApplicationContextFileURLStreamHandler(parent);
        }

        protected File getFileFromString(String s) {
            if (s == null) {
                return null;
            }
            try {
                if (s.startsWith("file:")) {
                    return new File(new URI(s));
                }
                ResourceLoader wr = ResourceLoader.getWebRoot();
                if (wr != null) {
                    URI rootDir = wr.getResource("/").toURI();
                    if (rootDir.getScheme().equals("file")) {
                        return new File(new File(rootDir), s);
                    }
                    log.debug("The web root is no real directory");
                    return new File(s);
                }
                return new File(s);
            }
            catch (URISyntaxException use) {
                log.warn("" + s + " : " + use.getMessage(), use);
                return new File(s);
            }
        }

        @Override
        public File getFile(String in) {
            return this.getFileFromString(this.FILES.get(in));
        }

        @Override
        public String getName(URL u) {
            for (Map.Entry<String, String> entry : this.FILES.entrySet()) {
                try {
                    File file = this.getFileFromString(entry.getValue());
                    if (file == null || !file.toURI().toURL().sameFile(u)) continue;
                    return entry.getKey();
                }
                catch (MalformedURLException mfue) {
                    log.warn(mfue);
                }
            }
            return null;
        }

        @Override
        public String toString() {
            StringBuilder bul = new StringBuilder("{");
            for (Map.Entry<String, String> e : this.FILES.entrySet()) {
                if (bul.length() > 1) {
                    bul.append(", ");
                }
                bul.append(e.getKey()).append('=');
                File f = this.getFileFromString(e.getValue());
                bul.append(e.getValue());
                if (!f.exists()) {
                    bul.append("(").append(f.toURI()).append(" does not exist)");
                    continue;
                }
                if (f.canRead()) continue;
                bul.append("(").append(f).append(" cannot be read)");
            }
            bul.append("}");
            return bul.toString();
        }
    }

    protected static class ApplicationContextFileURLStreamHandlerFactory
    extends URLStreamHandlerFactory {
        protected ApplicationContextFileURLStreamHandlerFactory() {
        }

        @Override
        public PathURLStreamHandler[] createURLStreamHandler(ResourceLoader parent, Type type) {
            return new PathURLStreamHandler[]{new ApplicationContextFileURLStreamHandler(parent)};
        }
    }

    private static class FileConnection
    extends URLConnection {
        private final File file;
        private final boolean writeable;

        FileConnection(URL u, File f, boolean w) {
            super(u);
            this.file = f;
            this.writeable = w;
        }

        @Override
        public void connect() throws IOException {
            this.connected = true;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public boolean getDoInput() {
            return this.file.canRead();
        }

        @Override
        public boolean getDoOutput() {
            if (!this.writeable) {
                return false;
            }
            for (File f = this.file; f != null; f = f.getParentFile()) {
                if (!f.exists()) continue;
                return f.canWrite();
            }
            return false;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            return new FileInputStream(this.file);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (!this.connected) {
                this.connect();
            }
            if (!this.writeable) {
                throw new UnknownServiceException("This file-connection does not allow writing.");
            }
            File parent = this.file.getParentFile();
            if (parent != null) {
                if (!parent.exists()) {
                    log.info("Creating subdirs for " + this.file);
                }
                parent.mkdirs();
                if (!parent.exists()) {
                    log.warn("Could not create directory for " + this.file + ": " + parent);
                }
            } else {
                log.warn("Parent of " + this.file + " is null ?!");
            }
            if (this.file.isDirectory()) {
                final File directory = this.file;
                return new OutputStream(){

                    @Override
                    public void write(byte[] b) throws IOException {
                        if (b == null) {
                            directory.delete();
                        } else {
                            super.write(b);
                        }
                    }

                    @Override
                    public void write(int b) throws IOException {
                        throw new UnsupportedOperationException("Cannot write bytes to a directory outputstream");
                    }
                };
            }
            return new FileOutputStream(this.file){

                @Override
                public void write(byte[] b) throws IOException {
                    if (b == null) {
                        file.delete();
                    } else {
                        super.write(b);
                    }
                }
            };
        }

        @Override
        public long getLastModified() {
            return this.file.lastModified();
        }

        @Override
        public String toString() {
            return "FileConnection " + this.file.toString();
        }
    }

    protected static class FileURLStreamHandler
    extends AbstractFileURLStreamHandler {
        private final File fileRoot;

        FileURLStreamHandler(ResourceLoader parent, File root, boolean w) {
            super(parent, w);
            this.fileRoot = root;
        }

        @Override
        public FileURLStreamHandler createSubHandler(ResourceLoader parent) {
            return new FileURLStreamHandler(parent, this.fileRoot, this.writeable);
        }

        @Override
        public File getFile(String name) {
            if (name != null && name.startsWith("file:")) {
                try {
                    return new File(new URI(name));
                }
                catch (URISyntaxException use) {
                    log.warn(use);
                }
            }
            String fileName = this.fileRoot + this.parent.context.getPath() + (name == null ? "" : name);
            if (!File.separator.equals("/")) {
                fileName = fileName.replace('/', File.separator.charAt(0));
            }
            return new File(fileName);
        }

        @Override
        public String getName(URL u) {
            String path;
            int l = (this.fileRoot + this.parent.context.getPath()).length();
            try {
                path = new File(u.toURI()).getPath();
            }
            catch (URISyntaxException use) {
                log.error(use);
                path = u.getPath();
            }
            String r = l < path.length() ? path.substring(l) : path;
            return r;
        }

        @Override
        public String toString() {
            return this.fileRoot.toString();
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + (this.fileRoot != null ? this.fileRoot.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (o instanceof FileURLStreamHandler) {
                FileURLStreamHandler of = (FileURLStreamHandler)o;
                return of.fileRoot.equals(this.fileRoot);
            }
            return false;
        }
    }

    protected static abstract class AbstractFileURLStreamHandler
    extends PathURLStreamHandler {
        protected final boolean writeable;

        AbstractFileURLStreamHandler(ResourceLoader parent, boolean w) {
            super(parent);
            this.writeable = w;
        }

        @Override
        public URLConnection openConnection(String name) {
            URL u;
            try {
                if (name.startsWith("file:")) {
                    u = new URL(null, new URI(name).toURL().toString(), this);
                } else {
                    File file = this.getFile(name);
                    if (file == null) {
                        return new NotAvailableUrlStreamHandler(this.parent).openConnection(name);
                    }
                    String fileUrl = file.toURI().toURL().toString();
                    u = new URL(null, fileUrl, this);
                }
            }
            catch (URISyntaxException use) {
                throw new AssertionError((Object)use.getMessage());
            }
            catch (MalformedURLException mfue) {
                throw new AssertionError((Object)mfue.getMessage());
            }
            return new FileConnection(u, this.getFile(name), this.writeable);
        }

        @Override
        public Set<String> getPaths(Set<String> results, Pattern pattern, boolean recursive, boolean directories) {
            return this.getPaths(results, pattern, recursive ? "" : null, directories);
        }

        private Set<String> getPaths(Set<String> results, final Pattern pattern, final String recursive, boolean directories) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    return pattern == null || f.isDirectory() && recursive != null || pattern.matcher(name).matches();
                }
            };
            File f = this.getFile(recursive);
            if (f != null && f.isDirectory()) {
                File[] files = f.listFiles(filter);
                if (files == null) {
                    return results;
                }
                for (File element : files) {
                    if (element.getName().equals("")) continue;
                    if (recursive != null && element.isDirectory()) {
                        this.getPaths(results, pattern, recursive + element.getName() + "/", directories);
                    }
                    if (!element.canRead() || directories != element.isDirectory()) continue;
                    results.add((recursive == null ? "" : recursive) + element.getName());
                }
            }
            return results;
        }

        public abstract File getFile(String var1);
    }

    protected static class ClassesFileURLStreamHandlerFactory
    extends URLStreamHandlerFactory {
        protected ClassesFileURLStreamHandlerFactory() {
        }

        @Override
        public PathURLStreamHandler[] createURLStreamHandler(ResourceLoader parent, Type type) {
            String s;
            if (servletContext != null && (s = servletContext.getRealPath("/WEB-INF/classes/org/mmbase/config")) != null) {
                return new PathURLStreamHandler[]{new FileURLStreamHandler(parent, new File(s), false)};
            }
            return new PathURLStreamHandler[0];
        }
    }

    protected static class MMBaseConfigSettingFileURLStreamHandlerFactory
    extends URLStreamHandlerFactory {
        protected MMBaseConfigSettingFileURLStreamHandlerFactory() {
        }

        @Override
        public PathURLStreamHandler[] createURLStreamHandler(ResourceLoader parent, Type type) {
            String configPath = null;
            ServletContext servletContext = ResourceLoader.getServletContext();
            if (servletContext != null) {
                configPath = servletContext.getInitParameter("mmbase.config");
                log.debug("found the mmbase config path parameter using the mmbase.config servlet context parameter");
            }
            if (configPath == null) {
                try {
                    configPath = System.getProperty("mmbase.config");
                }
                catch (SecurityException se) {
                    log.info(se.getMessage());
                }
                if (configPath != null) {
                    log.debug("found the mmbase.config path parameter using the mmbase.config system property");
                }
            } else {
                try {
                    if (System.getProperty("mmbase.config") != null) {
                        log.warn("mmbase.config system property is masked by mmbase.config servlet context parameter");
                    }
                }
                catch (SecurityException se) {
                    log.debug(se.getMessage());
                }
            }
            if (configPath != null) {
                if (servletContext != null && configPath.startsWith("$WEBROOT")) {
                    configPath = servletContext.getRealPath(configPath.substring(8));
                }
                log.debug("Adding " + configPath);
                return new PathURLStreamHandler[]{new FileURLStreamHandler(configRoot, new File(configPath), true)};
            }
            return new PathURLStreamHandler[0];
        }
    }

    public static abstract class PathURLStreamHandler
    extends URLStreamHandler
    implements Comparable<PathURLStreamHandler> {
        protected final ResourceLoader parent;
        protected int weight = 0;

        protected PathURLStreamHandler(ResourceLoader p) {
            this.parent = p;
        }

        protected abstract PathURLStreamHandler createSubHandler(ResourceLoader var1);

        public abstract URLConnection openConnection(String var1);

        protected abstract String getName(URL var1);

        protected Enumeration<URL> getResources(final String name) throws IOException {
            return new Enumeration<URL>(){
                private boolean hasMore = true;

                @Override
                public boolean hasMoreElements() {
                    return this.hasMore;
                }

                @Override
                public URL nextElement() {
                    this.hasMore = false;
                    return this.openConnection(name).getURL();
                }
            };
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            String name = this.getName(u);
            if (name != null) {
                return this.openConnection(name);
            }
            log.warn("" + this + " could not find name for " + u);
            return new NotAvailableUrlStreamHandler(this.parent).openConnection(u.getPath());
        }

        protected abstract Set<String> getPaths(Set<String> var1, Pattern var2, boolean var3, boolean var4);

        public void setWeight(int w) {
            this.weight = w;
        }

        @Override
        public int compareTo(PathURLStreamHandler o) {
            return this.weight - o.weight;
        }

        public Integer getResourceNode(String name) {
            return null;
        }

        public String toString() {
            return "" + this.weight + ":" + super.toString();
        }
    }

    public static abstract class URLStreamHandlerFactory {
        public abstract PathURLStreamHandler[] createURLStreamHandler(ResourceLoader var1, Type var2);
    }

    public static class ServletContextInit
    implements SystemEventListener {
        @Override
        public void notify(SystemEvent se) {
            if (se instanceof SystemEvent.ServletContext) {
                ServletContext sx = ((SystemEvent.ServletContext)se).getServletContext();
                ResourceLoader.init(sx);
            }
        }

        @Override
        public int getWeight() {
            return -1000;
        }

        public boolean equals(Object o) {
            return o instanceof ServletContextInit;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static enum Type {
        CONFIG{

            @Override
            public ResourceLoader get() {
                return ResourceLoader.getConfigurationRoot();
            }
        }
        ,
        WEB{

            @Override
            public ResourceLoader get() {
                return ResourceLoader.getWebRoot();
            }
        }
        ,
        SYSTEM{

            @Override
            public ResourceLoader get() {
                return ResourceLoader.getSystemRoot();
            }
        };


        public abstract ResourceLoader get();
    }
}

