/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import org.mmbase.util.RandomPool;
import org.mmbase.util.functions.Name;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class PasswordGenerator {
    private static final Logger log = Logging.getLoggerInstance(PasswordGenerator.class);
    private static String[] consonants = new String[]{"b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "qu", "r", "s", "t", "v", "w", "x", "z", "ch", "cr", "fr", "nd", "ng", "nk", "nt", "ph", "pr", "rd", "sh", "sl", "sp", "st", "th", "tr"};
    private static String[] vowels = new String[]{"a", "e", "i", "o", "u", "y"};
    RandomPool ranPool = new RandomPool();
    String defaulttemplate = "SSSSSS";

    public static void main(String[] args) {
        PasswordGenerator PG = new PasswordGenerator();
        log.info("Password " + PG.getPassword());
        log.info("Password " + PG.getPassword("SSS 9 SSS"));
        log.info("Password " + PG.getPassword("SSSS"));
        log.info("Password " + PG.getPassword("SSSSS"));
        log.info("Password " + PG.getPassword("SSSSSS"));
        log.info("Password " + PG.getPassword("CCC CCC CCC"));
        log.info("Password " + PG.getPassword("HHHH HHHH HHHH"));
        log.info("Password " + PG.getPassword("AAAAA AAAAA AAAAA"));
        log.info("Password " + PG.getPassword("99999 99999 99999"));
        log.info("Password " + PG.getPassword("66666 66666 66666"));
    }

    private int mod(long x, long y) {
        if (x < 0L) {
            x = -x;
        }
        if (y < 0L) {
            y = -y;
        }
        return (int)(x % y);
    }

    public String getPassword() {
        return this.getPassword(this.defaulttemplate);
    }

    public String getPassword(@Name(value="template") String template) {
        boolean next = true;
        StringBuilder pwd = new StringBuilder();
        int len = template.length();
        for (int i = 0; i < len; ++i) {
            this.ranPool.stir(i * 93762 + 49104);
            next = this.addChar(pwd, template, i, next);
        }
        return pwd.toString();
    }

    private boolean addChar(StringBuilder password, String template, int ntmpl, boolean consonantNext) {
        int ch = 0;
        String charsOut = null;
        if (ntmpl >= template.length()) {
            consonantNext = true;
            return consonantNext;
        }
        char tmplChar = template.charAt(ntmpl);
        if (tmplChar == ' ') {
            ch = 32;
        } else if (tmplChar == 'A') {
            ch = this.mod(this.ranPool.value(), 26L) + 97;
        } else if (tmplChar == 'C') {
            ch = this.mod(this.ranPool.value(), 36L);
            ch = ch < 10 ? (ch += 48) : ch + 97 - 10;
        } else if (tmplChar == 'H') {
            ch = this.mod(this.ranPool.value(), 16L);
            ch = ch < 10 ? (ch += 48) : ch + 97 - 10;
        } else if (tmplChar == 'S') {
            if (consonantNext) {
                charsOut = consonants[this.mod(this.ranPool.value(), consonants.length)];
                if (!"qu".equals(charsOut)) {
                    consonantNext = false;
                }
            } else {
                charsOut = vowels[this.mod(this.ranPool.value(), vowels.length)];
                consonantNext = true;
            }
        } else if (tmplChar == '6') {
            ch = this.mod(this.ranPool.value(), 6L) + 49;
        } else if (tmplChar == '9') {
            ch = this.mod(this.ranPool.value(), 10L) + 48;
        } else {
            return consonantNext;
        }
        if (charsOut == null) {
            charsOut = String.valueOf((char)ch);
            consonantNext = true;
        }
        password.append(charsOut);
        return consonantNext;
    }

    public String getModuleInfo() {
        return "Password Generator module, based on the code of Arnold G. Reinhold, Cambridge, MA, USA. Author Rico Jansen";
    }
}

