/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.IOException;
import java.io.InputStream;

public abstract class MockInputStream
extends InputStream {
    protected boolean closed = false;
    private final int length;
    private int cursor = 0;

    public MockInputStream(int l) {
        this.length = l;
    }

    protected abstract int oneByte();

    protected abstract void fillArray(byte[] var1, int var2, int var3);

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.cursor >= this.length) {
            return -1;
        }
        ++this.cursor;
        return this.oneByte();
    }

    @Override
    public int read(byte[] data, int offset, int l) throws IOException {
        this.checkOpen();
        if (this.cursor >= this.length) {
            return -1;
        }
        this.cursor += l;
        if (this.cursor > this.length) {
            l -= this.cursor - this.length;
            this.cursor = this.length;
        }
        this.fillArray(data, offset, l);
        return l;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        this.checkOpen();
        this.cursor = (int)((long)this.cursor + bytesToSkip);
        if (this.cursor > this.length) {
            bytesToSkip -= (long)(this.cursor - this.length);
            this.cursor = this.length;
        }
        return bytesToSkip;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException(this.getClass().getName() + ": Input stream closed");
        }
    }

    @Override
    public int available() {
        return this.length - this.cursor;
    }
}

