/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.mmbase.Version;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEvent;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.ResourceLoader;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class MMBaseContext
implements ServletContextListener {
    private static final Logger LOG = Logging.getLoggerInstance(MMBaseContext.class);
    public static final Logger INITLOG = Logging.getLoggerInstance("org.mmbase.INIT");
    private static boolean initialized = false;
    private static boolean shutdown = false;
    private static boolean htmlRootInitialized = false;
    private static ServletContext sx;
    private static String userDir;
    private static String htmlRoot;
    private static String htmlRootUrlPath;
    private static boolean htmlRootUrlPathInitialized;
    private static String outputFile;
    private static String encoding;
    private static String host;
    private static String dataDirString;
    private static boolean shownDataDir;
    public static final int startTime;
    private static String machineName;

    public static synchronized void init(ServletContext servletContext) {
        if (!initialized || initialized && sx == null) {
            String mmbaseOutputFile;
            if (servletContext == null) {
                throw new IllegalArgumentException();
            }
            if (initialized) {
                LOG.info("Reinitializing, this time with ServletContext");
            }
            sx = servletContext;
            LOG.service("Found servletContext " + sx);
            EventManager.getInstance().propagateEvent(new SystemEvent.ServletContext(sx), true);
            userDir = sx.getInitParameter("user.dir");
            if (userDir == null) {
                try {
                    userDir = System.getProperty("user.dir");
                }
                catch (SecurityException se) {
                    LOG.service(se.getMessage());
                }
            }
            if (userDir != null && userDir.indexOf("$WEBROOT") == 0) {
                userDir = servletContext.getRealPath(userDir.substring(8));
            }
            if ((mmbaseOutputFile = sx.getInitParameter("mmbase.outputfile")) == null) {
                try {
                    mmbaseOutputFile = System.getProperty("mmbase.outputfile");
                }
                catch (SecurityException se) {
                    LOG.debug(se.getMessage());
                }
            }
            if (mmbaseOutputFile != null && mmbaseOutputFile.indexOf("$WEBROOT") == 0) {
                mmbaseOutputFile = servletContext.getRealPath(mmbaseOutputFile.substring(8));
            }
            MMBaseContext.initOutputfile(mmbaseOutputFile);
            String initLoggingParam = sx.getInitParameter("mmbase.initlogging");
            if (initLoggingParam == null || "true".equals(initLoggingParam)) {
                EventManager.getInstance().addEventListener(new SystemEventListener(){

                    @Override
                    public void notify(SystemEvent se) {
                        if (se instanceof SystemEvent.ResourceLoaderChange) {
                            MMBaseContext.initLogging();
                        }
                    }

                    @Override
                    public int getWeight() {
                        return 10000;
                    }
                });
            }
            initialized = true;
            try {
                MMBaseContext.initHtmlRoot();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    public static synchronized void init(String configPath, boolean initLogging) throws Exception {
        if (!initialized) {
            LOG.service("Initializing with " + configPath);
            try {
                userDir = System.getProperty("user.dir");
            }
            catch (SecurityException se) {
                LOG.info(se.getMessage());
            }
            try {
                MMBaseContext.initOutputfile(System.getProperty("mmbase.outputfile"));
            }
            catch (SecurityException se) {
                LOG.info(se.getMessage());
            }
            if (initLogging) {
                MMBaseContext.initLogging();
            }
            initialized = true;
        }
    }

    public static synchronized void init() throws Exception {
        MMBaseContext.init(System.getProperty("mmbase.config"), true);
    }

    public static ThreadGroup getThreadGroup() {
        return ThreadPools.threadGroup;
    }

    public static Thread startThread(Runnable task, String name) {
        Thread kicker = new Thread(MMBaseContext.getThreadGroup(), task, MMBaseContext.getMachineName() + ":" + name);
        kicker.setDaemon(true);
        kicker.start();
        return kicker;
    }

    private static void initOutputfile(String o) {
        outputFile = o;
        if (outputFile != null) {
            if (!new File(outputFile).isAbsolute()) {
                outputFile = userDir + File.separator + outputFile;
            }
            try {
                PrintStream stream = new PrintStream(new FileOutputStream(outputFile, true));
                System.setOut(stream);
                System.setErr(stream);
            }
            catch (IOException e) {
                outputFile = null;
                LOG.error("Failed to set mmbase.outputfile to '" + outputFile + "'.");
                LOG.error(Logging.stackTrace(e));
            }
        }
    }

    private static void initLogging() {
        Logging.configure(ResourceLoader.getConfigurationRoot().getChildResourceLoader("log"), "log.xml");
        INITLOG.info("===========================");
        INITLOG.info("MMBase logging initialized.");
        INITLOG.info("===========================");
        try {
            INITLOG.info("java.version       : " + System.getProperty("java.version"));
        }
        catch (SecurityException se) {
            INITLOG.info("java.version       : " + se.getMessage());
        }
        INITLOG.info("user.dir          : " + userDir);
        String configPath = ResourceLoader.getConfigurationRoot().toString();
        INITLOG.info("configuration     : " + configPath);
        INITLOG.info("webroot           : " + ResourceLoader.getWebRoot());
        String version = Version.get();
        INITLOG.info("version           : " + version);
        Runtime rt = Runtime.getRuntime();
        INITLOG.info("total memory      : " + rt.totalMemory() / 0x100000L + " MiB");
        INITLOG.info("free memory       : " + rt.freeMemory() / 0x100000L + " MiB");
        INITLOG.service("system locale     : " + Locale.getDefault());
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            INITLOG.info("Assertions are enabled");
        }
        INITLOG.info("start time        : " + DateFormat.getDateTimeInstance(0, 0).format(new Date(1000L * (long)startTime)));
    }

    public static synchronized void initHtmlRoot() throws ServletException {
        if (!initialized) {
            throw new RuntimeException("The init(ServletContext) method should be called first. (Not initalized)");
        }
        if (null == sx) {
            throw new RuntimeException("The init(ServletContext) method should be called first. (No servlet context was given)");
        }
        if (!htmlRootInitialized) {
            htmlRoot = sx.getInitParameter("mmbase.htmlroot");
            if (htmlRoot == null) {
                try {
                    htmlRoot = System.getProperty("mmbase.htmlroot");
                }
                catch (SecurityException se) {
                    LOG.debug(se);
                }
            }
            if (htmlRoot == null) {
                htmlRoot = sx.getRealPath("");
            }
            if (htmlRoot == null) {
                LOG.service("Parameter mmbase.htmlroot not set.");
            } else {
                if (userDir != null && !new File(htmlRoot).isAbsolute()) {
                    htmlRoot = userDir + File.separator + htmlRoot;
                }
                if (!new File(htmlRoot).isDirectory()) {
                    userDir = null;
                    htmlRoot = null;
                    throw new ServletException("Parameter mmbase.htmlroot is not pointing to a directory.");
                }
                if (htmlRoot.endsWith(File.separator)) {
                    htmlRoot = htmlRoot.substring(0, htmlRoot.length() - 1);
                }
            }
            htmlRootInitialized = true;
            INITLOG.info("mmbase.htmlroot   : " + htmlRoot);
            INITLOG.info("context           : " + MMBaseContext.getHtmlRootUrlPath());
        }
    }

    public static ServletContext getServletContext() {
        if (!initialized) {
            throw new RuntimeException("The init method should be called first.");
        }
        return sx;
    }

    public static String getConfigPath() {
        List<File> files = ResourceLoader.getConfigurationRoot().getFiles("");
        if (files.isEmpty()) {
            return null;
        }
        return files.get(0).getAbsolutePath();
    }

    public static String getHtmlRoot() {
        if (!htmlRootInitialized) {
            throw new RuntimeException("The initHtmlRoot method should be called first.");
        }
        return htmlRoot;
    }

    public static boolean isHtmlRootInitialized() {
        return htmlRootInitialized;
    }

    public static String getOutputFile() {
        if (!initialized) {
            throw new RuntimeException("The init method should be called first.");
        }
        return outputFile;
    }

    public static String getHtmlRootUrlPath() {
        if (!htmlRootUrlPathInitialized) {
            LOG.debug("Finding root url");
            if (!initialized) {
                throw new RuntimeException("The init method should be called first.");
            }
            if (sx == null) {
                htmlRootUrlPathInitialized = true;
                return htmlRootUrlPath;
            }
            String initPath = sx.getInitParameter("mmbase.htmlrooturlpath");
            if (initPath != null) {
                LOG.debug("Found mmbase.htmlrooturlpath  explicitely configured");
                htmlRootUrlPath = initPath;
            } else {
                try {
                    LOG.debug("Autodetecting htmlrooturlpath ");
                    if (sx.equals(sx.getContext("/"))) {
                        htmlRootUrlPath = "/";
                    } else if (sx.getMajorVersion() > 2 || sx.getMajorVersion() == 2 && sx.getMinorVersion() >= 5) {
                        try {
                            htmlRootUrlPath = sx.getClass().getMethod("getContextPath", new Class[0]).invoke((Object)sx, new Object[0]) + "/";
                        }
                        catch (Exception e) {
                            LOG.error(e);
                        }
                    } else {
                        int length;
                        String url = sx.getResource("/").toString();
                        int lastSlash = url.substring(0, (length = url.length()) - 1).lastIndexOf(47);
                        if (lastSlash > 0) {
                            htmlRootUrlPath = url.substring(lastSlash);
                            LOG.info("Found " + htmlRootUrlPath + " from " + url);
                        } else {
                            LOG.warn("Could not determine htmlRootUrlPath. Using default " + htmlRootUrlPath + "(contextUrl     :" + url + ")");
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error(e);
                }
                try {
                    ServletContext refound = sx.getContext(htmlRootUrlPath);
                    if (refound != null && !sx.equals(refound)) {
                        LOG.warn("Probably did not succeed in determining htmlRootUrlPath ('" + htmlRootUrlPath + "', because " + sx + "!= " + refound + "). Consider using the mmbase.htmlrooturlpath  context-param in web.xml");
                    }
                }
                catch (Exception e2) {
                    LOG.error(e2);
                }
            }
            htmlRootUrlPathInitialized = true;
        }
        return htmlRootUrlPath;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getMachineName() {
        return machineName;
    }

    public static void setMachineName(String nm) {
        if (machineName != null && !machineName.equals(nm)) {
            throw new IllegalStateException();
        }
        machineName = nm;
    }

    public static void shutdown() {
        shutdown = true;
        EventManager.getInstance().propagateEvent(new SystemEvent.Shutdown());
    }

    public static boolean isShutdown() {
        return shutdown;
    }

    public static String getEncoding() {
        return encoding == null ? "ISO-8859-1" : encoding;
    }

    public static void setEncoding(String e) {
        if (encoding != null && !encoding.equals(e)) {
            throw new IllegalStateException();
        }
        encoding = e;
    }

    public static String getHost() {
        return host == null ? "unknown" : host;
    }

    public static void setHost(String h) {
        if (host != null && !host.equals(h)) {
            throw new IllegalStateException();
        }
        host = h;
    }

    public static File getDataDir() {
        File dataDir;
        ServletContext sc = MMBaseContext.getServletContext();
        if (dataDirString == null) {
            dataDirString = sc == null ? "data" : "WEB-INF/data";
        }
        if (!(dataDir = new File(dataDirString)).isAbsolute()) {
            if (sc != null && sc.getRealPath("/" + dataDirString) != null) {
                LOG.debug(" " + sc.getRealPath("/" + dataDirString));
                dataDir = new File(sc.getRealPath("/" + dataDirString));
            } else {
                dataDir = new File(System.getProperty("user.dir"), dataDirString);
            }
        }
        if (!dataDir.exists()) {
            try {
                if (dataDir.mkdirs()) {
                    LOG.info("Created " + dataDir);
                }
            }
            catch (SecurityException se) {
                LOG.warn(se);
            }
        }
        if (!dataDir.isDirectory()) {
            LOG.warn("Datadir " + dataDir + " is not a directory");
        }
        if (!dataDir.canRead()) {
            LOG.warn("Datadir " + dataDir + " is not readable");
        }
        boolean canWrite = false;
        try {
            canWrite = dataDir.canWrite();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!canWrite) {
            try {
                File proposal;
                File file = proposal = sc != null ? (File)sc.getAttribute("javax.servlet.context.tempdir") : new File(System.getProperty("java.io.tmpdir"));
                if (proposal.canWrite()) {
                    LOG.warn("Datadir " + dataDir + " is not writable. Falling back to " + proposal);
                    dataDir = proposal;
                } else {
                    LOG.warn("Datadir " + dataDir + " is not writable.");
                }
            }
            catch (SecurityException se) {
                LOG.warn(se.getMessage(), se);
            }
        }
        if (shownDataDir) {
            LOG.debug("MMBase data dir: " + dataDir);
        } else {
            LOG.info("MMBase data dir: " + dataDir);
            shownDataDir = true;
        }
        return dataDir;
    }

    public static void setDataDir(String setting) {
        if (dataDirString != null && !dataDirString.equals(setting)) {
            throw new IllegalStateException();
        }
        if ("".equals(setting)) {
            setting = null;
        }
        if (!new File(dataDirString = setting).canWrite()) {
            LOG.warn("The data dir " + dataDirString + " is not writable");
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        MMBaseContext.shutdown();
    }

    public void contextInitialized(ServletContextEvent sce) {
        LOG.debug("Received " + sce);
        MMBaseContext.init(sce.getServletContext());
    }

    static {
        htmlRootUrlPath = "/";
        htmlRootUrlPathInitialized = false;
        encoding = null;
        host = null;
        shownDataDir = false;
        startTime = (int)(System.currentTimeMillis() / 1000L);
        machineName = null;
    }
}

