/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mmbase.cache.CacheImplementationInterface;
import org.mmbase.util.SizeMeasurable;
import org.mmbase.util.SizeOf;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class LRUHashtable<K, V>
implements Cloneable,
CacheImplementationInterface<K, V>,
SizeMeasurable {
    private static final Logger log = Logging.getLoggerInstance(LRUHashtable.class);
    private final Hashtable<K, LRUEntry> backing;
    private final LRUEntry root = new LRUEntry();
    private final LRUEntry dangling = new LRUEntry();
    private int maxSize = 0;

    public LRUHashtable(int size, int cap, float lf) {
        this.backing = new Hashtable(cap, lf);
        this.root.next = this.dangling;
        this.dangling.prev = this.root;
        this.maxSize = size;
    }

    public LRUHashtable(int size, int cap) {
        this(size, cap, 0.75f);
    }

    public LRUHashtable(int size) {
        this(size, 101, 0.75f);
    }

    public LRUHashtable() {
        this(100, 101, 0.75f);
    }

    @Override
    public Object getLock() {
        return this.backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Hashtable<K, LRUEntry> hashtable = this.backing;
        synchronized (hashtable) {
            V rtn;
            LRUEntry work = this.backing.get(key);
            if (work != null) {
                rtn = work.value;
                work.value = value;
                this.removeEntry(work);
                this.appendEntry(work);
            } else {
                rtn = null;
                work = new LRUEntry(key, value);
                this.backing.put(key, work);
                this.appendEntry(work);
                if (this.backing.size() > this.maxSize) {
                    Object remove = this.root.next.key;
                    V was = this.remove(remove);
                    assert (was != null);
                    if (was == null) {
                        log.warn("Nothing was removed, while that was expected " + remove + " should have been removed");
                    }
                }
            }
            return rtn;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public boolean containsValue(Object o) {
        return this.values().contains(o);
    }

    @Override
    public boolean containsKey(Object o) {
        return this.backing.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public int getCount(Object key) {
        LRUEntry work = this.backing.get(key);
        if (work != null) {
            return work.requestCount;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Hashtable<K, LRUEntry> hashtable = this.backing;
        synchronized (hashtable) {
            LRUEntry work = this.backing.get(key);
            if (work != null) {
                ++work.requestCount;
                Object rtn = work.value;
                this.removeEntry(work);
                this.appendEntry(work);
                return rtn;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Hashtable<K, LRUEntry> hashtable = this.backing;
        synchronized (hashtable) {
            LRUEntry work = this.backing.remove(key);
            if (work != null) {
                Object rtn = work.value;
                this.removeEntry(work);
                return rtn;
            }
            return null;
        }
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.backing.keySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new LRUEntrySet();
    }

    @Override
    public Collection<V> values() {
        return new LRUValues();
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public void setMaxSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Cannot set size of LRUHashtable to negative value");
        }
        if (size < this.maxSize) {
            while (this.size() > this.maxSize) {
                this.remove(this.root.next.key);
            }
        }
        this.maxSize = size;
    }

    @Override
    public int maxSize() {
        return this.maxSize;
    }

    private void appendEntry(LRUEntry wrk) {
        this.dangling.prev.next = wrk;
        wrk.prev = this.dangling.prev;
        wrk.next = this.dangling;
        this.dangling.prev = wrk;
    }

    private void removeEntry(LRUEntry wrk) {
        wrk.next.prev = wrk.prev;
        wrk.prev.next = wrk.next;
        wrk.next = null;
        wrk.prev = null;
    }

    public String toString() {
        return "Size=" + this.size() + ", Max=" + this.maxSize;
    }

    public String toString(boolean which) {
        if (which) {
            StringBuilder b = new StringBuilder();
            b.append("Size " + this.size() + ", Max " + this.maxSize + " : ");
            b.append(super.toString());
            return b.toString();
        }
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Hashtable<K, LRUEntry> hashtable = this.backing;
        synchronized (hashtable) {
            while (this.root.next != this.dangling) {
                this.removeEntry(this.root.next);
            }
            this.backing.clear();
        }
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public Enumeration<V> elements() {
        return new LRUHashtableEnumeration();
    }

    public Enumeration<V> getOrderedElements() {
        return this.getOrderedElements(-1);
    }

    public Enumeration<V> getOrderedElements(int maxnumber) {
        ArrayList results = new ArrayList();
        LRUEntry current = this.root.next;
        if (maxnumber != -1) {
            for (int i = 0; current != null && current != this.dangling && i < maxnumber; ++i) {
                results.add(0, current.value);
                current = current.next;
            }
        } else {
            while (current != null && current != this.dangling) {
                results.add(0, current.value);
                current = current.next;
            }
        }
        return Collections.enumeration(results);
    }

    public List<? extends Map.Entry<K, V>> getOrderedEntries() {
        return this.getOrderedEntries(-1);
    }

    public List<? extends Map.Entry<K, V>> getOrderedEntries(int maxNumber) {
        ArrayList<LRUEntry> results = new ArrayList<LRUEntry>();
        LRUEntry current = this.root.next;
        for (int i = 0; current != null && current != this.dangling && (maxNumber < 0 || i < maxNumber); ++i) {
            results.add(0, current);
            current = current.next;
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public void config(Map<String, String> map) {
    }

    @Override
    public int getByteSize() {
        return this.getByteSize(new SizeOf());
    }

    @Override
    public int getByteSize(SizeOf sizeof) {
        int len = 16 + 50 * this.size();
        LRUEntry current = this.root.next;
        while (current != null && current != this.dangling) {
            current = current.next;
            len += sizeof.sizeof(current.key);
            len += sizeof.sizeof(current.value);
        }
        return len;
    }

    protected class LRUValues
    extends AbstractCollection<V> {
        final Collection<LRUEntry> col;

        LRUValues() {
            this.col = LRUHashtable.this.backing.values();
        }

        @Override
        public int size() {
            return this.col.size();
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator<LRUEntry> i = this.col.iterator();
            return new Iterator<V>(){
                LRUEntry work;

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public V next() {
                    this.work = (LRUEntry)i.next();
                    return this.work.getValue();
                }

                @Override
                public void remove() {
                    i.remove();
                    if (this.work != null) {
                        LRUHashtable.this.removeEntry(this.work);
                    }
                }
            };
        }
    }

    protected class LRUEntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Map.Entry<K, LRUEntry>> it;
        LRUEntry work;

        LRUEntrySetIterator(Iterator<Map.Entry<K, LRUEntry>> i) {
            this.it = i;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = this.it.next();
            this.work = entry.getValue();
            return this.work;
        }

        @Override
        public void remove() {
            this.it.remove();
            if (this.work != null) {
                LRUHashtable.this.removeEntry(this.work);
            }
        }
    }

    protected class LRUEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<K, LRUEntry>> set;

        LRUEntrySet() {
            this.set = LRUHashtable.this.backing.entrySet();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LRUEntrySetIterator(this.set.iterator());
        }
    }

    public class LRUEntry
    implements Map.Entry<K, V>,
    SizeMeasurable {
        protected V value;
        protected LRUEntry next;
        protected LRUEntry prev;
        protected K key;
        protected int requestCount = 0;

        LRUEntry() {
            this(null, null);
        }

        LRUEntry(K key, V val) {
            this(key, val, null, null);
        }

        LRUEntry(K key, V value, LRUEntry prev, LRUEntry next) {
            this.value = value;
            this.next = next;
            this.prev = prev;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V o) {
            throw new UnsupportedOperationException("Cannot change values in LRU Hashtable");
        }

        @Override
        public int getByteSize() {
            return new SizeOf().sizeof(this.value);
        }

        @Override
        public int getByteSize(SizeOf sizeof) {
            return 20 + sizeof.sizeof(this.value);
        }

        public String toString() {
            return this.key + "=" + (this.value == LRUHashtable.this ? "[this lru]" : String.valueOf(this.value));
        }
    }

    private class LRUHashtableEnumeration
    implements Enumeration<V> {
        private Enumeration<V> superior;

        LRUHashtableEnumeration() {
            this.superior = LRUHashtable.this.elements();
        }

        @Override
        public boolean hasMoreElements() {
            return this.superior.hasMoreElements();
        }

        @Override
        public V nextElement() {
            LRUEntry entry = (LRUEntry)this.superior.nextElement();
            return entry.value;
        }
    }
}

