/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.mmbase.util.ThreadPools;

public class IECompatibleJpegInputStream
extends FilterInputStream
implements Runnable {
    private PipedInputStream pis = new PipedInputStream();
    private PipedOutputStream pos = new PipedOutputStream();

    public IECompatibleJpegInputStream(InputStream in) {
        super(in);
        try {
            this.pis.connect(this.pos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ThreadPools.filterExecutor.execute(this);
    }

    @Override
    public void run() {
        try {
            int magic1 = this.in.read();
            int magic2 = this.in.read();
            this.pos.write(magic1);
            this.pos.write(magic2);
            if (magic1 == 255 && magic2 == 216) {
                int b;
                while ((b = this.in.read()) != -1) {
                    if (b == 255) {
                        int size;
                        int lsb;
                        int msb;
                        int marker = this.in.read();
                        if (marker == 0 || marker == 216 || marker == 217) {
                            this.pos.write(b);
                            this.pos.write(marker);
                            continue;
                        }
                        if (marker >= 224 && marker <= 239) {
                            msb = this.in.read();
                            lsb = this.in.read();
                            size = msb * 256 + lsb;
                            this.in.skip(size - 2);
                            continue;
                        }
                        msb = this.in.read();
                        lsb = this.in.read();
                        size = msb * 256 + lsb;
                        size -= 2;
                        this.pos.write(b);
                        this.pos.write(marker);
                        this.pos.write(msb);
                        this.pos.write(lsb);
                        while (size > 0) {
                            this.pos.write(this.in.read());
                            --size;
                        }
                        continue;
                    }
                    this.pos.write(b);
                }
            } else {
                int c;
                byte[] buf = new byte[1024];
                while ((c = this.in.read(buf)) != -1) {
                    this.pos.write(buf, 0, c);
                }
            }
            this.in.close();
            this.pos.flush();
            this.pos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int available() throws IOException {
        return this.pis.available();
    }

    @Override
    public void close() throws IOException {
        this.pis.close();
        super.close();
    }

    @Override
    public int read() throws IOException {
        return this.pis.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.pis.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.pis.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.pis.skip(n);
    }

    public static byte[] process(byte[] in) {
        try {
            IECompatibleJpegInputStream inputStream = new IECompatibleJpegInputStream(new ByteArrayInputStream(in));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int c = 0;
            byte[] buf = new byte[1024];
            while ((c = ((InputStream)inputStream).read(buf)) != -1) {
                out.write(buf, 0, c);
            }
            out.flush();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return in;
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length == 0) {
            System.err.println(IECompatibleJpegInputStream.class.getName() + " removes headers from jpeg files");
            System.err.println("it requires 2 parameters , the input jpeg and the output jpeg");
            System.exit(1);
        } else if (argv.length == 2) {
            File file = new File(argv[0]);
            if (!file.exists()) {
                System.err.println("can't convert non existing file" + file.getPath());
            }
            File out = new File(argv[1]);
            IECompatibleJpegInputStream in = new IECompatibleJpegInputStream(new FileInputStream(file));
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(out));
            int c = 0;
            while ((c = ((InputStream)in).read()) != -1) {
                ((OutputStream)fos).write(c);
            }
            ((InputStream)in).close();
            ((OutputStream)fos).flush();
            ((OutputStream)fos).close();
        }
    }
}

