/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.File;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mmbase.util.ThreadPools;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.UtilReader;

public abstract class FileWatcher {
    private static final Logger log = Logging.getLoggerInstance(FileWatcher.class);
    public static final long DEFAULT_DELAY = 60000L;
    public static long THREAD_DELAY = 10000L;
    static ScheduledFuture<?> future;
    static FileWatcherRunner fileWatchers;
    private static Map<String, String> props;
    private static Runnable watcher;
    private long delay = 60000L;
    private Set<FileEntry> files = new LinkedHashSet<FileEntry>();
    private Set<File> fileSet = new FileSet();
    private Set<File> removeFiles = new HashSet<File>();
    private boolean stop = false;
    private boolean running = false;
    private boolean continueAfterChange = false;
    private long lastCheck = System.currentTimeMillis();

    static void scheduleFileWatcherRunner() {
        try {
            if (future != null) {
                future.cancel(true);
            }
            future = ThreadPools.scheduler.scheduleAtFixedRate(fileWatchers, THREAD_DELAY, THREAD_DELAY, TimeUnit.MILLISECONDS);
            ThreadPools.identify(future, "File Watcher");
        }
        catch (Throwable t) {
            log.error(t);
        }
    }

    public static void shutdown() {
        future.cancel(true);
        fileWatchers.cancel();
        fileWatchers = null;
        log.service("Shut down file watcher thread");
    }

    protected FileWatcher() {
        this(true);
    }

    protected FileWatcher(boolean c) {
        this.continueAfterChange = c;
    }

    public void start() {
        this.stop = false;
        if (fileWatchers != null) {
            fileWatchers.add(this);
        }
        this.running = true;
    }

    public abstract void onChange(File var1);

    public void setDelay(long delay) {
        this.delay = delay;
        if (delay < THREAD_DELAY) {
            log.info("Delay of " + this + "  (" + delay + " ms) is smaller than the delay of the watching thread. Will not watch more often then once per " + THREAD_DELAY + " ms. Set to " + THREAD_DELAY);
            this.delay = THREAD_DELAY;
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isContinueAfterChange() {
        return this.continueAfterChange;
    }

    public Date getLastCheck() {
        return new Date(this.lastCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(File file) {
        FileEntry fe = new FileEntry(file);
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            this.files.add(fe);
            if (this.removeFiles.remove(fe)) {
                log.service("Canceling removal from filewatcher " + fe);
            }
        }
    }

    public boolean contains(File file) {
        return this.files.contains(new FileEntry(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(File file) {
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            log.debug("Secheduling " + file + " from removal", new Exception());
            this.removeFiles.add(file);
        }
    }

    public Set<File> getFiles() {
        return this.fileSet;
    }

    public void clear() {
        this.fileSet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        log.debug("Exiting " + this);
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            this.stop = true;
        }
    }

    public String toString() {
        return this.files.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean changed() {
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            for (FileEntry fe : this.files) {
                if (!fe.changed()) continue;
                log.debug("the file :" + fe.getFile().getAbsolutePath() + " has changed.");
                try {
                    this.onChange(fe.getFile());
                }
                catch (Throwable e) {
                    log.warn("onChange of " + fe.getFile().getName() + " lead to exception:");
                    log.warn(Logging.stackTrace(e));
                }
                if (this.continueAfterChange) {
                    fe.updated();
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFiles() {
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            for (File f : this.removeFiles) {
                FileEntry found = null;
                for (FileEntry fe : this.files) {
                    if (!fe.getFile().equals(f)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("removing file[" + fe.getFile().getName() + "]");
                    }
                    found = fe;
                    break;
                }
                if (found == null) continue;
                this.files.remove(found);
                log.service("Removed " + found + " from watchlist");
            }
            this.removeFiles.clear();
            this.running = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mustStop() {
        FileWatcher fileWatcher = this;
        synchronized (fileWatcher) {
            return this.stop;
        }
    }

    public static Set<FileWatcher> getFileWatchers() {
        return Collections.unmodifiableSet(fileWatchers.watchers);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            TestFileWatcher w = new TestFileWatcher();
            for (int j = 0; j < 4; ++j) {
                try {
                    w.add(File.createTempFile("filewatchertestfile", ".txt"));
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            w.setDelay(1000L);
            w.start();
        }
        System.out.println("Starting");
        long start = System.currentTimeMillis();
        for (long k = 0L; k < 400000000L; ++k) {
        }
        System.out.println("\ntook " + (System.currentTimeMillis() - start) + " ms");
    }

    static {
        fileWatchers = new FileWatcherRunner();
        FileWatcher.scheduleFileWatcherRunner();
        watcher = new Runnable(){

            @Override
            public void run() {
                try {
                    String delay = (String)props.get("delay");
                    if (delay != null) {
                        THREAD_DELAY = Integer.parseInt(delay);
                        FileWatcher.scheduleFileWatcherRunner();
                        log.service("Set thread delay time to " + THREAD_DELAY);
                    }
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
        };
        props = new UtilReader("resourcewatcher.xml", watcher).getProperties();
        watcher.run();
    }

    private class FileIterator
    implements Iterator<File> {
        Iterator<FileEntry> it;
        File lastFile;

        FileIterator() {
            this.it = FileWatcher.this.files.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public File next() {
            FileEntry f = this.it.next();
            this.lastFile = f.getFile();
            return this.lastFile;
        }

        @Override
        public void remove() {
            FileWatcher.this.remove(this.lastFile);
        }
    }

    private class FileSet
    extends AbstractSet<File> {
        private FileSet() {
        }

        @Override
        public int size() {
            return FileWatcher.this.files.size();
        }

        @Override
        public Iterator<File> iterator() {
            return new FileIterator();
        }

        @Override
        public boolean add(File o) {
            int s = this.size();
            FileWatcher.this.add(o);
            return s != this.size();
        }
    }

    private class FileEntry {
        private long lastModified = -1L;
        private boolean exists = false;
        private final File file;

        public FileEntry(File file) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            this.exists = file.exists();
            this.lastModified = this.getLastModified(file);
            this.file = file;
        }

        protected long getLastModified(File f) {
            long lm;
            if (!f.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug("file :" + f.getAbsolutePath() + " did not exist (yet)");
                }
                lm = -1L;
            } else {
                lm = f.lastModified();
                if (f.isDirectory() && f.canRead()) {
                    for (File child : f.listFiles()) {
                        try {
                            long childLastModified = this.getLastModified(child);
                            if (childLastModified <= lm) continue;
                            lm = childLastModified;
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }
            }
            return lm;
        }

        public boolean changed() {
            if (this.file.exists()) {
                boolean result;
                if (!this.exists) {
                    log.info("File " + this.file.getAbsolutePath() + " added");
                    return true;
                }
                boolean bl = result = this.lastModified < this.getLastModified(this.file);
                if (result) {
                    log.info("File " + this.file.getAbsolutePath() + " changed");
                }
                return result;
            }
            if (this.exists) {
                log.info("File " + this.file.getAbsolutePath() + " removed");
            }
            return this.exists;
        }

        public void updated() {
            this.exists = this.file.exists();
            this.lastModified = this.exists ? this.getLastModified(this.file) : -1L;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.toString() + ":" + this.lastModified;
        }

        public boolean equals(Object o) {
            if (o instanceof FileEntry) {
                FileEntry fe = (FileEntry)o;
                return this.file.equals(fe.file);
            }
            if (o instanceof File) {
                return this.file.equals(o);
            }
            return false;
        }

        public int hashCode() {
            return this.file.hashCode();
        }
    }

    private static class TestFileWatcher
    extends FileWatcher {
        int i = 0;

        private TestFileWatcher() {
        }

        @Override
        public void onChange(File f) {
            ++this.i;
        }

        protected void finalize() {
            System.out.println(this.toString() + ":" + this.i);
        }
    }

    static class FileWatcherRunner
    implements Runnable {
        private Set<FileWatcher> watchers = new CopyOnWriteArraySet<FileWatcher>();

        FileWatcherRunner() {
        }

        void add(FileWatcher f) {
            this.watchers.add(f);
        }

        void remove(FileWatcher f) {
            this.watchers.remove(f);
        }

        int size() {
            return this.watchers.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                try {
                    long now = System.currentTimeMillis();
                    ArrayList<FileWatcher> removed = new ArrayList<FileWatcher>();
                    for (FileWatcher f : this.watchers) {
                        long staleness = now - f.lastCheck;
                        if (staleness < f.delay) continue;
                        if (log.isTraceEnabled()) {
                            log.trace("Filewatcher " + f + " with " + f.delay + " ms <= " + staleness + " ms is expired. Currently it's watching: " + f.getClass().getName() + " " + f.toString());
                        }
                        if (f.changed() || f.mustStop()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Removing filewatcher " + f + " " + f.mustStop());
                            }
                            removed.add(f);
                        }
                        f.lastCheck = now;
                    }
                    if (removed.size() <= 0) break block10;
                    log.debug("Now removing " + removed);
                    FileWatcherRunner fileWatcherRunner = this;
                    synchronized (fileWatcherRunner) {
                        int sizeBefore = this.watchers.size();
                        this.watchers.removeAll(removed);
                        log.debug("Size " + sizeBefore + " -> " + this.watchers.size());
                        for (FileWatcher w : removed) {
                            w.removeFiles();
                        }
                    }
                }
                catch (Throwable ex) {
                    log.error("Exception: " + ex.getClass().getName() + ": " + ex.getMessage() + Logging.stackTrace(ex));
                }
            }
        }

        public void cancel() {
            this.watchers.clear();
        }
    }
}

