/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class ExtendedProperties
extends Properties {
    private static final Logger log = Logging.getLoggerInstance(ExtendedProperties.class);
    protected String commentPrefix = "#";

    public ExtendedProperties() {
    }

    public ExtendedProperties(String filename) {
        try {
            this.getProps(filename);
        }
        catch (IOException e) {
            log.error("Failed to load the ExtendedProperties for: " + filename);
        }
    }

    public ExtendedProperties(ExtendedProperties exProp) {
        super(exProp);
    }

    public Hashtable<Object, Object> readProperties(String filename) {
        this.clear();
        try {
            this.getProps(filename);
        }
        catch (IOException e) {
            log.debug("Failed to load the ExtendedProperties from: " + filename, e);
        }
        ExtendedProperties propsToReturn = new ExtendedProperties();
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            propsToReturn.put(s, this.get(s));
        }
        return propsToReturn;
    }

    public synchronized void saveProperties(String filename, Hashtable<Object, Object> propsToSave) {
        this.clear();
        Enumeration<Object> e = propsToSave.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.put(s, propsToSave.get(s));
        }
        try {
            this.save(filename);
        }
        catch (IOException ioe) {
            log.error("Fail to save the ExtendedProperties to: " + filename + " : " + ioe);
        }
    }

    public Vector<String> getPropertyValues(String whichProp, String delimeter) {
        Vector<String> parsedPropsToReturn = new Vector<String>();
        if (this.containsKey(whichProp)) {
            String value = (String)this.get(whichProp);
            StringTokenizer tok = new StringTokenizer(value, delimeter);
            while (tok.hasMoreTokens()) {
                parsedPropsToReturn.addElement(tok.nextToken());
            }
            return parsedPropsToReturn;
        }
        return null;
    }

    public final void getProps(String filename) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(filename);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (FileNotFoundException e) {
            log.debug("ExtendedProperties:: file " + filename + " not found");
        }
    }

    @Override
    public final synchronized void load(InputStream in) throws IOException {
        in = Runtime.getRuntime().getLocalizedInputStream(in);
        int ch = in.read();
        block17: while (ch != -1) {
            switch (ch) {
                case 33: 
                case 35: {
                    while ((ch = in.read()) >= 0 && ch != 10 && ch != 13) {
                    }
                    continue block17;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ch = in.read();
                    continue block17;
                }
            }
            StringBuffer key = new StringBuffer();
            while (ch >= 0 && ch != 61 && ch != 32 && ch != 9 && ch != 10 && ch != 13) {
                key.append((char)ch);
                ch = in.read();
            }
            while (ch == 32 && ch == 9) {
                ch = in.read();
            }
            if (ch == 61 || ch == 58) {
                ch = in.read();
            }
            while (ch == 32 && ch == 9) {
                ch = in.read();
            }
            StringBuffer val = new StringBuffer();
            block22: while (ch >= 0 && ch != 10 && ch != 13) {
                if (ch == 92) {
                    ch = in.read();
                    switch (ch) {
                        case 13: {
                            ch = in.read();
                            if (ch != 10 && ch != 32 && ch != 9) continue block22;
                        }
                        case 10: {
                            while ((ch = in.read()) == 32 || ch == 9) {
                            }
                            continue block22;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 117: {
                            while ((ch = in.read()) == 117) {
                            }
                            int d = 0;
                            block25: for (int i = 0; i < 4; ++i) {
                                switch (ch) {
                                    case 48: 
                                    case 49: 
                                    case 50: 
                                    case 51: 
                                    case 52: 
                                    case 53: 
                                    case 54: 
                                    case 55: 
                                    case 56: 
                                    case 57: {
                                        d = (d << 4) + ch - 48;
                                        break;
                                    }
                                    case 97: 
                                    case 98: 
                                    case 99: 
                                    case 100: 
                                    case 101: 
                                    case 102: {
                                        d = (d << 4) + 10 + ch - 97;
                                        break;
                                    }
                                    case 65: 
                                    case 66: 
                                    case 67: 
                                    case 68: 
                                    case 69: 
                                    case 70: {
                                        d = (d << 4) + 10 + ch - 65;
                                        break;
                                    }
                                    default: {
                                        break block25;
                                    }
                                }
                                ch = in.read();
                            }
                            ch = d;
                        }
                    }
                }
                val.append((char)ch);
                ch = in.read();
            }
            this.put(key.toString(), val.toString());
        }
    }

    private void write(String filename, String header) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this.save(bufferedOutputStream, header);
        bufferedOutputStream.close();
    }

    public synchronized void save(String filename) throws IOException {
        File file = new File(filename);
        boolean des = false;
        if (file.exists()) {
            ExtendedProperties copyOfProps = (ExtendedProperties)this.clone();
            String newlines = "";
            String lines = this.readOldProps(file);
            StringTokenizer tok = new StringTokenizer(lines, "\n", true);
            while (tok.hasMoreTokens()) {
                String line = (String)tok.nextElement();
                if (line.startsWith(this.commentPrefix)) {
                    newlines = newlines + line;
                    continue;
                }
                int index = line.indexOf(61);
                if (index == -1) {
                    if (!des) {
                        newlines = newlines + "\n";
                        continue;
                    }
                    des = false;
                    continue;
                }
                String name = line.substring(0, index);
                if (this.containsKey(name)) {
                    newlines = newlines + name + "=" + this.getProperty(name);
                    copyOfProps.remove(name);
                    continue;
                }
                des = true;
            }
            Enumeration<Object> e = copyOfProps.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                newlines = newlines + "\n" + name + "=" + copyOfProps.getProperty(name);
            }
            file.delete();
            RandomAccessFile writefile = new RandomAccessFile(file, "rw");
            writefile.writeBytes(newlines);
            writefile.close();
        } else {
            this.write(filename, "");
        }
    }

    private String readOldProps(File file) throws IOException {
        String line = "";
        String lines = "";
        RandomAccessFile readfile = new RandomAccessFile(file, "r");
        do {
            try {
                line = readfile.readLine();
                if (line == null) continue;
                lines = lines + line + "\n";
            }
            catch (Exception e) {
                log.error("EOF!");
            }
        } while (line != null);
        if (lines.length() > 0) {
            lines = lines.substring(0, lines.length() - 1);
        }
        readfile.close();
        return lines;
    }

    @Override
    public Object setProperty(String name, String value) {
        return this.put(name, value);
    }

    public void showContents() {
        Enumeration<?> names = this.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            log.debug(name + "=" + this.getProperty(name));
        }
    }

    public synchronized String save() {
        StringBuffer b = new StringBuffer();
        b.append('#');
        b.append(new Date());
        b.append('\n');
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            b.append(key);
            b.append('=');
            String val = (String)this.get(key);
            int len = val.length();
            if (len > 0) {
                b.append(val);
            }
            b.append('\n');
        }
        return b.toString();
    }
}

