/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mmbase.util.dateparser.DateParser;
import org.mmbase.util.dateparser.ParseException;

public class DynamicDate
extends Date {
    private static final long serialVersionUID = 0L;
    protected final String date;

    public static Date getInstance(String format) throws ParseException {
        if ("null".equals(format)) {
            return null;
        }
        DateParser parser = new DateParser(new StringReader(format));
        try {
            parser.start();
            if (parser.dynamic()) {
                return new DynamicDate(format);
            }
            return parser.toDate();
        }
        catch (ParseException pe) {
            ParseException p = new ParseException("In " + format + " " + pe.getMessage());
            p.initCause(pe);
            throw p;
        }
    }

    public static Date eval(String format) {
        try {
            return DynamicDate.eval(DynamicDate.getInstance(format));
        }
        catch (ParseException e) {
            return new Date(-1L);
        }
    }

    public static Date eval(Date date) {
        if (date instanceof DynamicDate) {
            return ((DynamicDate)date).evalDate();
        }
        return date;
    }

    protected DynamicDate(String d) {
        this.date = d;
    }

    public String getFormat() {
        return this.date;
    }

    protected Date evalDate() {
        DateParser parser = new DateParser(new StringReader(this.date));
        try {
            parser.start();
            return parser.toDate();
        }
        catch (ParseException pe) {
            return new Date();
        }
    }

    @Override
    public boolean after(Date when) {
        return this.evalDate().after(when);
    }

    @Override
    public boolean before(Date when) {
        return this.evalDate().before(when);
    }

    @Override
    public Object clone() {
        try {
            return DynamicDate.getInstance(this.date);
        }
        catch (ParseException pe) {
            return new Date();
        }
    }

    @Override
    public int compareTo(Date anotherDate) {
        return this.evalDate().compareTo(anotherDate);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DynamicDate) {
            return this.date.equals(((DynamicDate)obj).date);
        }
        return false;
    }

    @Override
    @Deprecated
    public int getDate() {
        return this.evalDate().getDate();
    }

    @Override
    @Deprecated
    public int getDay() {
        return this.evalDate().getDay();
    }

    @Override
    @Deprecated
    public int getHours() {
        return this.evalDate().getHours();
    }

    @Override
    @Deprecated
    public int getMinutes() {
        return this.evalDate().getMinutes();
    }

    @Override
    @Deprecated
    public int getMonth() {
        return this.evalDate().getMonth();
    }

    @Override
    @Deprecated
    public int getSeconds() {
        return this.evalDate().getSeconds();
    }

    @Override
    public long getTime() {
        return this.evalDate().getTime();
    }

    @Override
    @Deprecated
    public int getTimezoneOffset() {
        return this.evalDate().getTimezoneOffset();
    }

    @Override
    @Deprecated
    public int getYear() {
        return this.evalDate().getYear();
    }

    @Override
    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public void setTime(long time) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        throw new UnsupportedOperationException("Cannot set date in dynamic date");
    }

    @Override
    @Deprecated
    public String toGMTString() {
        return this.evalDate().toGMTString();
    }

    @Override
    @Deprecated
    public String toLocaleString() {
        return this.evalDate().toLocaleString();
    }

    @Override
    public String toString() {
        return this.date + ": " + this.evalDate().toString();
    }

    public static String[] getDemo() {
        return new String[]{"0", "10000", "-10000", "+1000", "1973-05-03", "2006-05-09", "-3-12-25", "2000-01-01 16:00", "TZUTC 2001-01-01 16:00", "today 12:34:56.789", "now", "today", "tomorrow", "now + 10 minute", "today + 5 day", "now this year", "next august", "today + 6 month next august", "tomonth", "borreltijd", "today + 5 dayish", "yesteryear", "mondayish", "duration + 5 minute", "duration + 100 year", "TZUTC today noon", "TZEurope/Amsterdam today noon", "TZUTC today", "TZEurope/Amsterdam today", "TZ UTC today noon", "TZ Europe/Amsterdam today noon", "TZ UTC today", "TZ Europe/Amsterdam today", "TZ Europe/Amsterdam -1000", "today 6 oclock", "today 23 oclock", "today 43 oclock", "tosecond", "tominute", "tohour", "today", "previous monday", "tomonth", "toyear", "tocentury", "tocentury_pedantic", "toera", "toweek", "now this second", "now this minute", "now this hour", "now this day", "today previous monday", "now this month", "now this year", "now this century", "now this era", "now - 15 year this century", "now - 20 year this century_pedantic", "today + 2 century", "toera - 1 minute", "this july", "previous july", "next july", "this sunday", "previous sunday", "next sunday", "2009-W01-01", "2009-W53-7", "2006-123", "2005-01-01 this monday"};
    }

    public static void main(String[] argv) throws java.text.ParseException, ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("GGGG yyyy-MM-dd HH:mm:ss.SSS zzz E");
        if (argv.length == 0) {
            String[] demo;
            for (String element : demo = DynamicDate.getDemo()) {
                try {
                    Date d1 = DynamicDate.getInstance(element);
                    System.out.print(formatter.format(d1) + "\t");
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                System.out.println(element);
            }
            System.out.println("This was demo, you can also call with an argument, to try it yourself");
            System.out.println("Also try with different values for -Duser.timezone=");
        } else {
            Date d1 = DynamicDate.getInstance(argv[0]);
            if (argv.length > 1) {
                SimpleDateFormat my = new SimpleDateFormat(argv[1]);
                System.out.println(my.format(d1));
            } else {
                System.out.println(formatter.format(d1) + " " + d1.getTime());
            }
        }
    }
}

