/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class DijkstraSemaphore {
    private static final Logger log = Logging.getLoggerInstance(DijkstraSemaphore.class);
    private int count;
    private int maxCount;
    private final Object starvationLock = new Object();

    public DijkstraSemaphore(int pMaxCount) {
        this(pMaxCount, pMaxCount);
    }

    public DijkstraSemaphore(int pMaxCount, int pInitialCount) {
        this.count = pInitialCount;
        this.maxCount = pMaxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquire() throws InterruptedException {
        while (this.count == 0) {
            long startwait = 0L;
            if (log.isDebugEnabled()) {
                startwait = System.currentTimeMillis();
            }
            this.wait();
            if (startwait == 0L) continue;
            log.debug("Waited " + (System.currentTimeMillis() - startwait) + " ms for a resource");
        }
        --this.count;
        Object object = this.starvationLock;
        synchronized (object) {
            if (this.count == 0) {
                this.starvationLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryAcquire() {
        if (this.count != 0) {
            --this.count;
            Object object = this.starvationLock;
            synchronized (object) {
                if (this.count == 0) {
                    this.starvationLock.notify();
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void release() {
        ++this.count;
        if (this.count > this.maxCount) {
            this.count = this.maxCount;
        }
        this.notify();
    }

    public synchronized void release(int pCount) {
        while (this.count < this.maxCount && pCount != 0) {
            this.release();
            --pCount;
        }
    }

    public synchronized void acquireAll() throws InterruptedException {
        while (this.count != 0) {
            this.acquire();
        }
    }

    public synchronized void releaseAll() {
        this.release(this.maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void starvationCheck() throws InterruptedException {
        Object object = this.starvationLock;
        synchronized (object) {
            if (this.count != 0) {
                this.starvationLock.wait();
            }
        }
    }
}

