/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.mmbase.util.dateparser.DateParser;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class DateFormats {
    private static final Logger log = Logging.getLoggerInstance(DateFormats.class);

    public static DateFormat getInstance(String format, String timeZone, Locale locale) {
        DateFormat df;
        if (format.length() > 0 && format.charAt(0) == ':') {
            log.debug("found symbolic format");
            if (format.charAt(1) == '.') {
                df = DateFormat.getTimeInstance(DateFormats.getDateFormatStyle(format.substring(2)), locale);
            } else if (format.indexOf(46) == -1) {
                df = DateFormat.getDateInstance(DateFormats.getDateFormatStyle(format.substring(1)), locale);
            } else {
                int i = format.indexOf(46);
                df = DateFormat.getDateTimeInstance(DateFormats.getDateFormatStyle(format.substring(1, i)), DateFormats.getDateFormatStyle(format.substring(i + 1)), locale);
            }
        } else if ("e".equals(format)) {
            df = new DayOfWeekDateFormat();
        } else if ("RFC822".equals(format) || "rfc822".equals(format)) {
            df = new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss Z", Locale.US);
            timeZone = "UTC";
        } else {
            df = new SimpleDateFormat(format, locale);
        }
        if (timeZone != null && !timeZone.equals("")) {
            ((DateFormat)df).setTimeZone(TimeZone.getTimeZone(timeZone));
        } else {
            ((DateFormat)df).setTimeZone(DateParser.defaultTimeZone);
        }
        return df;
    }

    private static int getDateFormatStyle(String style) {
        if ("FULL".equals(style)) {
            return 0;
        }
        if ("LONG".equals(style)) {
            return 1;
        }
        if ("MEDIUM".equals(style)) {
            return 2;
        }
        if ("SHORT".equals(style)) {
            return 3;
        }
        throw new IllegalArgumentException("Unknown DateFormat Style " + style);
    }

    protected static class DayOfWeekDateFormat
    extends DateFormat {
        private TimeZone zone = null;

        protected DayOfWeekDateFormat() {
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            Calendar calendar = Calendar.getInstance(this.zone != null ? this.zone : DateParser.defaultTimeZone);
            int day = source.charAt(0) - 48;
            pos.setIndex(pos.getIndex() + 1);
            calendar.set(7, day);
            return calendar.getTime();
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            Calendar calendar = Calendar.getInstance(this.zone != null ? this.zone : DateParser.defaultTimeZone);
            calendar.setTime(date);
            toAppendTo.append(calendar.get(7));
            return toAppendTo;
        }

        @Override
        public void setTimeZone(TimeZone value) {
            this.zone = value;
        }
    }
}

