/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ChainedWriter
extends Writer {
    private final List<Writer> writers = new ArrayList<Writer>();

    public ChainedWriter(Writer ... ls) {
        for (Writer w : ls) {
            this.addWriter(w);
        }
    }

    public final ChainedWriter addWriter(Writer w) {
        this.writers.add(w);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        for (Writer w : this.writers) {
            w.append(c);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        for (Writer w : this.writers) {
            w.append(csq);
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        for (Writer w : this.writers) {
            w.append(csq, start, end);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        for (Writer w : this.writers) {
            w.close();
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer w : this.writers) {
            w.flush();
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        for (Writer w : this.writers) {
            w.write(cbuf);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            w.write(cbuf, off, len);
        }
    }

    @Override
    public void write(int c) throws IOException {
        for (Writer w : this.writers) {
            w.write(c);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (Writer w : this.writers) {
            w.write(str, off, len);
        }
    }
}

