/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ChainedOutputStream
extends OutputStream {
    private final List<OutputStream> streams = new ArrayList<OutputStream>();

    public ChainedOutputStream(OutputStream ... ls) {
        for (OutputStream o : ls) {
            this.addOutputStream(o);
        }
    }

    public final ChainedOutputStream addOutputStream(OutputStream o) {
        this.streams.add(o);
        return this;
    }

    @Override
    public final void close() throws IOException {
        for (OutputStream o : this.streams) {
            o.close();
        }
    }

    @Override
    public final void flush() throws IOException {
        for (OutputStream o : this.streams) {
            o.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        for (OutputStream o : this.streams) {
            o.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream o : this.streams) {
            o.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream o : this.streams) {
            o.write(b);
        }
    }

    public String toString() {
        return this.streams.toString();
    }
}

