/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ChainedIterator<E>
implements Iterator<E> {
    private final List<Iterator<E>> iterators = new ArrayList<Iterator<E>>();
    private Iterator<Iterator<E>> iteratorIterator = null;
    private Iterator<E> iterator = null;

    public ChainedIterator() {
    }

    public ChainedIterator(Iterator<E> ... is) {
        for (Iterator<E> i : is) {
            this.iterators.add(i);
        }
    }

    public ChainedIterator<E> addIterator(Iterator<E> i) {
        if (this.iteratorIterator != null) {
            throw new IllegalStateException();
        }
        this.iterators.add(i);
        return this;
    }

    private void setIterator() {
        while (this.iteratorIterator.hasNext() && this.iterator == null) {
            this.iterator = this.iteratorIterator.next();
            if (this.iterator.hasNext()) continue;
            this.iterator = null;
        }
    }

    private void start() {
        if (this.iteratorIterator == null) {
            this.iteratorIterator = this.iterators.iterator();
            this.setIterator();
        }
    }

    @Override
    public boolean hasNext() {
        this.start();
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public E next() {
        this.start();
        if (this.iterator == null) {
            throw new NoSuchElementException();
        }
        E res = this.iterator.next();
        if (!this.iterator.hasNext()) {
            this.iterator = null;
            this.setIterator();
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] argv) {
        ChainedIterator it = new ChainedIterator();
        ArrayList o = new ArrayList();
        ArrayList<String> a = new ArrayList<String>();
        a.add("a");
        a.add("b");
        ArrayList b = new ArrayList();
        ArrayList<String> c = new ArrayList<String>();
        c.add("c");
        c.add("d");
        ArrayList d = new ArrayList();
        it.addIterator(o.iterator());
        it.addIterator(a.iterator());
        it.addIterator(b.iterator());
        it.addIterator(c.iterator());
        it.addIterator(d.iterator());
        while (it.hasNext()) {
            System.out.println("" + (String)it.next());
        }
    }
}

