/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ChainedComparator<E>
implements Comparator<E> {
    private final List<Comparator<E>> comparators = new ArrayList<Comparator<E>>();

    public ChainedComparator(Comparator<E> ... cmps) {
        for (Comparator<E> c : cmps) {
            this.addComparator(c);
        }
    }

    public final ChainedComparator<E> addComparator(Comparator<E> c) {
        this.comparators.add(c);
        return this;
    }

    @Override
    public int compare(E e1, E e2) {
        int result = 0;
        for (Comparator<E> c : this.comparators) {
            result = c.compare(e1, e2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ChainedComparator) {
            ChainedComparator c = (ChainedComparator)o;
            return this.comparators.equals(c.comparators);
        }
        return false;
    }
}

