/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.FileItem;
import org.mmbase.util.BasicCaster;
import org.mmbase.util.Caster;
import org.mmbase.util.DynamicDate;
import org.mmbase.util.Encode;
import org.mmbase.util.IOUtil;
import org.mmbase.util.LocaleCollator;
import org.mmbase.util.SerializableInputStream;
import org.mmbase.util.SortedBundle;
import org.mmbase.util.StringBufferWriter;
import org.mmbase.util.StringBuilderWriter;
import org.mmbase.util.StringSplitter;
import org.mmbase.util.dateparser.ParseException;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.transformers.CharTransformer;
import org.mmbase.util.xml.EntityResolver;
import org.mmbase.util.xml.ErrorHandler;
import org.mmbase.util.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Casting {
    private static final Logger log = Logging.getLoggerInstance(Casting.class);
    public static final ThreadLocal<DateFormat> ISO_8601_LOOSE = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        }
    };
    public static final ThreadLocal<DateFormat> ISO_8601_UTC = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
            try {
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            catch (Throwable t) {
                log.warn(t.getMessage(), t);
            }
            return df;
        }
    };
    public static final ThreadLocal<DateFormat> ISO_8601_DATE = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd", Locale.US);
        }
    };
    public static final ThreadLocal<DateFormat> ISO_8601_TIME = new ThreadLocal<DateFormat>(){

        @Override
        protected synchronized DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss", Locale.US);
        }
    };
    private static Caster helper = new BasicCaster();
    static DocumentBuilder DOCUMENTBUILDER;
    public static final Pattern BOOLEAN_PATTERN;
    public static final Pattern DOUBLE_PATTERN;

    public static boolean isType(Class type, Object value) {
        if (type.isPrimitive()) {
            return type.equals(Boolean.TYPE) && value instanceof Boolean || type.equals(Byte.TYPE) && value instanceof Byte || type.equals(Character.TYPE) && value instanceof Character || type.equals(Short.TYPE) && value instanceof Short || type.equals(Integer.TYPE) && value instanceof Integer || type.equals(Long.TYPE) && value instanceof Long || type.equals(Float.TYPE) && value instanceof Float || type.equals(Double.TYPE) && value instanceof Double;
        }
        return value == null || type.isInstance(value);
    }

    public static <C> C toType(Class<C> type, Object value) {
        return Casting.toType(type, null, value);
    }

    public static <C> C toType(Class<C> type, Object cloud, Object value) {
        if (value != null && Casting.isType(type, value)) {
            return (C)value;
        }
        try {
            return helper.toType(type, cloud, value);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return (C)Boolean.valueOf(Casting.toBoolean(value));
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return (C)Byte.valueOf(Casting.toInteger(value).byteValue());
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                String chars = Casting.toString(value);
                if (chars.length() > 0) {
                    return (C)Character.valueOf(chars.charAt(0));
                }
                return (C)Character.valueOf('\u0000');
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return (C)Short.valueOf(Casting.toInteger(value).shortValue());
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return (C)Casting.toInteger(value);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return (C)Long.valueOf(Casting.toLong(value));
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return (C)Float.valueOf(Casting.toFloat(value));
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return (C)Double.valueOf(Casting.toDouble(value));
            }
            if (type.equals(Number.class)) {
                Number res;
                try {
                    res = Long.valueOf("" + value);
                }
                catch (NumberFormatException nfe) {
                    try {
                        res = Double.valueOf("" + value);
                    }
                    catch (NumberFormatException nfe1) {
                        res = -1;
                    }
                }
                return (C)res;
            }
            if (type.equals(byte[].class)) {
                return (C)Casting.toByte(value);
            }
            if (type.equals(SerializableInputStream.class)) {
                return (C)Casting.toSerializableInputStream(value);
            }
            if (type.equals(String.class)) {
                return (C)Casting.toString(value);
            }
            if (type.equals(CharSequence.class)) {
                return (C)Casting.toString(value);
            }
            if (type.equals(Date.class)) {
                return (C)Casting.toDate(value);
            }
            if (type.equals(Document.class)) {
                return (C)Casting.toXML(value);
            }
            if (type.equals(List.class)) {
                return (C)Casting.toList(value);
            }
            if (type.equals(Map.class)) {
                return (C)Casting.toMap(value);
            }
            if (type.equals(Collection.class)) {
                return (C)Casting.toCollection(value);
            }
            if (type.equals(BigDecimal.class)) {
                return (C)Casting.toDecimal(value);
            }
            if (type.equals(Pattern.class)) {
                if (Pattern.class.isInstance(value)) {
                    return (C)value;
                }
                return (C)Pattern.compile(Casting.toString(value));
            }
            if (type.equals(Class.class)) {
                if (Class.class.isInstance(value)) {
                    return (C)value;
                }
                try {
                    return (C)Class.forName(Casting.toString(value));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (type.equals(Locale.class)) {
                if (value instanceof Locale) {
                    return (C)value;
                }
                return (C)new Locale(Casting.toString(value));
            }
            if (type.equals(TimeZone.class)) {
                if (value == null || "".equals(value)) {
                    return null;
                }
                if (value instanceof TimeZone) {
                    return (C)value;
                }
                return (C)TimeZone.getTimeZone(Casting.toString(value));
            }
            if (type.equals(Collator.class)) {
                if (value instanceof Collator) {
                    return (C)value;
                }
                return (C)LocaleCollator.getInstance(Casting.toString(value));
            }
            log.error("Don't know how to convert to " + type, new Exception());
            if (value == null || "".equals(value)) {
                return null;
            }
            return (C)value;
        }
    }

    public static boolean canCast(Class<?> from, Class<?> to) {
        return Casting.isStringRepresentable(from) && Casting.isStringRepresentable(to);
    }

    public static boolean isStringRepresentable(Class<?> type) {
        return helper.isStringRepresentable(type) || CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Document.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
    }

    public static String toString(Object o) {
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null || "".equals(o)) {
            return "";
        }
        return Casting.toStringBuilder(new StringBuilder(), o).toString();
    }

    public static StringBuffer toStringBuffer(StringBuffer buffer, Object o) {
        if (o == null) {
            return buffer;
        }
        try {
            Casting.toWriter(new StringBufferWriter(buffer), o);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer;
    }

    public static StringBuilder toStringBuilder(StringBuilder buffer, Object o) {
        if (o == null) {
            return buffer;
        }
        try {
            Casting.toWriter(new StringBuilderWriter(buffer), o);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer;
    }

    public static Writer toWriter(Writer writer, Object o) throws IOException {
        if (o instanceof Writer) {
            return writer;
        }
        if (o instanceof SortedBundle.ValueWrapper) {
            o = ((SortedBundle.ValueWrapper)o).getKey();
        }
        Object s = Casting.wrap(o, null);
        try {
            s = helper.toString(s);
        }
        catch (Caster.NotRecognized notRecognized) {
            // empty catch block
        }
        writer.write(s.toString());
        return writer;
    }

    public static Object wrap(Object o, CharTransformer escaper) {
        if (o == null) {
            return Casting.escape(escaper, "");
        }
        try {
            return helper.wrap(o, escaper);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (o instanceof Unwrappable) {
                return o;
            }
            if (o instanceof Date) {
                return new Date(((Date)o).getTime()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public String toString() {
                        long time = this.getTime();
                        return time == -1L ? "-1" : "" + time / 1000L;
                    }
                };
            }
            if (o instanceof Node) {
                return Casting.escape(escaper, XMLWriter.write((Node)o, false, true));
            }
            if (o instanceof List) {
                return new ListWrapper((List)o, escaper);
            }
            if (o instanceof byte[]) {
                return Casting.escape(escaper, new String((byte[])o));
            }
            if (o instanceof Object[]) {
                return new ListWrapper(Arrays.asList((Object[])o), escaper);
            }
            if (o instanceof String) {
                return Casting.escape(escaper, (String)o);
            }
            if (o instanceof CharSequence) {
                return new StringWrapper((CharSequence)o, escaper);
            }
            if (o instanceof InputStream) {
                try {
                    return new StringSerializableInputStream(Casting.toSerializableInputStream(o), escaper);
                }
                catch (IOException ioe) {
                    return ioe.getMessage();
                }
            }
            return o;
        }
    }

    public static String escape(CharTransformer escaper, CharSequence string) {
        if (escaper != null) {
            return escaper.transform(string == null ? "" : string.toString());
        }
        return string == null ? "" : string.toString();
    }

    public static Object unWrap(Object o) {
        try {
            return helper.unWrap(o);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (o instanceof ListWrapper) {
                return ((ListWrapper)o).getList();
            }
            if (o instanceof StringWrapper) {
                return ((StringWrapper)o).getString();
            }
            return o;
        }
    }

    public static List toList(Object o) {
        return Casting.toList(o, ",");
    }

    public static List toList(Object o, String delimiter) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Collection) {
            return new ArrayList((Collection)o);
        }
        if (o instanceof String) {
            if ("".equals(delimiter) || delimiter == null) {
                delimiter = ",";
            }
            return StringSplitter.split((String)o, delimiter);
        }
        if (o instanceof Map) {
            return new ArrayList(((Map)o).entrySet());
        }
        if (o == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(o);
    }

    public static Map toMap(Object o) {
        if (o == null) {
            return new HashMap();
        }
        try {
            return helper.toMap(o);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o instanceof Collection) {
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                for (Object o1 : (Collection)o) {
                    Object n = o1;
                    if (n instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)n;
                        result.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    result.put(n, n);
                }
                return result;
            }
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            m.put(o, o);
            return m;
        }
    }

    public static Collection toCollection(Object o, String delimiter) {
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet();
        }
        if (o instanceof String) {
            if ("".equals(delimiter) || delimiter == null) {
                delimiter = ",";
            }
            return StringSplitter.split((String)o, delimiter);
        }
        if (o instanceof Object[]) {
            return Arrays.asList((Object[])o);
        }
        if (o == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(o);
    }

    public static Collection toCollection(Object o) {
        return Casting.toCollection(o, ",");
    }

    public static Document toXML(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Document)) {
            String xmltext = Casting.toString(o);
            if (log.isDebugEnabled()) {
                String msg = xmltext;
                if (msg.length() > 84) {
                    msg = msg.substring(0, 80) + "...";
                }
                log.debug("Object '" + msg + "' is not a Document, but a " + o.getClass().getName() + "");
            }
            return Casting.convertStringToXML(xmltext);
        }
        return (Document)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByte(Object obj) {
        if (obj == null) {
            log.debug("Converted null to empty byte array", new Exception());
            return new byte[0];
        }
        if (obj instanceof byte[]) {
            if (log.isDebugEnabled()) {
                log.debug("Already byte array " + obj + " l:" + ((byte[])obj).length, new Exception());
            }
            return (byte[])obj;
        }
        if (obj instanceof FileItem) {
            return ((FileItem)obj).get();
        }
        if (obj instanceof SerializableInputStream) {
            try {
                SerializableInputStream is = (SerializableInputStream)obj;
                return is.get();
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), ioe);
                return new byte[0];
            }
        }
        if (obj instanceof InputStream) {
            log.debug("IS " + obj);
            InputStream in = (InputStream)obj;
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            try {
                IOUtil.copy(in, out);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), ioe);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            return out.toByteArray();
        }
        log.debug("S " + obj.getClass() + " " + obj, new Exception());
        return Casting.toString(obj).getBytes();
    }

    public static InputStream toInputStream(Object obj) {
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        return Casting.toSerializableInputStream(obj);
    }

    public static SerializableInputStream toSerializableInputStream(Object obj) {
        if (obj instanceof SerializableInputStream) {
            return (SerializableInputStream)obj;
        }
        if (obj instanceof byte[]) {
            return new SerializableInputStream((byte[])obj);
        }
        if (obj instanceof FileItem) {
            try {
                return new SerializableInputStream((FileItem)obj);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), ioe);
                return new SerializableInputStream(new byte[0]);
            }
        }
        return new SerializableInputStream(Casting.toByte(obj));
    }

    public static int toInt(Object i, int def) {
        int res = def;
        if (i == null) {
            return def;
        }
        try {
            return helper.toInt(i);
        }
        catch (Caster.NotRecognized notRecognized) {
            block20: {
                if (i instanceof Number) {
                    long l = ((Number)i).longValue();
                    res = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (l < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)l);
                } else if (i instanceof Boolean) {
                    res = (Boolean)i != false ? 1 : 0;
                } else if (i instanceof Date) {
                    long timeValue = ((Date)i).getTime();
                    if (timeValue != -1L) {
                        timeValue /= 1000L;
                    }
                    res = timeValue > Integer.MAX_VALUE ? Integer.MAX_VALUE : (timeValue < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)timeValue);
                } else if (i instanceof Object[]) {
                    Object[] array = (Object[])i;
                    if (array.length == 0) {
                        return 0;
                    }
                    if (array.length >= 1) {
                        return Casting.toInt(array[0], def);
                    }
                } else if (i != null) {
                    try {
                        res = Integer.parseInt("" + i);
                    }
                    catch (NumberFormatException e) {
                        try {
                            res = Casting.toInt(Double.valueOf("" + i), def);
                        }
                        catch (NumberFormatException ex) {
                            if (!(i instanceof String)) break block20;
                            String s = ((String)i).toLowerCase();
                            if ("true".equals(s) || "yes".equals(s)) {
                                res = 1;
                                break block20;
                            }
                            if (!"false".equals(s) && !"no".equals(s)) break block20;
                            res = 0;
                        }
                    }
                }
            }
            return res;
        }
    }

    public static int toInt(Object i) {
        return Casting.toInt(i, -1);
    }

    public static boolean toBoolean(Object b) {
        if (b == null) {
            return false;
        }
        try {
            return helper.toBoolean(b);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (b instanceof Boolean) {
                return (Boolean)b;
            }
            if (b instanceof Number) {
                return ((Number)b).doubleValue() > 0.0;
            }
            if (b instanceof Date) {
                return ((Date)b).getTime() != -1L;
            }
            if (b instanceof Document) {
                return false;
            }
            if (b instanceof String) {
                String s = ((String)b).toLowerCase();
                return "true".equals(s) || "yes".equals(s) || "1".equals(s);
            }
            return false;
        }
    }

    public static Integer toInteger(Object i) {
        if (i instanceof Integer) {
            return (Integer)i;
        }
        return Casting.toInt(i);
    }

    public static long toLong(Object i, long def) {
        long res = def;
        try {
            return helper.toLong(i);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (i instanceof Boolean) {
                res = (Boolean)i != false ? 1L : 0L;
            } else if (i instanceof Number) {
                res = ((Number)i).longValue();
            } else if (i instanceof Date) {
                res = ((Date)i).getTime();
                if (res != -1L) {
                    res /= 1000L;
                }
            } else if (i instanceof Object[]) {
                Object[] array = (Object[])i;
                if (array.length == 0) {
                    return 0L;
                }
                if (array.length >= 1) {
                    return Casting.toLong(array[0], def);
                }
            } else if (i != null) {
                if (i instanceof String) {
                    String s = ((String)i).toLowerCase();
                    if ("true".equals(s) || "yes".equals(s)) {
                        return 1L;
                    }
                    if ("false".equals(s) || "no".equals(s)) {
                        return 0L;
                    }
                }
                try {
                    res = Long.parseLong("" + i);
                }
                catch (NumberFormatException e) {
                    try {
                        res = Double.valueOf("" + i).longValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return res;
        }
    }

    public static long toLong(Object i) {
        return Casting.toLong(i, -1L);
    }

    public static float toFloat(Object i, float def) {
        float res = def;
        try {
            return helper.toFloat(i);
        }
        catch (Caster.NotRecognized notRecognized) {
            if (i instanceof Boolean) {
                res = (Boolean)i != false ? 1.0f : 0.0f;
            } else if (i instanceof Number) {
                res = ((Number)i).floatValue();
            } else if (i instanceof Date) {
                res = ((Date)i).getTime();
                if (res != -1.0f) {
                    res /= 1000.0f;
                }
            } else if (i != null) {
                if (i instanceof String) {
                    String s = ((String)i).toLowerCase();
                    if ("true".equals(s) || "yes".equals(s)) {
                        res = 1.0f;
                    } else if ("false".equals(s) || "no".equals(s)) {
                        res = 0.0f;
                    }
                }
                try {
                    res = Float.parseFloat("" + i);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return res;
        }
    }

    public static float toFloat(Object i) {
        return Casting.toFloat(i, -1.0f);
    }

    public static double toDouble(Object i, double def) {
        double res = def;
        try {
            return helper.toFloat(i);
        }
        catch (Caster.NotRecognized notRecognized) {
            block17: {
                if (i instanceof Boolean) {
                    res = (Boolean)i != false ? 1.0 : 0.0;
                } else if (i instanceof Number) {
                    res = ((Number)i).doubleValue();
                } else if (i instanceof Date) {
                    res = ((Date)i).getTime();
                    if (res != -1.0) {
                        res /= 1000.0;
                    }
                } else if (i instanceof Object[]) {
                    Object[] array = (Object[])i;
                    if (array.length == 0) {
                        return 0.0;
                    }
                    if (array.length >= 1) {
                        return Casting.toDouble(array[0], def);
                    }
                } else if (i != null) {
                    try {
                        res = Double.parseDouble("" + i);
                    }
                    catch (NumberFormatException e) {
                        if (!(i instanceof String)) break block17;
                        String s = ((String)i).toLowerCase();
                        if ("true".equals(s) || "yes".equals(s)) {
                            res = 1.0;
                            break block17;
                        }
                        if (!"false".equals(s) && !"no".equals(s)) break block17;
                        res = 0.0;
                    }
                }
            }
            return res;
        }
    }

    public static double toDouble(Object i) {
        return Casting.toDouble(i, -1.0);
    }

    public static BigDecimal toDecimal(Object i) {
        if (i instanceof BigDecimal) {
            return (BigDecimal)i;
        }
        if (i instanceof CharSequence) {
            try {
                return new BigDecimal("" + i).stripTrailingZeros();
            }
            catch (NumberFormatException nfe) {
                if (i instanceof String) {
                    String s = ((String)i).toLowerCase();
                    if ("true".equals(s) || "yes".equals(s)) {
                        return BigDecimal.ONE;
                    }
                    if ("false".equals(s) || "no".equals(s)) {
                        return BigDecimal.ZERO;
                    }
                }
                return BigDecimal.ONE.negate();
            }
        }
        if (i instanceof Long) {
            return new BigDecimal((Long)i);
        }
        if (i instanceof Integer) {
            return new BigDecimal((Integer)i);
        }
        if (i instanceof Double) {
            return new BigDecimal((Double)i);
        }
        if (i instanceof Float) {
            return new BigDecimal(((Float)i).floatValue());
        }
        return new BigDecimal(Casting.toDouble(i)).stripTrailingZeros();
    }

    public static Date toDate(Object d) {
        if (d == null) {
            return new Date(-1L);
        }
        Date date = null;
        if (d instanceof Date) {
            date = (Date)d;
        } else {
            try {
                long dateInSeconds = -1L;
                if (d instanceof Number) {
                    dateInSeconds = ((Number)d).longValue();
                } else if (d instanceof Document) {
                    dateInSeconds = -1L;
                } else if (d instanceof Boolean) {
                    dateInSeconds = -1L;
                } else if (d instanceof Collection) {
                    dateInSeconds = -1L;
                } else if (d != null) {
                    if ("".equals(d = Casting.toString(d))) {
                        return new Date(-1L);
                    }
                    dateInSeconds = Long.parseLong((String)d);
                } else {
                    dateInSeconds = -1L;
                }
                date = dateInSeconds == -1L ? new Date(-1L) : (dateInSeconds > 9223372036854775L ? new Date(Long.MAX_VALUE) : (dateInSeconds < -9223372036854775L ? new Date(Long.MIN_VALUE) : new Date(dateInSeconds * 1000L)));
            }
            catch (NumberFormatException e) {
                try {
                    date = DynamicDate.getInstance((String)d);
                }
                catch (ParseException pe) {
                    log.error("Parser exception in " + d, pe);
                    return new Date(-1L);
                }
                catch (Error per) {
                    throw new Error("Parser error in " + d, per);
                }
            }
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document convertStringToXML(String value) {
        if (value == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("using xml string:\n" + value);
        }
        try {
            Document doc;
            ErrorHandler errorHandler = new ErrorHandler(false, 4);
            assert (DOCUMENTBUILDER != null);
            DocumentBuilder documentBuilder = DOCUMENTBUILDER;
            synchronized (documentBuilder) {
                DOCUMENTBUILDER.setErrorHandler(errorHandler);
                doc = DOCUMENTBUILDER.parse(new ByteArrayInputStream(value.getBytes("UTF-8")));
            }
            if (log.isTraceEnabled()) {
                log.trace("parsed: " + XMLWriter.write((Node)doc, false, true));
            }
            if (!errorHandler.foundNothing()) {
                throw new IllegalArgumentException("xml invalid:\n" + errorHandler.getMessageBuffer() + "for xml:\n" + value);
            }
            return doc;
        }
        catch (SAXException se) {
            if (log.isDebugEnabled()) {
                log.debug("[sax] not well formed xml: " + se.toString() + "(" + se.getMessage() + ")", se);
            }
            return Casting.convertStringToXML("<p>" + Encode.encode("ESCAPE_XML", value) + "</p>");
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("[io] not well formed xml: " + ioe.getMessage(), ioe);
        }
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof Node) {
            return o2 instanceof Node && ((Node)o1).isEqualNode((Node)o2);
        }
        return o1.equals(o2);
    }

    public static void setHelper(Caster h) {
        helper = h;
        log.service("Casting helper: " + helper);
    }

    private Casting() {
    }

    static {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            dfactory.setValidating(false);
            dfactory.setNamespaceAware(true);
            DOCUMENTBUILDER = dfactory.newDocumentBuilder();
            DOCUMENTBUILDER.setEntityResolver(new EntityResolver(false));
        }
        catch (ParserConfigurationException pce) {
            log.error("[sax parser]: " + pce.toString(), pce);
        }
        catch (Exception e) {
            log.error(e);
        }
        assert (DOCUMENTBUILDER != null);
        BOOLEAN_PATTERN = Pattern.compile("\\A(1|0|true|false)\\z");
        String Digits = "(\\p{Digit}+)";
        String HexDigits = "(\\p{XDigit}+)";
        String Exp = "[eE][+-]?(\\p{Digit}+)";
        String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        DOUBLE_PATTERN = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");
    }

    public static interface Unwrappable {
    }

    static class StringSerializableInputStream
    extends SerializableInputStream
    implements Unwrappable {
        private static final long serialVersionUID = 2L;
        CharTransformer escaper;

        StringSerializableInputStream(SerializableInputStream is, CharTransformer e) throws IOException {
            super(is);
            this.escaper = e;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this._writeObject(out);
            out.writeObject(this.escaper);
        }

        private void readObject(ObjectInputStream oin) throws IOException, ClassNotFoundException {
            this._readObject(oin);
            this.escaper = (CharTransformer)oin.readObject();
        }

        @Override
        public String toString() {
            try {
                return Casting.escape(this.escaper, new String(this.get()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class StringWrapper
    implements CharSequence {
        private final CharTransformer escaper;
        private final CharSequence string;
        private String escaped = null;

        StringWrapper(CharSequence s, CharTransformer e) {
            this.escaper = e;
            this.string = s;
        }

        @Override
        public char charAt(int index) {
            this.toString();
            return this.escaped.charAt(index);
        }

        @Override
        public int length() {
            this.toString();
            return this.escaped.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            this.toString();
            return this.escaped.subSequence(start, end);
        }

        @Override
        public String toString() {
            if (this.escaped == null) {
                this.escaped = Casting.escape(this.escaper, this.string);
            }
            return this.escaped;
        }

        public CharSequence getString() {
            return this.string;
        }
    }

    public static class ListWrapper
    extends AbstractList {
        private final List list;
        private final CharTransformer escaper;

        ListWrapper(List l, CharTransformer e) {
            this.list = l;
            this.escaper = e;
        }

        @Override
        public Object get(int index) {
            return Casting.wrap(this.list.get(index), this.escaper);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Object set(int index, Object value) {
            return this.list.set(index, value);
        }

        @Override
        public void add(int index, Object value) {
            this.list.add(index, value);
        }

        @Override
        public Object remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.list.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.list.toArray(a);
        }

        @Override
        public Iterator iterator() {
            return this.list.iterator();
        }

        @Override
        public ListIterator listIterator() {
            return this.list.listIterator();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            Iterator i = this.list.iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Casting.toStringBuilder(buf, i.next());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(',');
            }
            return buf.toString();
        }

        public List getList() {
            return this.list;
        }
    }
}

