/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BijectiveMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, V> backing;
    private final Map<V, K> inverse;

    public BijectiveMap() {
        this.backing = new HashMap();
        this.inverse = new HashMap<V, K>();
    }

    private BijectiveMap(Map<K, V> backing, Map<V, K> inverse) {
        this.backing = backing;
        this.inverse = inverse;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return BijectiveMap.this.backing.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> i;
                    private Map.Entry<K, V> entry;
                    {
                        this.i = BijectiveMap.this.backing.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.entry = this.i.next();
                        return this.entry;
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                        BijectiveMap.this.inverse.remove(this.entry.getValue());
                    }
                };
            }
        };
    }

    @Override
    public V put(K key, V value) {
        if (this.backing.containsKey(key)) {
            V prevValue = this.backing.get(key);
            if (!prevValue.equals(value)) {
                if (this.inverse.containsKey(value)) {
                    throw new IllegalArgumentException();
                }
                this.inverse.remove(prevValue);
                this.inverse.put(value, key);
                this.backing.put(key, value);
            }
            return prevValue;
        }
        if (this.inverse.containsKey(value)) {
            throw new IllegalArgumentException("Cannot put " + key + "->" + value + " Because the value already exists " + this.inverse);
        }
        this.backing.put(key, value);
        this.inverse.put(value, key);
        return null;
    }

    public K inverseGet(V value) {
        return this.inverse.get(value);
    }

    public BijectiveMap<V, K> getInverse() {
        return new BijectiveMap<V, K>(this.inverse, this.backing);
    }
}

