/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.mmbase.util.FileWatcher;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class CharsetRemoverFilter
implements Filter {
    private static final Logger log = Logging.getLoggerInstance(CharsetRemoverFilter.class);
    Properties contentTypes = new Properties();
    FileWatcher watcher = new FileWatcher(true){

        @Override
        public void onChange(File file) {
            CharsetRemoverFilter.this.load(file);
        }
    };

    public void init(FilterConfig filterConfig) throws ServletException {
        File file = new File(filterConfig.getServletContext().getRealPath("WEB-INF/config/charsetremover.properties"));
        log.info("Init of CharsetRemover Filter, using " + file);
        this.load(file);
        this.watcher.add(file);
        this.watcher.setDelay(10000L);
        this.watcher.start();
    }

    public void load(File file) {
        log.info("Reading " + file);
        this.contentTypes.clear();
        if (file.canRead()) {
            try {
                this.contentTypes.load(new FileInputStream(file));
            }
            catch (IOException ioe) {
                log.error(ioe);
            }
        } else {
            log.warn("This file does not exist, using defaults");
            this.contentTypes.put("audio/x-pn-realaudio", "ISO-8859-1");
            this.contentTypes.put("text/vnd.rn-realtext", "ISO-8859-1");
            this.contentTypes.put("audio/x-pn-realaudio-plugin", "ISO-8859-1");
            this.contentTypes.put("image/vnd.rn-realpix", "ISO-8859-1");
            this.contentTypes.put("application/smil", "ISO-8859-1");
        }
        log.info("The following content-types will have no charset on the content-type: " + this.contentTypes);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponseWrapper wrapper = new HttpServletResponseWrapper((HttpServletResponse)servletResponse){
            private String contentType;
            private PrintWriter writer;
            {
                this.writer = null;
            }

            public void setContentType(String ct) {
                this.contentType = ct;
                if (log.isDebugEnabled()) {
                    log.trace("Setting contentType to " + ct + " " + Logging.stackTrace(new Exception()));
                }
                this.getResponse().setContentType(ct);
            }

            public String getContentType() {
                return this.contentType;
            }

            public PrintWriter getWriter() throws IOException {
                if (this.writer == null) {
                    String charSet;
                    String string = charSet = this.contentType == null ? null : (String)CharsetRemoverFilter.this.contentTypes.get(this.contentType);
                    if (charSet != null) {
                        if (this.contentType != null) {
                            super.setContentType(this.contentType);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Wrapping outputstream to avoid charset " + charSet);
                        }
                        try {
                            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), charSet), false){

                                @Override
                                public void write(String s, int off, int len) {
                                    super.write(s, off, len);
                                    this.flush();
                                }
                            };
                        }
                        catch (UnsupportedEncodingException uee) {
                            log.error(uee);
                            this.writer = super.getWriter();
                        }
                    } else {
                        if (this.contentType != null) {
                            super.setContentType(this.contentType);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug(" " + this.contentType + " is not contained by " + CharsetRemoverFilter.this.contentTypes);
                        }
                        this.writer = super.getWriter();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Returning " + this.writer.getClass());
                }
                return this.writer;
            }
        };
        filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
    }

    public void destroy() {
    }
}

