/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.mmbase.util.MMBaseContext;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class CharacterEncodingFilter
implements Filter {
    private static final Logger LOG = Logging.getLoggerInstance(CharacterEncodingFilter.class);
    private String encoding = null;

    public void init(FilterConfig config) throws ServletException {
        LOG.info("CharacterEncodingFilter init");
        this.encoding = config.getInitParameter("encoding");
        if (this.encoding == null) {
            this.encoding = MMBaseContext.getEncoding();
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
        }
    }

    public void destroy() {
        LOG.info("CharacterEncodingFilter destroy");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            try {
                if (req.getCharacterEncoding() == null) {
                    req.setCharacterEncoding(this.encoding);
                }
            }
            catch (Exception e) {
                LOG.warn("Error setting encoding : " + e.getMessage());
            }
        }
        chain.doFilter(request, response);
    }
}

