/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.core.event;

import java.io.File;
import javax.sql.DataSource;
import org.mmbase.core.event.Event;
import org.mmbase.core.event.EventManager;
import org.mmbase.core.event.SystemEventListener;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public abstract class SystemEvent
extends Event {
    private static final Logger LOG = Logging.getLoggerInstance(SystemEvent.class);

    static {
        SystemEventListener logger = new SystemEventListener(){

            @Override
            public void notify(SystemEvent s) {
                LOG.service(" Received " + s);
            }

            @Override
            public int getWeight() {
                return 50000;
            }

            public String toString() {
                return "SystemEventLogger";
            }
        };
        EventManager.getInstance().addEventListener(logger);
    }

    public static class MachineName
    extends Collectable {
        private final String name;

        public MachineName(String n) {
            this.name = n;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Shutdown
    extends Collectable {
    }

    public static class ServletContext
    extends Collectable {
        private final javax.servlet.ServletContext servletContext;

        public ServletContext(javax.servlet.ServletContext sc) {
            this.servletContext = sc;
        }

        public javax.servlet.ServletContext getServletContext() {
            return this.servletContext;
        }
    }

    public static class DataSourceAvailable
    extends Collectable {
        private final DataSource dataSource;
        private final String prefix;

        public DataSourceAvailable(DataSource ds, String pref) {
            this.dataSource = ds;
            this.prefix = pref;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String toString() {
            return this.dataSource + " p:" + this.prefix;
        }
    }

    public static class ResourceLoaderChange
    extends Collectable {
    }

    public static class Up
    extends Collectable {
        private final String databaseName;
        private final File dataDir;

        public Up(String databaseName, File dataDir) {
            this.databaseName = databaseName;
            this.dataDir = dataDir;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public File getDataDir() {
            return this.dataDir;
        }
    }

    public static abstract class Collectable
    extends SystemEvent {
    }
}

