/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.core.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.mmbase.core.event.EventBroker;
import org.mmbase.core.event.EventListener;
import org.mmbase.core.event.WeightEventListener;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public abstract class AbstractEventBroker
extends EventBroker {
    private static final Logger log = Logging.getLoggerInstance(AbstractEventBroker.class);
    private List<EventListener> listeners = Collections.unmodifiableList(new ArrayList());
    private static final Comparator<EventListener> COMPARATOR = new Comparator<EventListener>(){

        @Override
        public int compare(EventListener e1, EventListener e2) {
            try {
                long diff;
                if (e1 instanceof WeightEventListener && e2 instanceof WeightEventListener && (diff = (long)((WeightEventListener)e2).getWeight() - (long)((WeightEventListener)e1).getWeight()) != 0L) {
                    return diff > 0L ? 1 : -1;
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            return e1 == null ? (e2 == null ? 0 : 1) : e1.getClass().getName().compareTo(e2.getClass().getName());
        }
    };

    @Override
    protected Collection<EventListener> backing() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(EventListener listener) {
        if (this.canBrokerForListener(listener)) {
            Comparator<EventListener> comparator = COMPARATOR;
            synchronized (comparator) {
                if (this.listeners.contains(listener)) {
                    if (log.isDebugEnabled()) {
                        log.debug("" + listener + " was already in " + this.getClass() + ". Ignored.");
                    }
                    return false;
                }
                ArrayList<EventListener> newList = new ArrayList<EventListener>(this.listeners.size() + 1);
                newList.addAll(this.listeners);
                newList.add(listener);
                Collections.sort(newList, COMPARATOR);
                this.listeners = Collections.unmodifiableList(newList);
                log.debug("listener added to " + this.getClass());
                return true;
            }
        }
        log.warn("Ignored listener for" + this.getClass() + " because it cannot broker for that.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EventListener listener) {
        Comparator<EventListener> comparator = COMPARATOR;
        synchronized (comparator) {
            ArrayList<EventListener> newList = new ArrayList<EventListener>(this.listeners.size());
            newList.addAll(this.listeners);
            if (!newList.remove(listener)) {
                log.warn("Tried to remove " + listener + " from " + this.getClass() + " but it was not found. Ignored.");
            }
            this.listeners = Collections.unmodifiableList(newList);
        }
    }
}

