/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache.xslt;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mmbase.cache.Cache;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResultCache
extends Cache<String, String> {
    private static Logger log = Logging.getLoggerInstance(ResultCache.class);
    private static ResultCache cache;

    @Override
    protected int getDefaultMaxEntrySize() {
        return 1500;
    }

    public static ResultCache getCache() {
        return cache;
    }

    @Override
    public String getName() {
        return "XSLTResults";
    }

    @Override
    public String getDescription() {
        return "XSL Transformation Results";
    }

    private ResultCache(int size) {
        super(size);
    }

    @Override
    public String put(Object key, Templates value) {
        throw new RuntimeException("wrong types in cache");
    }

    private StringBuilder append(StringBuilder buf, Node node) {
        switch (node.getNodeType()) {
            case 2: {
                buf.append(node.getNodeName()).append(node.getNodeValue());
                break;
            }
            case 1: {
                NodeList nl = node.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    this.append(buf, nl.item(i));
                }
            }
            case 5: 
            case 6: {
                buf.append(node.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                buf.append(node.getNodeValue().hashCode());
                break;
            }
            default: {
                log.debug("Unknown nodetype " + node.getNodeType());
            }
        }
        return buf;
    }

    private String getKey(Source xsl, Map params, Properties props, Document src) {
        StringBuilder key = new StringBuilder(xsl.getSystemId());
        key.append('/');
        if (params != null) {
            key.append(params.toString());
        }
        key.append('/');
        if (props != null) {
            key.append(props.toString());
        }
        key.append('/');
        return this.append(key, src.getDocumentElement()).toString();
    }

    public String get(Templates temp, Source xsl, Map params, Properties props, Document src) {
        String key = null;
        String result = null;
        if (this.isActive()) {
            key = this.getKey(xsl, params, props, src);
            if (log.isDebugEnabled()) {
                log.debug("Getting result of XSL transformation: " + key);
            }
            result = (String)this.get(key);
        }
        if (result == null) {
            try {
                Transformer transformer = temp.newTransformer();
                if (params != null) {
                    Iterator iterator = params.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o;
                        Map.Entry entry = o = iterator.next();
                        transformer.setParameter((String)entry.getKey(), entry.getValue());
                    }
                }
                if (props != null) {
                    transformer.setOutputProperties(props);
                }
                StringWriter res = new StringWriter();
                transformer.transform(new DOMSource(src), new StreamResult(res));
                result = res.toString();
            }
            catch (TransformerException e) {
                result = e.toString();
            }
            if (this.isActive()) {
                if (result.length() < this.getMaxEntrySize()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Put xslt Result in cache with key " + key);
                    }
                    super.put(key, result);
                } else if (log.isDebugEnabled()) {
                    log.debug("xslt Result of key " + key.substring(100) + " is too big to put in cache. " + result.length() + " >= " + this.getMaxEntrySize());
                }
            }
        }
        return result;
    }

    static {
        int cacheSize = 50;
        cache = new ResultCache(cacheSize);
        cache.putCache();
    }
}

