/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache.implementation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mmbase.cache.CacheImplementationInterface;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;

public class LRUCache<K, V>
implements CacheImplementationInterface<K, V> {
    private static final Logger log = Logging.getLoggerInstance(LRUCache.class);
    private int maxSize;
    private final Map<K, V> backing;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int size) {
        this.maxSize = size;
        this.backing = Collections.synchronizedMap(new LinkedHashMap<K, V>(size, 0.75f, true){
            private static final long serialVersionUID = 0L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                int overSized = this.size() - LRUCache.this.maxSize;
                if (overSized <= 0) {
                    return false;
                }
                if (overSized == 1) {
                    Iterator i = this.keySet().iterator();
                    Object actualEldest = i.next();
                    i.remove();
                    overSized = this.size() - LRUCache.this.maxSize;
                    while (overSized > 0) {
                        log.warn("cache didn't shrink (a)" + eldest.getKey() + " [" + eldest.getKey().getClass() + "] [" + eldest.getKey().hashCode() + "]");
                        log.warn("cache didn't shrink (b)" + actualEldest + " [" + actualEldest.getClass() + "] [" + actualEldest.hashCode() + "]");
                        actualEldest = i.next();
                        i.remove();
                        overSized = this.size() - LRUCache.this.maxSize;
                    }
                    assert (overSized <= 0);
                    return false;
                }
                log.warn("How is this possible? Oversized: " + overSized);
                log.debug("because", new Exception());
                if (overSized > 10) {
                    log.error("For some reason this cache grew much too big (" + this.size() + " >> " + LRUCache.this.maxSize + "). This must be some kind of bug. Resizing now.");
                    this.clear();
                }
                return false;
            }
        });
    }

    @Override
    public int getCount(K key) {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Cannot set size to negative value " + size);
        }
        this.maxSize = size;
        Map<K, V> map = this.backing;
        synchronized (map) {
            while (this.size() > this.maxSize) {
                try {
                    Iterator<K> i = this.keySet().iterator();
                    i.next();
                    i.remove();
                }
                catch (Exception e) {
                    log.warn(e);
                }
            }
        }
    }

    @Override
    public final int maxSize() {
        return this.maxSize;
    }

    public String toString() {
        return "Size=" + this.size() + ", Max=" + this.maxSize;
    }

    @Override
    public void config(Map<String, String> map) {
    }

    @Override
    public Object getLock() {
        return this.backing;
    }

    @Override
    public int size() {
        return this.backing.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backing.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backing.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backing.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.backing.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.backing.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.backing.putAll(map);
    }

    @Override
    public void clear() {
        this.backing.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.backing.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backing.entrySet();
    }

    @Override
    public Collection<V> values() {
        return this.backing.values();
    }
}

