/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class CachePolicy
implements Serializable {
    private static Map<Object, CachePolicy> policies = new HashMap<Object, CachePolicy>();
    public static final CachePolicy NEVER = new CachePolicy("never"){
        private static final long serialVersionUID = 0L;

        @Override
        public boolean checkPolicy(Object o) {
            return false;
        }

        @Override
        public String getDescription() {
            return "CACHE NEVER";
        }
    };
    public static final CachePolicy ALWAYS = new CachePolicy("always"){
        private static final long serialVersionUID = 0L;

        @Override
        public boolean checkPolicy(Object o) {
            return true;
        }

        @Override
        public String getDescription() {
            return "CACHE ALWAYS";
        }
    };

    public static CachePolicy getPolicy(Object policyKey) {
        CachePolicy policy = policies.get(policyKey);
        if (policy == null) {
            throw new IllegalArgumentException("There is no cache policy known with key '" + policyKey + "'");
        }
        return policy;
    }

    public static void putPolicy(Object policyKey, CachePolicy policy) {
        policies.put(policyKey, policy);
    }

    protected CachePolicy(Object policyKey) {
        CachePolicy.putPolicy(policyKey, this);
    }

    protected CachePolicy() {
    }

    public abstract boolean checkPolicy(Object var1);

    public String getDescription() {
        return this.getClass().getName();
    }
}

