/*
 * Decompiled with CFR 0.152.
 */
package org.mmbase.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mmbase.cache.CacheImplementationInterface;
import org.mmbase.cache.CacheMBean;
import org.mmbase.cache.CacheManager;
import org.mmbase.cache.CachePolicy;
import org.mmbase.cache.Cacheable;
import org.mmbase.cache.implementation.LRUCache;
import org.mmbase.util.HashCodeUtil;
import org.mmbase.util.SizeMeasurable;
import org.mmbase.util.SizeOf;
import org.mmbase.util.logging.Logger;
import org.mmbase.util.logging.Logging;
import org.mmbase.util.xml.DocumentReader;
import org.w3c.dom.Element;

public abstract class Cache<K, V>
implements SizeMeasurable,
Map<K, V>,
CacheMBean {
    private static final Logger log = Logging.getLoggerInstance(Cache.class);
    private boolean active = true;
    protected int maxEntrySize = -1;
    private CacheImplementationInterface<K, V> implementation;
    protected volatile Object lock;
    private long hits = 0L;
    private long misses = 0L;
    private long puts = 0L;

    public Cache(int size) {
        this.implementation = new LRUCache(size);
        this.lock = this.implementation.getLock();
        log.service("Creating cache " + this.getName() + ": " + this.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setImplementation(String clazz, Map<String, String> configValues) {
        Object object = this.lock;
        synchronized (object) {
            this.clear();
            try {
                Class<?> clas = Class.forName(clazz);
                if (this.implementation == null || !clas.equals(this.implementation.getClass())) {
                    log.info("Setting implementation of " + this + " to " + clas);
                    this.implementation = (CacheImplementationInterface)clas.newInstance();
                    this.implementation.config(configValues);
                    this.lock = this.implementation.getLock();
                }
            }
            catch (ClassNotFoundException cnfe) {
                log.error("For cache " + this + " " + cnfe.getClass().getName() + ": " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                log.error("For cache " + this + " " + ie.getClass().getName() + ": " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                log.error("For cache " + this + " " + iae.getClass().getName() + ": " + iae.getMessage());
            }
        }
    }

    public final Object getLock() {
        return this.lock;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return "An all purpose Cache";
    }

    @Override
    public int getMaxEntrySize() {
        if (this.getDefaultMaxEntrySize() > 0) {
            return this.maxEntrySize;
        }
        return -1;
    }

    @Override
    public void setMaxEntrySize(int i) {
        if (this.getDefaultMaxEntrySize() <= 0) {
            throw new UnsupportedOperationException();
        }
        this.maxEntrySize = i;
    }

    @Override
    public double getAverageValueLength() {
        return Double.NaN;
    }

    protected int getDefaultMaxEntrySize() {
        return -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (!this.active) {
            return new HashSet<Map.Entry<K, V>>();
        }
        return this.implementation.entrySet();
    }

    public Class<?> getImplementation() {
        return this.implementation.getClass();
    }

    protected boolean checkCachePolicy(Object key) {
        CachePolicy policy = null;
        if (this.active) {
            if (key instanceof Cacheable && (policy = ((Cacheable)key).getCachePolicy()) != null) {
                return policy.checkPolicy(key);
            }
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (!this.checkCachePolicy(key)) {
            return null;
        }
        Object res = this.implementation.get(key);
        if (res != null) {
            ++this.hits;
        } else {
            ++this.misses;
        }
        return res;
    }

    @Override
    public V put(K key, V value) {
        if (!this.checkCachePolicy(key)) {
            return null;
        }
        ++this.puts;
        return this.implementation.put(key, value);
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getMisses() {
        return this.misses;
    }

    @Override
    public long getPuts() {
        return this.puts;
    }

    @Override
    public void reset() {
        this.hits = 0L;
        this.misses = 0L;
        this.puts = 0L;
    }

    @Override
    public void setMaxSize(int size) {
        this.implementation.setMaxSize(size);
    }

    public int maxSize() {
        return this.implementation.maxSize();
    }

    @Override
    public int getMaxSize() {
        return this.maxSize();
    }

    @Override
    public int size() {
        return this.implementation.size();
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public boolean contains(Object key) {
        return this.implementation.containsKey(key);
    }

    public int getCount(K key) {
        return this.implementation.getCount(key);
    }

    @Override
    public double getRatio() {
        return (double)this.hits / (double)(this.hits + this.misses);
    }

    public String getStats() {
        return "Access " + (this.hits + this.misses) + " Ratio " + this.getRatio() + " Size " + this.size() + " Puts " + this.puts;
    }

    @Override
    public void setActive(boolean a) {
        this.active = a;
        if (!this.active) {
            this.implementation.clear();
        }
    }

    public String toString() {
        return "Cache " + this.getName() + ", Ratio: " + this.getRatio() + " " + this.implementation;
    }

    @Override
    public final boolean isActive() {
        return this.active;
    }

    @Override
    public int getByteSize() {
        return this.getByteSize(new SizeOf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByteSize(SizeOf sizeof) {
        int size = 26;
        if (this.implementation instanceof SizeMeasurable) {
            size += ((SizeMeasurable)((Object)this.implementation)).getByteSize(sizeof);
        } else {
            Object object = this.lock;
            synchronized (object) {
                for (Map.Entry entry : this.implementation.entrySet()) {
                    size += sizeof.sizeof(entry.getKey());
                    size += sizeof.sizeof(entry.getValue());
                }
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCheapByteSize() {
        int size = 0;
        SizeOf sizeof = new SizeOf();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry entry : this.implementation.entrySet()) {
                size += sizeof.sizeof(entry.getKey());
                size += sizeof.sizeof(entry.getValue());
                sizeof.clear();
            }
        }
        return size;
    }

    @Override
    public void clear() {
        this.implementation.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.implementation.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.implementation.containsValue(value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cache)) {
            return false;
        }
        Cache c = (Cache)o;
        if (!c.getName().equals(this.getName())) {
            return false;
        }
        return this.implementation.equals(o);
    }

    @Override
    public int hashCode() {
        int hash = this.getName().hashCode();
        hash = HashCodeUtil.hashCode(hash, this.implementation.hashCode());
        return hash;
    }

    @Override
    public boolean isEmpty() {
        return this.implementation.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.implementation.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        this.implementation.putAll(t);
    }

    @Override
    public V remove(Object key) {
        return this.implementation.remove(key);
    }

    @Override
    public Collection<V> values() {
        return this.implementation.values();
    }

    public Cache<K, V> putCache() {
        return CacheManager.putCache(this);
    }

    public void configure(Element cacheElement) {
        String clazz = DocumentReader.getElementValue(DocumentReader.getElementByPath(cacheElement, "cache.implementation.class"));
        if (!"".equals(clazz)) {
            Element cacheImpl = DocumentReader.getElementByPath(cacheElement, "cache.implementation");
            HashMap<String, String> configValues = new HashMap<String, String>();
            for (Element attrNode : DocumentReader.getChildElements(cacheImpl, "param")) {
                String paramName = attrNode.getAttribute("name");
                String paramValue = DocumentReader.getElementValue(attrNode);
                configValues.put(paramName, paramValue);
            }
            this.setImplementation(clazz, configValues);
        }
        String status = DocumentReader.getElementValue(DocumentReader.getElementByPath(cacheElement, "cache.status"));
        this.setActive(status.equalsIgnoreCase("active"));
        try {
            Integer size = Integer.valueOf(DocumentReader.getElementValue(DocumentReader.getElementByPath(cacheElement, "cache.size")));
            this.setMaxSize(size);
            log.service("Setting " + this.getName() + " " + status + " with size " + size);
        }
        catch (NumberFormatException nfe) {
            log.error("Could not configure cache " + this.getName() + " because the size was wrong: " + nfe.toString());
        }
        catch (Throwable t) {
            log.error(" " + this.getName() + " maxsize " + t.getMessage());
        }
        String maxSize = DocumentReader.getElementValue(DocumentReader.getElementByPath(cacheElement, "cache.maxEntrySize"));
        if (!"".equals(maxSize)) {
            try {
                this.maxEntrySize = Integer.parseInt(maxSize);
                log.service("Setting maximum entry size on " + this.getName() + ": " + this.maxEntrySize + " bytes ");
            }
            catch (NumberFormatException nfe2) {
                log.error("Could not set max entry size cache  of " + this.getName() + " because " + nfe2.toString());
            }
            catch (Throwable t) {
                log.error(" " + this.getName() + " maxentrysize " + t.getMessage());
            }
        } else {
            if (this.getDefaultMaxEntrySize() > 0) {
                log.service("No max entry size specified for this cache taking default " + this.getDefaultMaxEntrySize() + " bytes");
            }
            this.maxEntrySize = this.getDefaultMaxEntrySize();
        }
    }
}

