/* Generated By:JavaCC: Do not edit this line. DateParser.java */
package org.mmbase.util.dateparser;

import java.util.*;
import java.io.*;


public class DateParser implements DateParserConstants {

    private static Random random = new Random();
    public static TimeZone defaultTimeZone = TimeZone.getDefault();

    public static void setDefault(TimeZone tz) {
        defaultTimeZone = tz;
    }
    private boolean dynamic = true;
    private long prev = 0;
    private int amount = 0;
    private int factor = 1;
    private int field = 0;
    private int monthorday = -1;
    private int week = -1;
    private boolean positive = true;
    private Calendar cal = Calendar.getInstance(defaultTimeZone);
    {
        cal.setFirstDayOfWeek(Calendar.MONDAY); // ISO 8601
        cal.setMinimalDaysInFirstWeek(4);      // ISO 8601
    }

    public static void main(String argv[]) throws ParseException, InterruptedException {
        DateParser parser = new DateParser(new StringReader(argv[0]));
        parser.start();
        System.out.println("" + parser.toDate());
    }
    public Date toDate()  {
        return cal.getTime();
    }
    public boolean dynamic()  {
        return dynamic;
    }
    protected void beginOfMinute() {
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
    }
    protected void beginOfHour() {
        cal.set(Calendar.MINUTE, 0);
        beginOfMinute();
    }
    protected void beginOfDay() {
        cal.set(Calendar.HOUR_OF_DAY, 0);
        beginOfHour();
    }

    protected void beginOfWeek() {
        beginOfDay();
        cal.set(Calendar.DAY_OF_WEEK, cal.getFirstDayOfWeek());

    }

    protected void beginOfMonth() {
        cal.set(Calendar.DAY_OF_MONTH, 1);
        beginOfDay();
    }
    protected void beginOfYear() {
        cal.set(Calendar.MONTH, Calendar.JANUARY);
        beginOfMonth();
    }
    protected void beginOfCentury(boolean pedantic) {
        beginOfYear();
        int year = cal.get(Calendar.YEAR);
        year -= (year % 100);
        cal.set(Calendar.YEAR, year + (pedantic ? 1 : 0));
    }
    protected void beginOfEra() {
        beginOfYear();
        cal.set(Calendar.YEAR, cal.getActualMinimum(Calendar.YEAR));
    }

    protected Calendar getInstance() {
        Calendar c = Calendar.getInstance(cal.getTimeZone());
        c.setFirstDayOfWeek(Calendar.MONDAY); // as in ISO 8601
        return c;
    }

  final public void start() throws ParseException {
    if (jj_2_1(2)) {
      time_zone();
    } else {
      ;
    }
    if (jj_2_4(2)) {
      date();
      if (jj_2_3(2)) {
        if (jj_2_2(2)) {
          jj_consume_token(12);
        } else {
          ;
        }
        time();
      } else {
        ;
      }
    } else {
      ;
    }
    label_1:
    while (true) {
      if (jj_2_5(2)) {
        ;
      } else {
        break label_1;
      }
      if (jj_2_6(2)) {
        increment();
      } else if (jj_2_7(2)) {
        decrement();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    if (jj_2_8(2)) {
      time_zone();
    } else {
      ;
    }
    jj_consume_token(0);
  }

  final public void time() throws ParseException {
    if (jj_2_11(2)) {
      hour_number();
      jj_consume_token(13);
      minute_number();
      if (jj_2_10(2)) {
        jj_consume_token(13);
        second_number();
        if (jj_2_9(2)) {
          millisecond_number();
        } else {
          ;
        }
      } else {
        ;
      }
    } else if (jj_2_12(2)) {
      jj_consume_token(14);
                   beginOfHour(); cal.set(Calendar.HOUR_OF_DAY, 12);
    } else if (jj_2_13(2)) {
      jj_consume_token(15);
                   beginOfHour(); cal.set(Calendar.HOUR_OF_DAY, 0);
    } else if (jj_2_14(2)) {
      jj_consume_token(16);
                   beginOfHour(); cal.set(Calendar.HOUR_OF_DAY, 16);
    } else if (jj_2_15(2)) {
      hour_number();
      jj_consume_token(17);
                               cal.set(Calendar.MINUTE, 0);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void date() throws ParseException {
    if (jj_2_17(6)) {
      year_number();
      jj_consume_token(18);
      month_or_day_or_week_number();
      if (jj_2_16(2)) {
        jj_consume_token(18);
        day_of_month_or_week_number();
      } else {
        ;
      }
         if (monthorday > 0) cal.set(Calendar.DAY_OF_YEAR, monthorday);
         if (week >= 0) { cal.set(Calendar.WEEK_OF_YEAR, week); cal.set(Calendar.DAY_OF_WEEK, 2);  week = -1;}
         beginOfDay(); dynamic = false;
    } else if (jj_2_18(2)) {
      day_of_week();
                     beginOfDay();
    } else if (jj_2_19(2)) {
      month_of_year();
                       beginOfMonth();
    } else if (jj_2_20(2)) {
      jj_consume_token(19);
                   cal = getInstance();
    } else if (jj_2_21(2)) {
      seconds();

    } else if (jj_2_22(2)) {
      jj_consume_token(TO);
      to_period();

    } else if (jj_2_23(2)) {
      jj_consume_token(20);
                   cal = getInstance(); cal.add(Calendar.DAY_OF_YEAR, 1); beginOfDay();
    } else if (jj_2_24(2)) {
      jj_consume_token(21);
                    cal = getInstance(); cal.add(Calendar.DAY_OF_YEAR, -1); beginOfDay();
    } else if (jj_2_25(2)) {
      jj_consume_token(22);
                      cal = getInstance(); cal.add(Calendar.MONTH, -1); beginOfMonth();
    } else if (jj_2_26(2)) {
      jj_consume_token(23);
                     cal = getInstance(); cal.add(Calendar.YEAR, -1); beginOfYear();
    } else if (jj_2_27(2)) {
      jj_consume_token(24);
                   beginOfYear(); cal.setTimeZone(TimeZone.getTimeZone("UTC")); cal.set(Calendar.YEAR, 1970);
    } else if (jj_2_28(2)) {
      jj_consume_token(25);
                      beginOfHour(); cal.set(Calendar.HOUR_OF_DAY, 17); cal.set(Calendar.DAY_OF_WEEK, Calendar.FRIDAY);
                     if (Calendar.getInstance(cal.getTimeZone()).after(cal)) cal.add(Calendar.WEEK_OF_YEAR, 1);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void time_zone() throws ParseException {
    if (jj_2_29(2)) {
      jj_consume_token(TIMEZONE);
             cal.setTimeZone(TimeZone.getTimeZone(token.toString().substring(2).trim()));
    } else if (jj_2_30(2)) {
      jj_consume_token(26);
           cal.setTimeZone(TimeZone.getTimeZone("UTC"));
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void unary() throws ParseException {
    if (jj_2_31(2)) {
      jj_consume_token(18);
          positive = false;
    } else if (jj_2_32(2)) {
      jj_consume_token(27);
          positive = true;
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void integer() throws ParseException {
    if (jj_2_33(2)) {
      unary();
      jj_consume_token(POSITIVE);
    } else if (jj_2_34(2)) {
      jj_consume_token(POSITIVE);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void seconds() throws ParseException {
    integer();
                 cal.setTimeInMillis((positive ? 1 : -1 ) * Long.parseLong(token.toString()) * 1000); dynamic = false; positive = true;
  }

  final public void year_number() throws ParseException {
    integer();
                  cal.set(Calendar.YEAR, (positive ? 1 : -1) * Integer.parseInt(token.toString())); positive = true;
  }

  final public void week_number() throws ParseException {
    jj_consume_token(POSITIVE);
                   cal.set(Calendar.WEEK_OF_YEAR, Integer.parseInt(token.toString()));
  }

  final public void inc_number() throws ParseException {
    jj_consume_token(POSITIVE);
                 amount = Integer.parseInt(token.toString());
  }

  final public void month_or_day_or_week_number() throws ParseException {
    if (jj_2_35(2)) {
      jj_consume_token(POSITIVE);
                 monthorday = Integer.parseInt(token.toString());  week = -1;
    } else if (jj_2_36(2)) {
      jj_consume_token(28);
      jj_consume_token(POSITIVE);
                        monthorday = -1; week = Integer.parseInt(token.toString());
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void day_of_month_or_week_number() throws ParseException {
    jj_consume_token(POSITIVE);
        if (monthorday > 0) {
            cal.set(Calendar.MONTH, monthorday - 1);
            monthorday = -1;
            cal.set(Calendar.DAY_OF_MONTH, Integer.parseInt(token.toString()));
        } else {
            cal.set(Calendar.WEEK_OF_YEAR, week);
            week = -1;
            int day = (Integer.parseInt(token.toString()) + 1) % 7; if (day == 0) day = 7;
            cal.set(Calendar.DAY_OF_WEEK, day);
        }
  }

  final public void day_of_year_number() throws ParseException {
    jj_consume_token(POSITIVE);
                 cal.set(Calendar.DAY_OF_YEAR, Integer.parseInt(token.toString()));
  }

  final public void day_of_week_number() throws ParseException {
    jj_consume_token(POSITIVE);
                 cal.set(Calendar.DAY_OF_WEEK, Integer.parseInt(token.toString()));
  }

  final public void hour_number() throws ParseException {
    jj_consume_token(POSITIVE);
                 cal.set(Calendar.HOUR_OF_DAY, Integer.parseInt(token.toString()));
  }

  final public void minute_number() throws ParseException {
    jj_consume_token(POSITIVE);
                 cal.set(Calendar.MINUTE, Integer.parseInt(token.toString())); cal.set(Calendar.SECOND, 0); cal.set(Calendar.MILLISECOND, 0);
  }

  final public void second_number() throws ParseException {
    jj_consume_token(POSITIVE);
                 cal.set(Calendar.SECOND, Integer.parseInt(token.toString())); cal.set(Calendar.MILLISECOND, 0);
  }

  final public void millisecond_number() throws ParseException {
    jj_consume_token(THOUSANDS);
                  cal.set(Calendar.MILLISECOND, Integer.parseInt(token.toString().substring(1)));
  }

  final public void increment() throws ParseException {
    if (jj_2_37(2)) {
      jj_consume_token(27);
      inc_number();
      inc_period();
                                   cal.add(field, amount * factor); factor = 1;
    } else if (jj_2_38(2)) {
      jj_consume_token(NEXT);
      inc_period();
                            cal.add(field, 1 * factor); factor = 1;
    } else if (jj_2_39(2)) {
      jj_consume_token(PREVIOUS);
      inc_period();
                                cal.add(field, -1 * factor); factor = 1;
    } else if (jj_2_40(2)) {
      next();
      day_of_week();
                            beginOfDay(); if (cal.getTime().getTime() < prev) {cal.add(Calendar.DAY_OF_YEAR, 7); }
    } else if (jj_2_41(2)) {
      previous();
      day_of_week();
                                beginOfDay(); if (cal.getTime().getTime() > prev) {cal.add(Calendar.DAY_OF_YEAR, -7); }
    } else if (jj_2_42(2)) {
      jj_consume_token(THIS);
      day_of_week();
                           beginOfDay();
    } else if (jj_2_43(2)) {
      next();
      month_of_year();
                              beginOfMonth(); if (cal.getTime().getTime() < prev) {cal.add(Calendar.YEAR, 1); }
    } else if (jj_2_44(2)) {
      previous();
      month_of_year();
                                  beginOfMonth(); if (cal.getTime().getTime() > prev) {cal.add(Calendar.YEAR, -1); }
    } else if (jj_2_45(2)) {
      jj_consume_token(THIS);
      month_of_year();
                              beginOfMonth();
    } else if (jj_2_46(2)) {
      jj_consume_token(THIS);
      to_period();
    } else if (jj_2_47(2)) {
      jj_consume_token(29);
               cal.add(Calendar.MILLISECOND, (int) (random.nextGaussian() * 1200000.0)/* 20 min */ + 300000 /* 5 minutes late on average*/); dynamic = true;
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void decrement() throws ParseException {
    jj_consume_token(18);
    inc_number();
    inc_period();
                                    cal.add(field, -1 * amount * factor); factor = 1;
  }

  final public void to_period() throws ParseException {
                     cal = getInstance();
    this_period();
  }

  final public void inc_period() throws ParseException {
    if (jj_2_48(2)) {
      jj_consume_token(30);
             field = Calendar.SECOND;
    } else if (jj_2_49(2)) {
      jj_consume_token(31);
              field = Calendar.MINUTE;
    } else if (jj_2_50(2)) {
      jj_consume_token(32);
              field = Calendar.HOUR;
    } else if (jj_2_51(2)) {
      jj_consume_token(33);
              field = Calendar.DAY_OF_YEAR;
    } else if (jj_2_52(2)) {
      jj_consume_token(34);
              field = Calendar.WEEK_OF_YEAR;
    } else if (jj_2_53(2)) {
      jj_consume_token(35);
               field = Calendar.MONTH;
    } else if (jj_2_54(2)) {
      jj_consume_token(36);
               field = Calendar.YEAR;
    } else if (jj_2_55(2)) {
      jj_consume_token(37);
                  field = Calendar.YEAR; factor =  100;
    } else if (jj_2_56(2)) {
      jj_consume_token(38);
                   field = Calendar.MILLISECOND;
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void this_period() throws ParseException {
    if (jj_2_57(2)) {
      jj_consume_token(30);
              cal.set(Calendar.MILLISECOND, 0);
    } else if (jj_2_58(2)) {
      jj_consume_token(31);
                beginOfMinute();
    } else if (jj_2_59(2)) {
      jj_consume_token(32);
              beginOfHour();
    } else if (jj_2_60(2)) {
      jj_consume_token(33);
             beginOfDay();
    } else if (jj_2_61(2)) {
      jj_consume_token(34);
              beginOfWeek();
    } else if (jj_2_62(2)) {
      jj_consume_token(35);
              beginOfMonth();
    } else if (jj_2_63(2)) {
      jj_consume_token(36);
              beginOfYear();
    } else if (jj_2_64(2)) {
      jj_consume_token(37);
                beginOfCentury(false);
    } else if (jj_2_65(2)) {
      jj_consume_token(39);
                         beginOfCentury(true);
    } else if (jj_2_66(2)) {
      jj_consume_token(40);
            beginOfEra();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void day_of_week() throws ParseException {
    // If you don't do this. '2005-01-01 this monday' parses to something odd. Which I don't quite understand.
    cal.getTime();
    if (jj_2_67(2)) {
      jj_consume_token(41);
             cal.set(Calendar.DAY_OF_WEEK, Calendar.SUNDAY);
    } else if (jj_2_68(2)) {
      jj_consume_token(42);
               cal.set(Calendar.DAY_OF_WEEK, Calendar.MONDAY);
    } else if (jj_2_69(2)) {
      jj_consume_token(43);
              cal.set(Calendar.DAY_OF_WEEK, Calendar.TUESDAY);
    } else if (jj_2_70(2)) {
      jj_consume_token(44);
                cal.set(Calendar.DAY_OF_WEEK, Calendar.WEDNESDAY);
    } else if (jj_2_71(2)) {
      jj_consume_token(45);
               cal.set(Calendar.DAY_OF_WEEK, Calendar.THURSDAY);
    } else if (jj_2_72(2)) {
      jj_consume_token(46);
             cal.set(Calendar.DAY_OF_WEEK, Calendar.FRIDAY);
    } else if (jj_2_73(2)) {
      jj_consume_token(47);
               cal.set(Calendar.DAY_OF_WEEK, Calendar.SATURDAY);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void month_of_year() throws ParseException {
    if (jj_2_74(2)) {
      jj_consume_token(48);
              cal.set(Calendar.MONTH, Calendar.JANUARY);
    } else if (jj_2_75(2)) {
      jj_consume_token(49);
               cal.set(Calendar.MONTH, Calendar.FEBRUARY);
    } else if (jj_2_76(2)) {
      jj_consume_token(50);
            cal.set(Calendar.MONTH, Calendar.MARCH);
    } else if (jj_2_77(2)) {
      jj_consume_token(51);
            cal.set(Calendar.MONTH, Calendar.APRIL);
    } else if (jj_2_78(2)) {
      jj_consume_token(52);
          cal.set(Calendar.MONTH, Calendar.MAY);
    } else if (jj_2_79(2)) {
      jj_consume_token(53);
           cal.set(Calendar.MONTH, Calendar.JUNE);
    } else if (jj_2_80(2)) {
      jj_consume_token(54);
           cal.set(Calendar.MONTH, Calendar.JULY);
    } else if (jj_2_81(2)) {
      jj_consume_token(55);
             cal.set(Calendar.MONTH, Calendar.AUGUST);
    } else if (jj_2_82(2)) {
      jj_consume_token(56);
                cal.set(Calendar.MONTH, Calendar.SEPTEMBER);
    } else if (jj_2_83(2)) {
      jj_consume_token(57);
              cal.set(Calendar.MONTH, Calendar.OCTOBER);
    } else if (jj_2_84(2)) {
      jj_consume_token(58);
               cal.set(Calendar.MONTH, Calendar.NOVEMBER);
    } else if (jj_2_85(2)) {
      jj_consume_token(59);
               cal.set(Calendar.MONTH, Calendar.DECEMBER);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void next() throws ParseException {
    jj_consume_token(NEXT);
             prev = cal.getTime().getTime();
  }

  final public void previous() throws ParseException {
    jj_consume_token(PREVIOUS);
                 prev = cal.getTime().getTime();
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3_34()) return true;
    }
    return false;
  }

  private boolean jj_3_34() {
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_17()) return true;
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_scan_token(27)) return true;
    return false;
  }

  private boolean jj_3R_17() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3_32()) return true;
    }
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(18)) return true;
    return false;
  }

  private boolean jj_3_30() {
    if (jj_scan_token(26)) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_5()) return true;
    return false;
  }

  private boolean jj_3_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) return true;
    }
    return false;
  }

  private boolean jj_3_10() {
    if (jj_scan_token(13)) return true;
    if (jj_3R_8()) return true;
    return false;
  }

  private boolean jj_3R_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) return true;
    }
    return false;
  }

  private boolean jj_3_29() {
    if (jj_scan_token(TIMEZONE)) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_scan_token(25)) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_scan_token(24)) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_scan_token(23)) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_scan_token(22)) return true;
    return false;
  }

  private boolean jj_3_24() {
    if (jj_scan_token(21)) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_scan_token(20)) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_scan_token(TO)) return true;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_21() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3_20() {
    if (jj_scan_token(19)) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(12)) return true;
    return false;
  }

  private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) jj_scanpos = xsp;
    if (jj_3R_3()) return true;
    return false;
  }

  private boolean jj_3R_4() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_4()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_3()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_11()) return true;
    if (jj_scan_token(18)) return true;
    if (jj_3R_12()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(17)) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(PREVIOUS)) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(16)) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(15)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(14)) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(NEXT)) return true;
    return false;
  }

  private boolean jj_3R_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(13)) return true;
    return false;
  }

  private boolean jj_3_85() {
    if (jj_scan_token(59)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_2()) return true;
    return false;
  }

  private boolean jj_3_84() {
    if (jj_scan_token(58)) return true;
    return false;
  }

  private boolean jj_3_83() {
    if (jj_scan_token(57)) return true;
    return false;
  }

  private boolean jj_3_82() {
    if (jj_scan_token(56)) return true;
    return false;
  }

  private boolean jj_3_81() {
    if (jj_scan_token(55)) return true;
    return false;
  }

  private boolean jj_3_80() {
    if (jj_scan_token(54)) return true;
    return false;
  }

  private boolean jj_3_79() {
    if (jj_scan_token(53)) return true;
    return false;
  }

  private boolean jj_3_78() {
    if (jj_scan_token(52)) return true;
    return false;
  }

  private boolean jj_3_77() {
    if (jj_scan_token(51)) return true;
    return false;
  }

  private boolean jj_3_76() {
    if (jj_scan_token(50)) return true;
    return false;
  }

  private boolean jj_3_75() {
    if (jj_scan_token(49)) return true;
    return false;
  }

  private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) {
    jj_scanpos = xsp;
    if (jj_3_75()) {
    jj_scanpos = xsp;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_3_78()) {
    jj_scanpos = xsp;
    if (jj_3_79()) {
    jj_scanpos = xsp;
    if (jj_3_80()) {
    jj_scanpos = xsp;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3_85()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_74() {
    if (jj_scan_token(48)) return true;
    return false;
  }

  private boolean jj_3_73() {
    if (jj_scan_token(47)) return true;
    return false;
  }

  private boolean jj_3_72() {
    if (jj_scan_token(46)) return true;
    return false;
  }

  private boolean jj_3_71() {
    if (jj_scan_token(45)) return true;
    return false;
  }

  private boolean jj_3_68() {
    if (jj_scan_token(42)) return true;
    return false;
  }

  private boolean jj_3_70() {
    if (jj_scan_token(44)) return true;
    return false;
  }

  private boolean jj_3_69() {
    if (jj_scan_token(43)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) {
    jj_scanpos = xsp;
    if (jj_3_70()) {
    jj_scanpos = xsp;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3_73()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_67() {
    if (jj_scan_token(41)) return true;
    return false;
  }

  private boolean jj_3_66() {
    if (jj_scan_token(40)) return true;
    return false;
  }

  private boolean jj_3_65() {
    if (jj_scan_token(39)) return true;
    return false;
  }

  private boolean jj_3_63() {
    if (jj_scan_token(36)) return true;
    return false;
  }

  private boolean jj_3_64() {
    if (jj_scan_token(37)) return true;
    return false;
  }

  private boolean jj_3_62() {
    if (jj_scan_token(35)) return true;
    return false;
  }

  private boolean jj_3_61() {
    if (jj_scan_token(34)) return true;
    return false;
  }

  private boolean jj_3_60() {
    if (jj_scan_token(33)) return true;
    return false;
  }

  private boolean jj_3_59() {
    if (jj_scan_token(32)) return true;
    return false;
  }

  private boolean jj_3_58() {
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_57()) {
    jj_scanpos = xsp;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) {
    jj_scanpos = xsp;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) {
    jj_scanpos = xsp;
    if (jj_3_62()) {
    jj_scanpos = xsp;
    if (jj_3_63()) {
    jj_scanpos = xsp;
    if (jj_3_64()) {
    jj_scanpos = xsp;
    if (jj_3_65()) {
    jj_scanpos = xsp;
    if (jj_3_66()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_57() {
    if (jj_scan_token(30)) return true;
    return false;
  }

  private boolean jj_3_55() {
    if (jj_scan_token(37)) return true;
    return false;
  }

  private boolean jj_3_56() {
    if (jj_scan_token(38)) return true;
    return false;
  }

  private boolean jj_3_54() {
    if (jj_scan_token(36)) return true;
    return false;
  }

  private boolean jj_3_53() {
    if (jj_scan_token(35)) return true;
    return false;
  }

  private boolean jj_3_52() {
    if (jj_scan_token(34)) return true;
    return false;
  }

  private boolean jj_3_51() {
    if (jj_scan_token(33)) return true;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_scan_token(32)) return true;
    return false;
  }

  private boolean jj_3_49() {
    if (jj_scan_token(31)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) {
    jj_scanpos = xsp;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_48() {
    if (jj_scan_token(30)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_6() {
    if (jj_scan_token(18)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3_47() {
    if (jj_scan_token(29)) return true;
    return false;
  }

  private boolean jj_3_46() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_45() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3_44() {
    if (jj_3R_21()) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3_43() {
    if (jj_3R_20()) return true;
    if (jj_3R_14()) return true;
    return false;
  }

  private boolean jj_3_41() {
    if (jj_3R_21()) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_scan_token(THIS)) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_20()) return true;
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3_39() {
    if (jj_scan_token(PREVIOUS)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_scan_token(NEXT)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  private boolean jj_3R_5() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_37() {
    if (jj_scan_token(27)) return true;
    if (jj_3R_18()) return true;
    return false;
  }

  private boolean jj_3R_7() {
    if (jj_scan_token(THOUSANDS)) return true;
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_9() {
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_10() {
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(28)) return true;
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) return true;
    }
    return false;
  }

  private boolean jj_3_35() {
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(POSITIVE)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_2()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_scan_token(18)) return true;
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_7()) return true;
    return false;
  }

  private boolean jj_3R_15() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_6()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public DateParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[85];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public DateParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public DateParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new DateParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public DateParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new DateParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public DateParser(DateParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(DateParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[60];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 60; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 85; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
