/*
 * Decompiled with CFR 0.152.
 */
package org.miracum.kafka.serializers;

import ca.uhn.fhir.context.FhirContext;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class KafkaFhirSerializer
implements Serializer<IBaseResource> {
    private static final FhirContext defaultFhirContext = FhirContext.forR4();
    private FhirContext fhirContext = defaultFhirContext;

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (configs.containsKey("fhir.context")) {
            this.fhirContext = (FhirContext)configs.get("fhir.context");
        }
    }

    public byte[] serialize(String topic, IBaseResource data) {
        Objects.requireNonNull(data);
        return this.fhirContext.newJsonParser().encodeResourceToString(data).getBytes(StandardCharsets.UTF_8);
    }

    public byte[] serialize(String topic, Headers headers, IBaseResource data) {
        return this.serialize(topic, data);
    }

    public void close() {
    }
}

