/*
 * Decompiled with CFR 0.152.
 */
package org.miracum.kafka.serializers;

import ca.uhn.fhir.context.FhirContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class KafkaFhirDeserializer
implements Deserializer<IBaseResource> {
    private static final FhirContext defaultFhirContext = FhirContext.forR4();
    private FhirContext fhirContext = defaultFhirContext;

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (configs.containsKey("fhir.context")) {
            this.fhirContext = (FhirContext)configs.get("fhir.context");
        }
    }

    public IBaseResource deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        return this.fhirContext.newJsonParser().parseResource((InputStream)new ByteArrayInputStream(data));
    }

    public IBaseResource deserialize(String topic, Headers headers, byte[] data) {
        return this.deserialize(topic, data);
    }

    public void close() {
    }
}

