/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.util.Properties;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.config.Configurable;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.MappingDecoder;
import org.milyn.util.ClassUtil;

@DecodeType(value={Enum.class})
public class EnumDecoder
implements DataDecoder,
Configurable {
    private Properties configuration;
    private Class enumType;
    private MappingDecoder mappingDecoder = new MappingDecoder();

    public void setConfiguration(Properties resourceConfig) throws SmooksConfigurationException {
        String enumTypeName = resourceConfig.getProperty("enumType");
        if (enumTypeName == null || enumTypeName.trim().equals("")) {
            throw new SmooksConfigurationException("Invalid EnumDecoder configuration. 'enumType' param not specified.");
        }
        try {
            this.enumType = ClassUtil.forName(enumTypeName.trim(), EnumDecoder.class);
        }
        catch (ClassNotFoundException e) {
            throw new SmooksConfigurationException("Invalid Enum decoder configuration.  Failed to resolve '" + enumTypeName + "' as a Java Enum Class.", e);
        }
        if (!Enum.class.isAssignableFrom(this.enumType)) {
            throw new SmooksConfigurationException("Invalid Enum decoder configuration.  Resolved 'enumType' '" + enumTypeName + "' is not a Java Enum Class.");
        }
        this.mappingDecoder.setConfiguration(resourceConfig);
        this.mappingDecoder.setStrict(false);
        this.configuration = resourceConfig;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setEnumType(Class enumType) {
        this.enumType = enumType;
    }

    public Object decode(String data) throws DataDecodeException {
        String mappedValue = (String)this.mappingDecoder.decode(data);
        try {
            return Enum.valueOf(this.enumType, mappedValue.trim());
        }
        catch (IllegalArgumentException e) {
            throw new DataDecodeException("Failed to decode '" + mappedValue + "' as a valid Enum constant of type '" + this.enumType.getName() + "'.");
        }
    }
}

