/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.openapi.swaggerui;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@ApplicationScoped
public class WhiteLabel {
    private static final Logger log = Logger.getLogger(WhiteLabel.class.getName());
    private final String LOGO_FILE_NAME = "openapi.png";
    private final String CSS_FILE_NAME = "openapi.css";
    private final String HTML_FILE_NAME = "openapi.html";
    private byte[] logo = null;
    private String css = null;
    private String html = null;
    private static final String NL = "\n";

    @PostConstruct
    public void init() {
        try (InputStream logoStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("openapi.png");){
            if (logoStream != null) {
                this.logo = logoStream.readAllBytes();
            } else {
                log.log(Level.FINEST, "Can not load whilelable logo [{0}]", "openapi.png");
            }
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Can not load whilelable logo [{0}] - {1}", new Object[]{"openapi.png", ex.getMessage()});
        }
        try (InputStream cssStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("openapi.css");){
            if (cssStream != null) {
                this.css = this.toString(cssStream);
            } else {
                log.log(Level.FINEST, "Can not load whilelable css [{0}]", "openapi.css");
            }
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Can not load whilelable css [{0}] - {1}", new Object[]{"openapi.css", ex.getMessage()});
        }
        try (InputStream htmlStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("openapi.html");){
            if (htmlStream != null) {
                this.html = this.toString(htmlStream);
            } else {
                log.log(Level.FINEST, "Can not load whilelable html [{0}]", "openapi.html");
            }
        }
        catch (IOException ex) {
            log.log(Level.FINEST, "Can not load whilelable html [{0}] - {1}", new Object[]{"openapi.html", ex.getMessage()});
        }
    }

    public boolean hasLogo() {
        return this.logo != null;
    }

    public boolean hasCss() {
        return this.css != null;
    }

    public boolean hasHtml() {
        return this.html != null;
    }

    private String toString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining(NL));
            return string;
        }
    }

    public byte[] getLogo() {
        return this.logo;
    }

    public String getCss() {
        return this.css;
    }

    public String getHtml() {
        return this.html;
    }
}

