/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.openapi.swaggerui;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.microprofileext.openapi.swaggerui.RequestInfo;
import org.microprofileext.openapi.swaggerui.WhiteLabel;

@ApplicationScoped
public class Templates {
    private static final Logger log = Logger.getLogger(Templates.class.getName());
    private byte[] originalLogo = null;
    private String style = null;
    @Inject
    private WhiteLabel whiteLabel;
    private String swaggerUIHtml = null;
    private static final String X_REQUEST_URI = "x-request-uri";
    private static final List<String> KNOWN_PROPERTIES = Arrays.asList("openapi.ui.serverVisibility", "openapi.ui.exploreFormVisibility", "openapi.ui.swaggerHeaderVisibility", "openapi.ui.copyrightBy", "openapi.ui.copyrightYear", "openapi.ui.title", "openapi.ui.contextRoot", "openapi.ui.yamlUrl", "openapi.ui.swaggerUiTheme");
    @Inject
    @ConfigProperty(name="openapi.ui.copyrightBy")
    private Optional<String> copyrightBy;
    @Inject
    @ConfigProperty(name="openapi.ui.copyrightYear")
    private Optional<String> copyrightYear;
    @Inject
    @ConfigProperty(name="openapi.ui.title", defaultValue="MicroProfile - Open API")
    private String title;
    @Inject
    @ConfigProperty(name="openapi.ui.contextRoot")
    private Optional<String> contextRoot;
    @Inject
    @ConfigProperty(name="openapi.ui.yamlUrl", defaultValue="/openapi")
    private String yamlUrl;
    @Inject
    @ConfigProperty(name="openapi.ui.swaggerUiTheme", defaultValue="flattop")
    private String swaggerUiTheme;
    @Inject
    @ConfigProperty(name="openapi.ui.swaggerHeaderVisibility", defaultValue="visible")
    private String swaggerHeaderVisibility;
    @Inject
    @ConfigProperty(name="openapi.ui.exploreFormVisibility", defaultValue="hidden")
    private String exploreFormVisibility;
    @Inject
    @ConfigProperty(name="openapi.ui.serverVisibility", defaultValue="hidden")
    private String serverVisibility;
    @Inject
    @ConfigProperty(name="openapi.ui.createdWithVisibility", defaultValue="visible")
    private String createdWithVisibility;
    @Inject
    @ConfigProperty(name="openapi.ui.modelsVisibility", defaultValue="visible")
    private String modelsVisibility;
    @Inject
    @ConfigProperty(name="openapi.ui.oauth2RedirectUri", defaultValue="/oauth2-redirect.html")
    private String oauth2RedirectUri;
    @Inject
    private Config config;
    private static final String VAR_COPYRIGHT_BY = "%copyrighBy%";
    private static final String VAR_TITLE = "%title%";
    private static final String VAR_CURRENT_YEAR = "%currentYear%";
    private static final String VAR_CONTEXT_ROOT = "%contextRoot%";
    private static final String VAR_YAML_URL = "%yamlUrl%";
    private static final String VAR_SWAGGER_THEME = "%swaggerUiTheme%";
    private static final String VAR_SWAGGER_HEADER_VISIBILITY = "%swaggerHeaderVisibility%";
    private static final String VAR_EXPLORE_FORM_VISIBILITY = "%exploreFormVisibility%";
    private static final String VAR_SERVER_VISIBILITY = "%serverVisibility%";
    private static final String VAR_SERVER_VISIBILITY_BLOCK_SIZE = "%serverVisibilityBlockSize%";
    private static final String VAR_CREATED_WITH_VISIBILITY = "%createdWithVisibility%";
    private static final String VAR_OAUTH2_REDIRECT_URI = "%oauth2RedirectUri%";
    private static final String PERSENTAGE = "%";
    private static final String NL = "\n";
    private static final String EMPTY = "";
    private static final String FILE_TEMPLATE = "META-INF/resources/templates/template.html";
    private static final String FILE_LOGO = "META-INF/resources/templates/logo.png";
    private static final String FILE_STYLE = "META-INF/resources/templates/style.css";
    private static final String KEY_IDENTIFIER = "openapi.ui.";

    @PostConstruct
    public void afterCreate() {
        this.originalLogo = this.getLogo();
        log.finest("OpenApi UI: Created logo");
        this.style = this.getCss();
    }

    public String getSwaggerUIHtml(RequestInfo requestInfo) {
        if (this.swaggerUIHtml == null) {
            this.swaggerUIHtml = this.parseHtmlTemplate(requestInfo);
        }
        return this.swaggerUIHtml;
    }

    private String parseHtmlTemplate(RequestInfo requestInfo) {
        String html = this.getHTMLTemplate();
        html = html.replaceAll(VAR_CONTEXT_ROOT, this.getContextRoot(requestInfo));
        html = html.replaceAll(VAR_YAML_URL, this.yamlUrl);
        html = html.replaceAll(VAR_CURRENT_YEAR, this.getCopyrightYear());
        html = html.replaceAll(VAR_OAUTH2_REDIRECT_URI, this.oauth2RedirectUri);
        try {
            Iterable propertyNames = this.config.getPropertyNames();
            for (String key : propertyNames) {
                if (!key.startsWith(KEY_IDENTIFIER) || this.isKnownProperty(key)) continue;
                String htmlKey = PERSENTAGE + key + PERSENTAGE;
                html = html.replaceAll(htmlKey, (String)this.config.getValue(key, String.class));
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.log(Level.WARNING, "Can not replace dynamic properties in the Open API Swagger template. {0}", uoe.getMessage());
        }
        html = html.replaceAll(VAR_COPYRIGHT_BY, this.getCopyrightBy());
        html = html.replaceAll(VAR_TITLE, this.title);
        html = html.replaceAll(VAR_SWAGGER_THEME, this.swaggerUiTheme);
        if ("hidden".equalsIgnoreCase(this.modelsVisibility)) {
            String domId = "dom_id: '#swagger-ui',";
            html = html.replaceAll(domId, domId + "\n                    defaultModelsExpandDepth: -1,");
        }
        return html;
    }

    private String getOriginalContextPath(RequestInfo requestInfo) {
        String xRequestUriHeader = requestInfo.getHttpHeaders().getHeaderString(X_REQUEST_URI);
        if (xRequestUriHeader != null && !xRequestUriHeader.isEmpty()) {
            return this.getContextPathPart(requestInfo, xRequestUriHeader);
        }
        return requestInfo.getContextPath();
    }

    private String getContextPathPart(RequestInfo requestInfo, String xRequestUriHeader) {
        String restBase = requestInfo.getRestPath();
        String restUrl = restBase + requestInfo.getUriInfo().getPath();
        int restUrlStart = xRequestUriHeader.indexOf(restUrl);
        if (restUrlStart > 0) {
            return xRequestUriHeader.substring(0, restUrlStart);
        }
        return xRequestUriHeader;
    }

    private String toString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining(NL));
            return string;
        }
    }

    private byte[] getLogo() {
        if (this.whiteLabel.hasLogo()) {
            return this.whiteLabel.getLogo();
        }
        InputStream logoStream = this.getClass().getClassLoader().getResourceAsStream(FILE_LOGO);
        try {
            if (logoStream != null) {
                return logoStream.readAllBytes();
            }
        }
        catch (IOException ex) {
            log.warning(ex.getMessage());
        }
        return null;
    }

    private String getCss() {
        String rawcss;
        if (this.whiteLabel.hasCss()) {
            rawcss = this.whiteLabel.getCss();
        } else {
            try (InputStream css = this.getClass().getClassLoader().getResourceAsStream(FILE_STYLE);){
                rawcss = this.toString(css);
            }
            catch (IOException ex) {
                return EMPTY;
            }
        }
        rawcss = rawcss.replaceAll(VAR_SWAGGER_HEADER_VISIBILITY, this.swaggerHeaderVisibility);
        rawcss = rawcss.replaceAll(VAR_EXPLORE_FORM_VISIBILITY, this.exploreFormVisibility);
        rawcss = rawcss.replaceAll(VAR_SERVER_VISIBILITY, this.serverVisibility);
        rawcss = rawcss.replaceAll(VAR_SERVER_VISIBILITY_BLOCK_SIZE, this.getServerVisibilityBlockSize());
        rawcss = rawcss.replaceAll(VAR_CREATED_WITH_VISIBILITY, this.createdWithVisibility);
        return rawcss;
    }

    private String getServerVisibilityBlockSize() {
        if (this.serverVisibility.equals("hidden")) {
            return "0px";
        }
        return "auto";
    }

    private String getHTMLTemplate() {
        String string;
        block9: {
            if (this.whiteLabel.hasHtml()) {
                return this.whiteLabel.getHtml();
            }
            InputStream template = this.getClass().getClassLoader().getResourceAsStream(FILE_TEMPLATE);
            try {
                string = this.toString(template);
                if (template == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (template != null) {
                        try {
                            template.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return EMPTY;
                }
            }
            template.close();
        }
        return string;
    }

    private String getCopyrightYear() {
        if (this.copyrightYear.isPresent()) {
            return this.copyrightYear.get();
        }
        return String.valueOf(Calendar.getInstance().get(1));
    }

    private String getCopyrightBy() {
        if (this.copyrightBy.isPresent()) {
            return this.copyrightBy.get();
        }
        return EMPTY;
    }

    private String getContextRoot(RequestInfo requestInfo) {
        if (this.contextRoot.isPresent()) {
            return this.contextRoot.get();
        }
        return this.getOriginalContextPath(requestInfo);
    }

    private boolean isKnownProperty(String key) {
        return KNOWN_PROPERTIES.contains(key);
    }

    public byte[] getOriginalLogo() {
        return this.originalLogo;
    }

    public String getStyle() {
        return this.style;
    }
}

