/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.openapi.swaggerui;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;

public class RequestInfo {
    private UriInfo uriInfo;
    private HttpHeaders httpHeaders;
    private static final String EMPTY = "";
    private static final String SLASH = "/";

    public String getContextPath() {
        if (!this.isValid()) {
            return EMPTY;
        }
        String path = this.uriInfo.getBaseUri().getPath();
        return this.getContextPath(path);
    }

    public String getContextPath(String path) {
        if (path.startsWith(SLASH)) {
            path = path.substring(1);
        }
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length());
        }
        if (path.contains(SLASH)) {
            return SLASH + path.substring(0, path.indexOf(SLASH));
        }
        return EMPTY;
    }

    public String getRestPath() {
        if (!this.isValid()) {
            return EMPTY;
        }
        String path = this.uriInfo.getBaseUri().getPath();
        return this.getRestPath(path);
    }

    public String getRestPath(String path) {
        if (path.startsWith(SLASH)) {
            path = path.substring(1);
        }
        if (path.endsWith(SLASH)) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.contains(SLASH)) {
            return path.substring(path.indexOf(SLASH));
        }
        return SLASH + path;
    }

    private boolean isValid() {
        if (this.uriInfo == null) {
            return false;
        }
        URI baseUri = this.uriInfo.getBaseUri();
        if (baseUri == null) {
            return false;
        }
        String path = baseUri.getPath();
        return path != null && !path.isEmpty();
    }

    public RequestInfo(UriInfo uriInfo, HttpHeaders httpHeaders) {
        this.uriInfo = uriInfo;
        this.httpHeaders = httpHeaders;
    }

    public RequestInfo() {
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }
}

