/*
 * Decompiled with CFR 0.152.
 */
package org.microprofileext.openapi.swaggerui;

import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.logging.Logger;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.microprofileext.openapi.swaggerui.RequestInfo;
import org.microprofileext.openapi.swaggerui.Templates;

@Path(value="/openapi-ui/")
@PermitAll
public class OpenApiUiService {
    private static final Logger log = Logger.getLogger(OpenApiUiService.class.getName());
    @Inject
    private Templates templates;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders httpHeaders;
    private static final String INDEX_HTML = "index.html";

    @GET
    @Produces(value={"image/png"})
    @Path(value="logo.png")
    @Operation(hidden=true)
    public byte[] getLogo() {
        return this.templates.getOriginalLogo();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="index.html")
    @Operation(hidden=true)
    public Response getOpenApiUI() {
        RequestInfo requestInfo = new RequestInfo(this.uriInfo, this.httpHeaders);
        String swaggerUI = this.templates.getSwaggerUIHtml(requestInfo);
        return Response.ok((Object)swaggerUI, (String)"text/html").build();
    }

    @GET
    @Produces(value={"text/css"})
    @Path(value="style.css")
    @Operation(hidden=true)
    public Response getCss() {
        String css = this.templates.getStyle();
        return Response.ok((Object)css, (String)"text/css").build();
    }

    @GET
    @Produces(value={"text/html"})
    @Operation(hidden=true)
    public Response getSwaggerUINaked() {
        URI fw = this.uriInfo.getRequestUriBuilder().path(INDEX_HTML).build(new Object[0]);
        return Response.temporaryRedirect((URI)fw).build();
    }
}

