/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.reference;

import java.util.Iterator;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.microbean.bean.AttributedType;
import org.microbean.bean.AutoCloseableRegistry;
import org.microbean.bean.Bean;
import org.microbean.bean.BeanReduction;
import org.microbean.bean.Creation;
import org.microbean.bean.DefaultAutoCloseableRegistry;
import org.microbean.bean.Destruction;
import org.microbean.bean.Id;
import org.microbean.bean.References;
import org.microbean.bean.Selectable;
import org.microbean.construct.Domain;
import org.microbean.reference.ClientProxier;
import org.microbean.reference.Instances;

public class Request<I, R>
implements Creation<I>,
Destruction,
References<R> {
    private final AttributedType voidType;
    private final Selectable<? super AttributedType, Bean<?>> s;
    private final Instances instances;
    private final AutoCloseableRegistry acr;
    private final ClientProxier cp;
    private final BeanReduction<I> br;
    private final AttributedType rType;

    public Request(Domain domain, Selectable<? super AttributedType, Bean<?>> s, Instances instances, AutoCloseableRegistry acr, ClientProxier cp, BeanReduction<I> br) {
        this(new AttributedType((TypeMirror)domain.noType(TypeKind.VOID)), s, instances, acr, cp, br);
    }

    private Request(AttributedType voidType, Selectable<? super AttributedType, Bean<?>> s, Instances instances, AutoCloseableRegistry acr, ClientProxier cp, BeanReduction<I> br) {
        this(voidType, s, instances, acr, cp, br, voidType);
    }

    private Request(AttributedType voidType, Selectable<? super AttributedType, Bean<?>> s, Instances instances, AutoCloseableRegistry acr, ClientProxier cp, BeanReduction<I> br, AttributedType rType) {
        if (voidType.type().getKind() != TypeKind.VOID) {
            throw new IllegalArgumentException("voidType");
        }
        this.voidType = voidType;
        this.s = Objects.requireNonNull(s, "s");
        this.instances = Objects.requireNonNull(instances, "instances");
        this.rType = Objects.requireNonNull(rType, "rType");
        this.cp = Objects.requireNonNull(cp, "cp");
        this.acr = acr == null ? new DefaultAutoCloseableRegistry() : acr;
        this.br = br;
    }

    public void close() {
        this.acr.close();
        this.instances.close();
    }

    public Iterator<R> iterator() {
        return new ReferencesIterator();
    }

    private final R get(Request<R, Void> r) {
        Bean bean = r.br.bean();
        Id id = bean.id();
        if (this.instances.proxiable(id)) {
            this.cp.clientProxy(id, this.instances.supplier(bean, r));
        }
        return (R)this.instances.supplier(bean, r).get();
    }

    public <R> References<R> references(AttributedType t) {
        return new Request<I, R>(this.voidType, this.s, this.instances, this.acr, this.cp, this.br, t);
    }

    public boolean destroy(R r) {
        if (r != null) {
            // empty if block
        }
        return false;
    }

    private final class ReferencesIterator
    implements Iterator<R> {
        private final Iterator<Bean<?>> i;
        private R ref;

        private ReferencesIterator() {
            this.i = Request.this.s.select((Object)Request.this.rType).iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public final R next() {
            this.ref = Request.this.get(new Request(Request.this.voidType, Request.this.s, Request.this.instances, Request.this.acr.newChild(), Request.this.cp, new BeanReduction(Request.this.rType, this.i.next()), Request.this.voidType));
            return this.ref;
        }

        @Override
        public final void remove() {
            Object ref = this.ref;
            this.ref = null;
            Request.this.destroy(ref);
        }
    }
}

