/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.reference;

import java.util.List;
import java.util.Objects;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.microbean.bean.BeanTypeList;
import org.microbean.bean.BeanTypes;
import org.microbean.construct.Domain;

public final class ProxySpecification {
    private final Domain domain;
    private final DeclaredType sc;
    private final List<TypeMirror> interfaces;
    private final String name;

    ProxySpecification(Domain domain, BeanTypeList types) {
        this.domain = Objects.requireNonNull(domain, "domain");
        TypeMirror t = types.get(0);
        if (t.getKind() != TypeKind.DECLARED || domain.javaLangObject(t) && types.size() == 1) {
            throw new IllegalArgumentException("types: " + String.valueOf(types));
        }
        if (((DeclaredType)t).asElement().getKind() == ElementKind.INTERFACE) {
            this.sc = (DeclaredType)domain.javaLangObject().asType();
            this.interfaces = types;
        } else {
            if (!BeanTypes.proxiableBeanType((TypeMirror)t)) {
                throw new IllegalArgumentException("types: " + String.valueOf(types));
            }
            this.sc = (DeclaredType)t;
            int interfaceIndex = types.interfaceIndex();
            this.interfaces = interfaceIndex < 0 ? List.of() : types.subList(interfaceIndex, types.size());
        }
        this.name = ProxySpecification.computeName(domain, this.sc, this.interfaces);
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == this.getClass()) {
            ProxySpecification her = (ProxySpecification)other;
            if (!this.domain.equals((Object)her.domain)) {
                return false;
            }
            if (!this.domain.sameType((TypeMirror)this.superclass(), (TypeMirror)her.superclass())) {
                return false;
            }
            List<TypeMirror> interfaces = this.interfaces();
            List<TypeMirror> herInterfaces = her.interfaces();
            int size = interfaces.size();
            if (herInterfaces.size() != size) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (this.domain.sameType(interfaces.get(i), herInterfaces.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final int hashCode() {
        int hashCode = 31;
        hashCode = 17 * hashCode + this.domain.hashCode();
        hashCode = 17 * hashCode + this.sc.hashCode();
        hashCode = 17 * hashCode + this.interfaces.hashCode();
        return hashCode;
    }

    public final List<TypeMirror> interfaces() {
        return this.interfaces;
    }

    public final String name() {
        return this.name;
    }

    public final DeclaredType superclass() {
        return this.sc;
    }

    static final String computeName(Domain domain, DeclaredType superclass, List<TypeMirror> interfaces) {
        DeclaredType proxyClassSibling;
        if (superclass.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException("superclass: " + String.valueOf(superclass));
        }
        if (domain.javaLangObject((TypeMirror)superclass)) {
            if (interfaces.isEmpty()) {
                throw new IllegalArgumentException("interfaces.isEmpty(); superclass: java.lang.Object");
            }
            proxyClassSibling = (DeclaredType)interfaces.get(0);
            if (proxyClassSibling.getKind() != TypeKind.DECLARED) {
                throw new IllegalArgumentException("interfaces: " + String.valueOf(interfaces));
            }
        } else {
            proxyClassSibling = superclass;
        }
        return domain.toString((CharSequence)domain.binaryName((TypeElement)proxyClassSibling.asElement())) + "_Proxy";
    }
}

