/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.reference;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.microbean.bean.AttributedType;
import org.microbean.bean.AutoCloseableRegistry;
import org.microbean.bean.Bean;
import org.microbean.bean.BeanReduction;
import org.microbean.bean.Creation;
import org.microbean.bean.DefaultAutoCloseableRegistry;
import org.microbean.bean.Reducible;
import org.microbean.bean.Request;
import org.microbean.bean.Selectable;
import org.microbean.reference.ClientProxier;
import org.microbean.reference.Instances;

public class DefaultRequest<I>
implements Request<I>,
AutoCloseableRegistry,
Reducible<AttributedType, Bean<?>>,
Selectable<AttributedType, Bean<?>> {
    private static final ThreadLocal<Queue<Request<?>>> REQUESTS = ThreadLocal.withInitial(ArrayDeque::new);
    private final AutoCloseableRegistry acr;
    private final BeanReduction<I> beanReduction;
    private final Creation<I> c;
    private final ClientProxier cp;
    private final Instances instances;
    private final Reducible<AttributedType, Bean<?>> reducible;
    private final Selectable<AttributedType, Bean<?>> selectable;

    public DefaultRequest(Selectable<AttributedType, Bean<?>> selectable, Reducible<AttributedType, Bean<?>> reducible, Instances instances, ClientProxier cp) {
        this(selectable, reducible, instances, null, null, cp, null);
    }

    public DefaultRequest(Selectable<AttributedType, Bean<?>> selectable, Reducible<AttributedType, Bean<?>> reducible, Instances instances, AutoCloseableRegistry acr, Creation<I> c, ClientProxier cp) {
        this(selectable, reducible, instances, acr, c, cp, null);
    }

    private DefaultRequest(Selectable<AttributedType, Bean<?>> selectable, Reducible<AttributedType, Bean<?>> reducible, Instances instances, AutoCloseableRegistry acr, Creation<I> c, ClientProxier cp, BeanReduction<I> beanReduction) {
        this.selectable = Objects.requireNonNull(selectable, "selectable");
        this.reducible = Objects.requireNonNull(reducible, "reducible");
        this.instances = Objects.requireNonNull(instances, "instances");
        this.cp = Objects.requireNonNull(cp, "cp");
        this.beanReduction = beanReduction;
        this.acr = acr == null ? new DefaultAutoCloseableRegistry() : acr;
        this.c = c == null ? i -> {} : c;
    }

    public final BeanReduction<I> beanReduction() {
        return this.beanReduction;
    }

    public <J> DefaultRequest<J> child(BeanReduction<J> beanReduction) {
        if (beanReduction.equals(this.beanReduction)) {
            return this;
        }
        DefaultRequest<I> child = new DefaultRequest<I>(this.selectable, this.reducible, this.instances, this.newChild(), this.c, this.cp, beanReduction);
        if (!this.register((AutoCloseable)((Object)child))) {
            throw new IllegalStateException();
        }
        return child;
    }

    public void close() {
        this.acr.close();
        this.instances.close();
    }

    public boolean closed() {
        return this.acr.closed();
    }

    public final void created(I i) {
        this.c.created(i);
    }

    public final AutoCloseableRegistry newChild() {
        return this.acr.newChild();
    }

    public final Bean<?> reduce(AttributedType attributedType) {
        return (Bean)this.reducible.reduce((Object)attributedType);
    }

    public final <R> R reference(AttributedType attributedType) {
        return this.reference(new BeanReduction(attributedType, this.reduce(attributedType).cast()), this);
    }

    public final <R> R reference(AttributedType attributedType, Creation<R> c) {
        return this.reference(new BeanReduction(attributedType, this.reduce(attributedType).cast()), this.toRequest(c));
    }

    public final <R> R reference(AttributedType attributedType, Bean<R> bean, Creation<R> c) {
        return this.reference(new BeanReduction(attributedType, bean == null ? this.reduce(attributedType).cast() : bean.cast()), this.toRequest(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <R> R reference(BeanReduction<R> beanReduction, Request<R> r) {
        Request request = (r == null ? this : r).child(beanReduction);
        Queue<Request<?>> requests = REQUESTS.get();
        requests.offer(request);
        try {
            Object i = this.instances.proxiable(request) ? this.cp.clientProxy(request, this.instances.supplier(request)) : this.instances.supplier(request).get();
            return (R)i;
        }
        finally {
            requests.poll();
        }
    }

    public boolean register(AutoCloseable closeable) {
        return this.acr.register(closeable);
    }

    public final List<Bean<?>> select(AttributedType attributedType) {
        return this.selectable.select((Object)attributedType);
    }

    private final <R> Request<R> toRequest(Creation<R> c) {
        Creation<R> creation = c;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Request.class}, creation, n)) {
            case -1 -> null;
            case 0 -> {
                Request r = (Request)creation;
                yield r;
            }
            default -> new DefaultRequest<R>(this.selectable, this.reducible, this.instances, this.acr, c, this.cp, this.beanReduction);
        };
    }
}

