/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.reference;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.lang.model.element.TypeElement;
import org.microbean.bean.BeanTypeList;
import org.microbean.bean.Id;
import org.microbean.bean.Request;
import org.microbean.construct.Domain;
import org.microbean.reference.ClientProxier;
import org.microbean.reference.ClientProxy;
import org.microbean.reference.ProxySpecification;
import org.microbean.reference.ReferenceException;

public abstract class AbstractClientProxier<T>
implements ClientProxier {
    private static final System.Logger LOGGER = System.getLogger(AbstractClientProxier.class.getName());
    private static final ConcurrentMap<Key, ClientProxy<?>> clientProxyInstances = new ConcurrentHashMap();
    private final ClassValue<MethodHandle> clientProxyClassConstructorMethodHandles;
    private final Domain domain;

    protected AbstractClientProxier(Domain domain) {
        this.domain = Objects.requireNonNull(domain, "domain");
        this.clientProxyClassConstructorMethodHandles = new ClassValue<MethodHandle>(){

            @Override
            protected final MethodHandle computeValue(Class<?> c) {
                this.getClass().getModule().addReads(c.getModule());
                try {
                    return AbstractClientProxier.this.lookup(c).findConstructor(c, MethodType.methodType(Void.TYPE, Supplier.class)).asType(MethodType.methodType(ClientProxy.class, Supplier.class));
                }
                catch (Error | RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new ReferenceException(e.getMessage(), e);
                }
            }
        };
    }

    protected ClassLoader classLoader(TypeElement e) {
        if (!e.getKind().isDeclaredType()) {
            throw new IllegalArgumentException("e: " + String.valueOf(e));
        }
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public final <R> R clientProxy(Request<R> r, Supplier<? extends R> instanceSupplier) {
        return this.clientProxy(r.beanReduction().bean().id(), instanceSupplier);
    }

    private final <R> R clientProxy(Id id, Supplier<? extends R> instanceSupplier) {
        return this.clientProxy(id.types(), id.attributes(), instanceSupplier);
    }

    final <R> R clientProxy(BeanTypeList types, Object attributes, Supplier<? extends R> instanceSupplier) {
        ClientProxy cp = clientProxyInstances.computeIfAbsent(new Key(new ProxySpecification(this.domain(), types), attributes), k -> {
            try {
                return this.instantiate(k.proxySpecification(), instanceSupplier);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ReferenceException(e.getMessage(), e);
            }
        });
        return (R)cp.$cast();
    }

    private final Class<?> clientProxyClass(ProxySpecification ps) throws ClassNotFoundException {
        Class<?> c;
        String name = ps.name();
        ClassLoader cl = this.classLoader((TypeElement)ps.superclass().asElement());
        try {
            c = cl.loadClass(name);
        }
        catch (ClassNotFoundException primaryLoadException) {
            try {
                c = this.clientProxyClass(this.generate(ps), cl);
                if (c == null) {
                    primaryLoadException = new ClassNotFoundException(name + "; clientProxyClass(generate(" + String.valueOf(ps) + "), " + String.valueOf(cl) + " == null");
                    throw primaryLoadException;
                }
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Proxy class generated because it was not initially found", (Throwable)primaryLoadException);
                }
            }
            catch (ClassNotFoundException | RuntimeException generationException) {
                try {
                    c = cl.loadClass(name);
                }
                catch (ClassNotFoundException secondaryLoadException) {
                    generationException.addSuppressed(primaryLoadException);
                    secondaryLoadException.addSuppressed(generationException);
                    throw secondaryLoadException;
                }
                catch (Error e) {
                    e.addSuppressed(generationException);
                    throw e;
                }
                catch (Throwable wtf) {
                    generationException.addSuppressed(wtf);
                    throw generationException;
                }
            }
            catch (Error e) {
                e.addSuppressed(primaryLoadException);
                throw e;
            }
            catch (Throwable wtf) {
                primaryLoadException.addSuppressed(wtf);
                throw primaryLoadException;
            }
        }
        return c;
    }

    protected Class<?> clientProxyClass(T t, ClassLoader cl) throws ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    protected final Domain domain() {
        return this.domain;
    }

    protected T generate(ProxySpecification ps) throws Throwable {
        throw new UnsupportedOperationException();
    }

    protected <R> ClientProxy<R> instantiate(ProxySpecification ps, Supplier<? extends R> instanceSupplier) throws Throwable {
        return this.instantiate(this.clientProxyClass(ps), instanceSupplier);
    }

    protected <R> ClientProxy<R> instantiate(Class<?> clientProxyClass, Supplier<? extends R> instanceSupplier) throws Throwable {
        return this.clientProxyClassConstructorMethodHandles.get(clientProxyClass).invokeExact(instanceSupplier);
    }

    protected abstract MethodHandles.Lookup lookup(Class<?> var1);

    private record Key(ProxySpecification proxySpecification, Object attributes) {
    }
}

