/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.proxy;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.microbean.construct.Domain;
import org.microbean.proxy.AbstractProxier;
import org.microbean.proxy.ProxySpecification;

public abstract class AbstractToolkitProxier<PS extends ProxySpecification, T>
extends AbstractProxier<PS> {
    private static final System.Logger LOGGER = System.getLogger(AbstractToolkitProxier.class.getName());
    private final MethodHandles.Lookup lookup;

    protected AbstractToolkitProxier(Domain domain, MethodHandles.Lookup lookup) {
        super(domain);
        this.lookup = Objects.requireNonNull(lookup, "lookup");
    }

    protected abstract T generate(PS var1) throws Throwable;

    protected MethodHandles.Lookup lookup(Class<?> c) {
        return this.lookup.in(c);
    }

    protected final Class<?> proxyClass(PS ps) throws ClassNotFoundException {
        Class<?> pc;
        String name = ((ProxySpecification)ps).name();
        ClassLoader cl = this.classLoader();
        try {
            pc = cl.loadClass(name);
        }
        catch (ClassNotFoundException primaryLoadException) {
            try {
                pc = this.proxyClass(this.generate(ps), cl);
                if (pc == null) {
                    primaryLoadException = new ClassNotFoundException(name + "; proxyClass(generate(" + String.valueOf(ps) + "), " + String.valueOf(cl) + " == null");
                    throw primaryLoadException;
                }
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Proxy class generated because it was not initially found", (Throwable)primaryLoadException);
                }
            }
            catch (ClassNotFoundException | RuntimeException generationException) {
                try {
                    pc = cl.loadClass(name);
                }
                catch (ClassNotFoundException secondaryLoadException) {
                    generationException.addSuppressed(primaryLoadException);
                    secondaryLoadException.addSuppressed(generationException);
                    throw secondaryLoadException;
                }
                catch (Error e) {
                    e.addSuppressed(generationException);
                    throw e;
                }
                catch (Throwable wtf) {
                    generationException.addSuppressed(wtf);
                    throw generationException;
                }
            }
            catch (Error e) {
                e.addSuppressed(primaryLoadException);
                throw e;
            }
            catch (Throwable wtf) {
                primaryLoadException.addSuppressed(wtf);
                throw primaryLoadException;
            }
        }
        return pc;
    }

    protected abstract Class<?> proxyClass(T var1, ClassLoader var2) throws ClassNotFoundException;
}

